/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.xml.sax.SAXException;
import s.f.util.InvalidDataException;
import s.f.util.Messages;
import s.f.util.xml.SAXErrorHandler;

public class XMLUtils {
    public static byte[] xsltProcessing(Document sourceDoc, InputStream stylesheetFile) throws TransformerException, InvalidDataException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLUtils.xsltProcessing(sourceDoc, stylesheetFile, (OutputStream)out);
        return out.toByteArray();
    }

    public static void xsltProcessing(Document sourceDoc, InputStream stylesheetFile, OutputStream out) throws TransformerException, InvalidDataException {
        XMLUtils.xsltProcessing(sourceDoc, new StreamSource(stylesheetFile), out);
    }

    public static void xsltProcessing(Document sourceDoc, StreamSource xsltSource, OutputStream out) throws TransformerException, InvalidDataException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        DOMOutputter outputter = new DOMOutputter();
        org.w3c.dom.Document domDocument = null;
        try {
            domDocument = outputter.output(sourceDoc);
        }
        catch (JDOMException e) {
            throw new InvalidDataException(Messages.getString("XMLUtils_loadXML"));
        }
        DOMSource xmlSource = new DOMSource(domDocument);
        StreamResult xmlResult = new StreamResult(out);
        tFactory.newTransformer(xsltSource).transform(xmlSource, xmlResult);
    }

    public static Document loadXML(InputStream xml) throws InvalidDataException {
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build(xml);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new InvalidDataException(Messages.getString("XMLUtils_createXML"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvalidDataException(Messages.getString("XMLUtils_readXML"));
        }
        return doc;
    }

    public static void xsdValidation(InputStream xmlData, InputStream xsdData) throws InvalidDataException {
        SchemaFactory schemaFactory;
        SAXErrorHandler errorHandler = new SAXErrorHandler();
        StreamSource xsdSource = new StreamSource(xsdData);
        StreamSource xmlSource = new StreamSource(xmlData);
        Validator validator = null;
        try {
            schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InvalidDataException(Messages.getString("XMLUtils_loadSchema") + "http://www.w3.org/2001/XMLSchema" + ". ");
        }
        try {
            validator = schemaFactory.newSchema(xsdSource).newValidator();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new InvalidDataException(Messages.getString("XMLUtils_schemaValidation"));
        }
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(xmlSource);
        }
        catch (IOException e) {
            throw new InvalidDataException(Messages.getString("XMLUtils_readXML"));
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new InvalidDataException(Messages.getString("XMLUtils_validationError"));
        }
        if (!errorHandler.getErrors().isEmpty()) {
            InvalidDataException invalidData = new InvalidDataException(Messages.getString("XMLUtils_xmlNotValid"));
            Collection a = errorHandler.getErrors();
            int i = 1;
            Iterator it = a.iterator();
            while (it.hasNext()) {
                invalidData.addError(String.valueOf(i), it.next().toString());
                ++i;
            }
            throw invalidData;
        }
    }
}

