/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.xml;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import s.f.util.Debug;
import s.f.util.xml.XMLParseable;

public class XMLParser {
    public static byte[] createXMLDataSource(Collection list, String rootNodeName, String nodeName) {
        return XMLParser.createXML(XMLParser.createNode(list, rootNodeName, nodeName), Format.getRawFormat());
    }

    public static byte[] createXMLDataSource(Map node, String rootNodeName, String nodeName) {
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(node);
        return XMLParser.createXML(XMLParser.createNode(list, rootNodeName, nodeName));
    }

    public static byte[] createXML(Element root, Format format) {
        return XMLParser.createXML(new Document(root), format);
    }

    public static byte[] createXML(Element root) {
        return XMLParser.createXML(new Document(root));
    }

    public static byte[] createXML(Document document, Format format) {
        XMLOutputter xmlOut = new XMLOutputter();
        byte[] xml = null;
        format.setEncoding("UTF-8");
        xmlOut.setFormat(format);
        try {
            xml = xmlOut.outputString(document).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            xml = xmlOut.outputString(document).getBytes();
        }
        return xml;
    }

    public static byte[] createXML(Document document) {
        return XMLParser.createXML(document, Format.getCompactFormat());
    }

    private static Element createNode(Collection list, String rootNodeName, String nodeName) {
        if (rootNodeName == null || rootNodeName.trim().length() == 0) {
            rootNodeName = "root";
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            nodeName = "node";
        }
        if (list == null) {
            list = new ArrayList();
        }
        Element main = new Element(rootNodeName);
        for (Object obj : list) {
            if (obj == null) continue;
            if (obj instanceof Collection) {
                main.addContent(XMLParser.createNode((ArrayList)obj, nodeName, null));
                continue;
            }
            if (obj instanceof Map) {
                Map data = (Map)obj;
                main.addContent(XMLParser.createChildNode(data, nodeName));
                continue;
            }
            if (obj instanceof XMLParseable) {
                main.addContent(((XMLParseable)obj).toXMLElement());
                continue;
            }
            Debug.print(obj.getClass().getName() + " cannot be parsed to XML.");
        }
        return main;
    }

    private static Element createChildNode(Map data, String nodeName) {
        Iterator keys = data.keySet().iterator();
        Element node = new Element(nodeName.replaceAll("@", "&"));
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Element childNode = null;
            Object objChild = data.get(key);
            if (objChild instanceof Map) {
                node.addContent(XMLParser.createChildNode((Map)objChild, key.toLowerCase()));
                continue;
            }
            if (objChild instanceof Collection) {
                node.addContent(XMLParser.createNode((Collection)objChild, key.toLowerCase(), nodeName));
                continue;
            }
            childNode = new Element(key.toLowerCase());
            Object value = data.get(key);
            childNode.addContent(value != null ? value.toString() : "");
            node.addContent(childNode);
        }
        return node;
    }

    private static Element createChildNodes(Element node, Map data) {
        for (String key : data.keySet()) {
            Element childNode = null;
            Object objChild = data.get(key);
            if (objChild instanceof Map) {
                node.addContent(XMLParser.createChildNode((Map)objChild, key.toLowerCase()));
                continue;
            }
            if (objChild instanceof Collection) {
                node.addContent(XMLParser.createNode((Collection)objChild, key.toLowerCase(), node.getName()));
                continue;
            }
            try {
                childNode = new Element(key.toLowerCase());
                childNode.addContent(data.get(key) != null ? data.get(key).toString() : "");
                node.addContent(childNode);
            }
            catch (Exception e) {
                Debug.print(e.getMessage());
                Debug.print("Map [" + data.size() + "]" + data);
                Debug.print("No se pudo crear el nodo con nombre de longitud " + key.length() + ": '" + key.toLowerCase() + "' ");
            }
        }
        return node;
    }

    private static Element createNode(Collection list, String nodeName) {
        if (nodeName == null || nodeName.trim().length() == 0) {
            nodeName = "node";
        }
        if (list == null) {
            list = new ArrayList();
        }
        Element main = new Element(nodeName);
        for (Object obj : list) {
            if (obj == null) continue;
            if (obj instanceof Collection) {
                main.addContent(XMLParser.createNode((Collection)obj, null));
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map data = (Map)obj;
            XMLParser.createChildNodes(main, data);
        }
        return main;
    }

    public static byte[] parseToXMLBytes(Collection list, String rootName, String nodeName) {
        Element root = new Element(rootName);
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            root.addContent(XMLParser.createNodes((Map)obj, nodeName));
        }
        return XMLParser.createXML(root);
    }

    public static Document parseToXMLDocument(Collection list, String rootName, String nodeName) {
        Element root = new Element(rootName);
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            root.addContent(XMLParser.createNodes((Map)obj, nodeName));
        }
        return new Document(root);
    }

    public static Element createNodes(Map data, String rootName) {
        Element node = new Element(rootName);
        for (Object key : data.keySet()) {
            Object val = data.get(key);
            if (!(val instanceof Collection)) continue;
            node.addContent(XMLParser.createNode((Collection)val, (String)key));
        }
        return node;
    }
}

