/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import s.f.util.xml.XMLParseable;
import s.f.util.xml.XMLParser;

public class XMLObjectParser {
    public static byte[] parseToXMLBytes(Collection list, String rootName, String nodeName) {
        return XMLParser.createXML(XMLObjectParser.parseToXMLDocument(list, rootName, nodeName));
    }

    public static Document parseToXMLDocument(Collection list, String rootName, String nodeName) {
        Element root = new Element(rootName);
        for (Object obj : list) {
            if (obj == null) continue;
            if (obj instanceof Collection) {
                root.addContent(XMLObjectParser.createNodes((Collection)obj, nodeName));
                continue;
            }
            if (obj instanceof Map) {
                Map data = (Map)obj;
                root.addContent(XMLObjectParser.createElements(data));
                continue;
            }
            root.addContent(XMLObjectParser.createNode(nodeName, obj));
        }
        return new Document(root);
    }

    private static Element createChildNode(Map data, String nodeName) {
        Iterator keys = data.keySet().iterator();
        Element node = new Element(nodeName.replaceAll("@", "&"));
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object objChild = data.get(key);
            if (objChild instanceof Map) {
                node.addContent(XMLObjectParser.createChildNode((Map)objChild, key));
                continue;
            }
            if (objChild instanceof Collection) {
                node.addContent(XMLObjectParser.createNodes((Collection)objChild, key));
                continue;
            }
            node.addContent(XMLObjectParser.createNode(key, objChild));
        }
        return node;
    }

    private static Collection createNodes(Collection list, String nodeName) {
        if (nodeName == null || nodeName.trim().length() == 0) {
            nodeName = "node";
        }
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList<Element> a = new ArrayList<Element>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element node = new Element(nodeName);
            Object obj = it.next();
            if (obj == null) continue;
            if (obj instanceof Collection) {
                node.addContent(XMLObjectParser.createNodes((Collection)obj, nodeName));
            } else if (obj instanceof Map) {
                Map data = (Map)obj;
                node.addContent(XMLObjectParser.createElements(data));
            } else {
                node.addContent(XMLObjectParser.createNode(nodeName, obj));
            }
            a.add(node);
        }
        return a;
    }

    private static Collection createElements(Map data) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        for (Object key : data.keySet()) {
            Object val = data.get(key);
            if (val instanceof Collection) {
                Element e = new Element(key.toString());
                e.addContent(XMLObjectParser.createNodes((Collection)val, key.toString()));
                nodes.add(e);
                continue;
            }
            if (val instanceof Map) {
                nodes.add(XMLObjectParser.createChildNode((Map)val, key.toString()));
                continue;
            }
            nodes.add(XMLObjectParser.createNode(key.toString(), val));
        }
        return nodes;
    }

    private static Element createNode(String name, Object value) {
        Element node = null;
        if (value instanceof XMLParseable) {
            node = ((XMLParseable)value).toXMLElement();
        } else {
            node = new Element(name);
            node.setText(value.toString());
        }
        return node;
    }
}

