/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import s.f.util.Debug;

public class DBHelper {
    private static ResourceBundle exceptionMessages = ResourceBundle.getBundle("messages");

    public static Connection releaseDBConnection(Connection conn) {
        try {
            if (conn == null || conn.isClosed()) {
                return null;
            }
            conn.close();
        }
        catch (SQLException e) {
            Debug.print("Unable to release connection: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("error closing");
        }
        return null;
    }

    public static Connection makeDBConnection(Connection conn, String database) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        try {
            InitialContext ic = new InitialContext();
            DataSource ds = (DataSource)ic.lookup("java:" + database);
            try {
                Connection _sql = ds.getConnection();
                return _sql;
            }
            catch (Exception e) {
                if (Debug.debuggingOn) {
                    e.printStackTrace();
                }
                throw new SQLException(e.getMessage());
            }
        }
        catch (NamingException e) {
            Debug.print("Naming Exception trying to open a connection to java:" + database + ". " + e.getMessage());
            if (Debug.debuggingOn) {
                e.printStackTrace();
            }
            throw new SQLException(exceptionMessages.getString("DBHelper_dbNamingError"));
        }
        catch (Exception e) {
            Debug.print("Failed to connect to java:" + database + ". " + e.getMessage());
            if (Debug.debuggingOn) {
                e.printStackTrace();
            }
            throw new SQLException(exceptionMessages.getString("DBHelper_unexectedError"));
        }
    }
}

