/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.sql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ResourceBundle;

public class ByteBLOB
implements Blob {
    ResourceBundle exceptionMessages = ResourceBundle.getBundle("messages");
    byte[] bytes = null;

    public ByteBLOB(byte[] b) {
        this.bytes = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBLOB(Blob b) {
        InputStream is = null;
        try {
            is = b.getBinaryStream();
            this.bytes = new byte[(int)b.length()];
            is.read(this.bytes);
        }
        catch (SQLException e) {
            this.bytes = null;
        }
        catch (IOException e) {
            this.bytes = null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos == 0L && length == this.bytes.length) {
            return this.bytes;
        }
        try {
            byte[] newbytes = new byte[length];
            System.arraycopy(this.bytes, (int)pos, newbytes, 0, length);
            return newbytes;
        }
        catch (Exception e) {
            throw new SQLException(this.exceptionMessages.getString("ByteBLOB_getBytes"));
        }
    }

    public long length() throws SQLException {
        return this.bytes.length;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_position"));
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_position"));
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_notImplemented"));
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_notImplemented"));
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_notImplemented"));
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException(this.exceptionMessages.getString("ByteBLOB_notImplemented"));
    }

    public void free() throws SQLException {
        throw new UnsupportedOperationException(this.exceptionMessages.getString("ByteBLOB_notSoupported"));
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException(this.exceptionMessages.getString("ByteBLOB_notSupported"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteBLOB)) {
            return false;
        }
        ByteBLOB other = (ByteBLOB)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

