/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import s.f.util.Debug;
import s.f.util.InvalidDataException;
import s.f.util.Utils;
import s.f.util.report.DataSourcePlugin;
import s.f.util.report.ReportCONFIG;
import s.f.util.xml.XMLParser;

public class ReportGenerator {
    private static Map getFillingObjects(Object permissionObject, Object aKey, Hashtable sectionData, Hashtable reportData, HashMap reportParameters, Hashtable queryParameters, JRAbstractLRUVirtualizer virtualizer) throws InvalidDataException {
        String pluginName = null;
        String nodeName = null;
        String rootNodeName = null;
        String sectionName = null;
        String xPathQuey = null;
        JRXmlDataSource dataSource = null;
        byte[] jasperBytes = null;
        byte[] classPluginBytes = null;
        if (reportParameters == null) {
            reportParameters = new HashMap<String, Object>();
        }
        if (queryParameters == null) {
            queryParameters = new Hashtable();
        }
        Hashtable data = null;
        DataSourcePlugin plugin = null;
        Map subreports = null;
        virtualizer = new JRSwapFileVirtualizer(2, new JRSwapFile("/tmp/", 1024, 1024));
        reportParameters.put("REPORT_VIRTUALIZER", virtualizer);
        sectionName = (String)sectionData.get("NOMBRE");
        pluginName = (String)sectionData.get("PLUGIN");
        rootNodeName = (String)sectionData.get("ROOT_NODE_NAME");
        nodeName = (String)sectionData.get("NODE_NAME");
        xPathQuey = (String)sectionData.get("QUERY");
        if (sectionData.containsKey("CLASS_PLUGIN")) {
            classPluginBytes = (byte[])sectionData.get("CLASS_PLUGIN");
        }
        if (classPluginBytes == null) {
            try {
                Class<?> pluginClass = Class.forName(pluginName);
                plugin = (DataSourcePlugin)pluginClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new InvalidDataException("No se encuentra el plugin asignado para generar los reportes de la seccion de " + sectionName);
            }
            catch (ExceptionInInitializerError e) {
                e.printStackTrace();
                throw new InvalidDataException("Error al inicializar el plugin asignado para generar los reportes de la seccion de " + sectionName);
            }
            catch (LinkageError e) {
                e.printStackTrace();
                throw new InvalidDataException("Error al intentar recuperar el plugin asignado para generar los reportes de la seccion de " + sectionName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidDataException("No se encuentra el plugin asignado para generar los reportes de la seccion de " + sectionName);
            }
        }
        try {
            Class c = JRClassLoader.loadClassFromBytes((String)pluginName, (byte[])classPluginBytes);
            plugin = (DataSourcePlugin)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long begin = System.currentTimeMillis();
        try {
            data = plugin.createDataSourceObjects(permissionObject, aKey, queryParameters);
            if (data.containsKey("PARAMETERS")) {
                reportParameters.putAll((Map)data.get("PARAMETERS"));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al crear los objetos para la generacion del DataSource del reporte. " + e.getMessage());
        }
        long end = System.currentTimeMillis();
        Debug.print("------- La recuperaci\u00f3n de datos tom\u00f3 " + (double)(end - begin) / 1000.0 + " segundos");
        subreports = reportData.containsKey("SUBREPORTS") ? (Map)reportData.get("SUBREPORTS") : new HashMap();
        try {
            byte[] bytes = XMLParser.createXMLDataSource((ArrayList)data.get("RESULTS"), rootNodeName, nodeName);
            try {
                FileOutputStream fos = new FileOutputStream("/tmp/xmlDSReported.xml");
                fos.write(bytes);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ByteArrayInputStream xmlByteArray = new ByteArrayInputStream(bytes);
            dataSource = new JRXmlDataSource((InputStream)xmlByteArray, xPathQuey);
            try {
                org.w3c.dom.Document w3cDoc = JRXmlUtils.parse((InputStream)new ByteArrayInputStream(bytes));
                reportParameters.put("XML_DATA_DOCUMENT", w3cDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al crear el DataSource para la generacon del reporte. " + e.getMessage());
        }
        jasperBytes = (byte[])reportData.get("REPORT_DATA");
        reportParameters.putAll(subreports);
        JasperReport jasperReport = null;
        try {
            jasperReport = (JasperReport)JRLoader.loadObject((InputStream)new ByteArrayInputStream(jasperBytes));
        }
        catch (JRException e) {
            // empty catch block
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("REPORT", jasperReport);
        map.put("DATASOURCE", dataSource);
        map.put("PARAMETERS", reportParameters);
        return map;
    }

    public static JasperPrint fill(Object permissionObject, Object aKey, Hashtable sectionData, Hashtable reportData, HashMap reportParameters, Hashtable queryParameters, JRAbstractLRUVirtualizer virtualizer) throws InvalidDataException {
        Map fillingObjects = ReportGenerator.getFillingObjects(permissionObject, aKey, sectionData, reportData, reportParameters, queryParameters, virtualizer);
        JasperReport jasperReport = (JasperReport)fillingObjects.get("REPORT");
        JRDataSource dataSource = (JRDataSource)fillingObjects.get("DATASOURCE");
        JasperPrint jasperPrint = null;
        long begin = System.currentTimeMillis();
        try {
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)reportParameters, (JRDataSource)dataSource);
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al llenar el reporte");
        }
        long end = System.currentTimeMillis();
        Debug.print("------- El llenado del reporte tom\u00f3 " + (double)(end - begin) / 1000.0 + " segundos.");
        if (virtualizer != null) {
            // empty if block
        }
        return jasperPrint;
    }

    public static byte[] generate(Object permissionObject, Object aKey, Hashtable sectionData, Hashtable reportData, int formato, HashMap reportParameters, Hashtable queryParameters, Map exporterParams, JRAbstractLRUVirtualizer virtualizer) throws InvalidDataException {
        JasperPrint jasperPrint = ReportGenerator.fill(permissionObject, aKey, sectionData, reportData, reportParameters, queryParameters, virtualizer);
        return ReportGenerator.exportReport(jasperPrint, exporterParams, formato, virtualizer);
    }

    public static byte[] exportReport(JasperPrint jasperPrint, Map exporterParams, int formato, JRAbstractLRUVirtualizer virtualizer) throws InvalidDataException {
        byte[] result = null;
        JRXlsExporter exporter = null;
        try {
            switch (formato) {
                case 0: {
                    exporter = new JRXlsExporter();
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
                    break;
                }
                case 1: {
                    exporter = new JRPdfExporter();
                    break;
                }
                case 4: {
                    exporter = new JRRtfExporter();
                    break;
                }
                case 5: {
                    exporter = new JRCsvExporter();
                    break;
                }
                case 3: {
                    exporter = new JRHtmlExporter();
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.FALSE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)Boolean.FALSE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.SIZE_UNIT, (Object)"px");
                    break;
                }
                case 6: {
                    exporter = new JROdtExporter();
                    break;
                }
                default: {
                    throw new InvalidDataException("Se ha recibido una solicitud de formato de archivo no v\u00e1lida");
                }
            }
            exporter.setParameters(exporterParams);
            Debug.print("Exportando reporte a formato " + ReportCONFIG.FILE_EXTENSION[formato]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
            exporter.exportReport();
            result = baos.toByteArray();
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al exportar el reporte a formato " + ReportCONFIG.FILE_EXTENSION[formato]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidDataException("Error inesperado al exportar el reporte a " + ReportCONFIG.FILE_EXTENSION[formato]);
        }
        if (virtualizer != null) {
            virtualizer.cleanup();
        }
        return result;
    }

    public static AsynchronousFillHandle asynchronousFill(Map data) throws InvalidDataException {
        AsynchronousFillHandle handler = null;
        Object permissionObject = data.get("PERMISSION_OBJECT");
        Object aKey = data.get("KEY");
        Hashtable sectionData = (Hashtable)data.get("SECTION_DATA");
        Hashtable reportData = (Hashtable)data.get("REPORT_DATA");
        HashMap reportParameters = (HashMap)data.get("REPORT_PARAMETERS");
        Hashtable queryParameters = (Hashtable)data.get("QUERY_PARAMETERS");
        JRAbstractLRUVirtualizer virtualizer = (JRAbstractLRUVirtualizer)data.get("VIRTUALIZER");
        Map fillingObjects = ReportGenerator.getFillingObjects(permissionObject, aKey, sectionData, reportData, reportParameters, queryParameters, virtualizer);
        JasperReport jasperReport = (JasperReport)fillingObjects.get("REPORT");
        JRDataSource dataSource = (JRDataSource)fillingObjects.get("DATASOURCE");
        try {
            handler = AsynchronousFillHandle.createHandle((JasperReport)jasperReport, (Map)reportParameters, (JRDataSource)dataSource);
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error previo al inicio del proceso de llenado del reporte.");
        }
        return handler;
    }

    public static Map analyzeReport(InputStream jrxmlFile) throws InvalidDataException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        HashMap subreports = new HashMap();
        Pattern bands = Pattern.compile("background|title|pageHeader|columnHeader|detail|columnFooter|pageFooter|summary|noData");
        Pattern parameter = Pattern.compile("\\$P\\{.+\\}");
        Document jrxmlReport = null;
        Element reportRoot = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            jrxmlReport = builder.build(jrxmlFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al leer el reporte. ");
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new InvalidDataException("Al cargar el reporte, no es un archivo de reporte valido. ");
        }
        reportRoot = jrxmlReport.getRootElement();
        components.put("REPORT_NAME", Utils.cleanString(reportRoot.getAttributeValue("name")));
        for (Element child : reportRoot.getChildren()) {
            List bandComponents;
            Element band;
            Matcher isBand = bands.matcher(child.getName());
            if (!isBand.matches() || (band = child.getChild("band")) == null || (bandComponents = band.getChildren("subreport")) == null) continue;
            for (Element subreport : bandComponents) {
                Element reportElement = subreport.getChild("reportElement");
                Element subreportExpression = subreport.getChild("subreportExpression");
                if (reportElement == null || subreportExpression == null) continue;
                String expression = Utils.cleanString(subreportExpression.getValue());
                HashMap<String, Object> subreportInfo = new HashMap<String, Object>();
                String subreportKey = null;
                subreportKey = reportElement.getAttributeValue("key");
                subreportInfo.put("class", Utils.cleanString(subreportExpression.getAttributeValue("class")));
                subreportInfo.put("positionType", Utils.cleanString(reportElement.getAttributeValue("positionType")));
                boolean isParameter = parameter.matcher(expression).matches();
                subreportInfo.put("is_parameter", new Boolean(isParameter));
                if (isParameter) {
                    subreportInfo.put("parameter_name", expression.substring(3, expression.length() - 1));
                }
                subreports.put(subreportKey, subreportInfo);
            }
        }
        components.put("SUBREPORTS", subreports);
        return components;
    }

    public static byte[] compileDesign(byte[] design) throws InvalidDataException {
        ByteArrayInputStream bis = new ByteArrayInputStream(design);
        ByteArrayOutputStream compiledReport = new ByteArrayOutputStream();
        try {
            JasperCompileManager.compileReportToStream((InputStream)bis, (OutputStream)compiledReport);
        }
        catch (JRException e) {
            e.printStackTrace();
            throw new InvalidDataException("Error al compilar el dise\u00f1o. " + e.getMessage() + "\nCompruebe que se trata de un archivo con extension .jrxml con la codificacion correcta y vuelva a intentarlo");
        }
        return compiledReport.toByteArray();
    }

    public static void compileReportToFile(String sourceFileName, String compiledFileName) throws InvalidDataException {
        FileInputStream fis = null;
        byte[] designBytes = null;
        FileOutputStream fos = null;
        if (compiledFileName == null || compiledFileName.trim().length() == 0) {
            compiledFileName = sourceFileName.replaceAll("\\.jrxml", "\\.jasper");
        }
        try {
            fis = new FileInputStream(sourceFileName);
            designBytes = new byte[fis.available()];
            fis.read(designBytes);
            fis.close();
        }
        catch (IOException e) {
            throw new InvalidDataException("Error al leer el archivo " + sourceFileName + ". ");
        }
        try {
            fos = new FileOutputStream(compiledFileName);
            fos.write(ReportGenerator.compileDesign(designBytes));
            fos.close();
        }
        catch (IOException e) {
            throw new InvalidDataException("Error al escribir el archivo " + compiledFileName + ". ");
        }
    }

    public static void main(String[] args) {
        block3: {
            if (args.length < 3) {
                System.out.print("Uso: ReportGenerator archivoDise\u00f1o.jrxml archivoCompilado.jasper");
                return;
            }
            try {
                ReportGenerator.compileReportToFile(args[1], args[2]);
            }
            catch (Exception e) {
                System.out.print(e.getMessage());
                if (args.length <= 3 || !args[3].equals("true")) break block3;
                e.printStackTrace();
            }
        }
    }
}

