/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import s.f.util.Messages;
import s.f.util.RemoteAppException;

public class SFMailer {
    public static Session getMailSession(String jndiSession) throws RemoteAppException {
        if (jndiSession == null) {
            jndiSession = Messages.getString("SFMailer_DefaultJNDIMailSession");
        }
        try {
            InitialContext initial = new InitialContext();
            Object objref = initial.lookup(Messages.getString("SFMailer_JNDIPrefix") + jndiSession);
            return (Session)PortableRemoteObject.narrow((Object)objref, Session.class);
        }
        catch (Exception e) {
            throw new RemoteAppException(Messages.getString("SFMailer_getMailSession"));
        }
    }

    public static DataSource zipAttachments(Collection a) throws ZipException {
        ByteArrayDataSource ds = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        for (Hashtable hh : a) {
            String attachName = (String)hh.get("NAME");
            Hashtable att = (Hashtable)hh.get("ATTACHMENT");
            byte[] bytes = (byte[])att.get("BYTES");
            try {
                ZipEntry ze = new ZipEntry(attachName);
                zos.putNextEntry(ze);
                zos.write(bytes);
                zos.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ZipException("Error al archivar " + attachName + " en zip");
            }
        }
        try {
            zos.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ZipException("Error al crear el archivo zip");
        }
        ds = new ByteArrayDataSource(bos.toByteArray(), "application/zip");
        return ds;
    }

    public static void sendMail(Hashtable h, boolean html, boolean zipAttachments) throws RemoteException {
        SFMailer.sendMail(h, html, zipAttachments, null);
    }

    public static void sendMail(Hashtable h, boolean html, boolean zipAttachments, String zipName) throws RemoteException {
        MimeMessage m = null;
        StringBuffer buffer = new StringBuffer();
        String staffEmail = (String)h.get("FROM");
        String jndiSession = (String)h.get("SESSION");
        try {
            Session session = SFMailer.getMailSession(jndiSession);
            m = new MimeMessage(session);
            m.setFrom(new InternetAddress(staffEmail));
            Address[] to = new InternetAddress[1];
            if (h.get("TO") instanceof String) {
                to[0] = new InternetAddress((String)h.get("TO"));
            } else {
                try {
                    String[] _to = (String[])h.get("TO");
                    to = new InternetAddress[_to.length];
                    for (int i = 0; i < _to.length; ++i) {
                        to[i] = new InternetAddress(_to[i]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RemoteAppException("Error al leer las direcciones de envio");
                }
            }
            m.setSubject((String)h.get("SUBJECT"));
            m.addRecipients(Message.RecipientType.TO, to);
            m.setSentDate(new Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            String msg = (String)h.get("MENSAJE");
            buffer.append(msg);
            messageBodyPart.setContent(buffer.toString(), html ? "text/html" : "text/plain");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart(messageBodyPart);
            ArrayList a = new ArrayList();
            if (h.containsKey("ADJUNTOS")) {
                a = (ArrayList)h.get("ADJUNTOS");
                if (zipAttachments) {
                    DataSource source = null;
                    try {
                        source = SFMailer.zipAttachments(a);
                    }
                    catch (ZipException e) {
                        throw new RemoteAppException("Error al comprimir los archivos adjuntos");
                    }
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler(source));
                    messageBodyPart.setFileName(zipName == null ? "Adjuntos.zip" : zipName);
                    multipart.addBodyPart(messageBodyPart);
                } else {
                    Iterator i = a.iterator();
                    while (i.hasNext()) {
                        messageBodyPart = new MimeBodyPart();
                        Hashtable hh = (Hashtable)i.next();
                        String attachName = (String)hh.get("NAME");
                        Hashtable att = (Hashtable)hh.get("ATTACHMENT");
                        ByteArrayDataSource source = null;
                        try {
                            byte[] bytes = (byte[])att.get("BYTES");
                            String contentType = (String)att.get("CONTENT-TYPE");
                            source = new ByteArrayDataSource(bytes, contentType);
                        }
                        catch (Exception e) {
                            throw new RemoteAppException("Error al leer los archivos adjuntos");
                        }
                        messageBodyPart.setDataHandler(new DataHandler(source));
                        messageBodyPart.setFileName(attachName);
                        multipart.addBodyPart(messageBodyPart);
                    }
                }
            }
            m.setContent(multipart);
            Transport.send(m);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new RemoteAppException("Error al enviar el e-mail");
        }
    }
}

