/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.mail;

import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import s.f.util.RemoteAppException;
import s.f.util.mail.SFMailer;

public class MailSigner {
    private MimeMessage message = null;
    private String keystore = null;
    private String storetype = "PKCS12";
    private String alias = null;
    private String storepass = null;
    public String var = null;
    public String scope = "page";

    public MailSigner() {
        Security.addProvider(new BouncyCastleProvider());
        MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap(mailcap);
    }

    protected MimeMessage signMessage(MimeMessage message, X509Certificate cert, PrivateKey privateKey) throws RemoteException {
        MimeMessage signedMessage = null;
        try {
            SMIMECapabilityVector capabilities = new SMIMECapabilityVector();
            capabilities.addCapability(SMIMECapability.dES_EDE3_CBC);
            capabilities.addCapability(SMIMECapability.rC2_CBC, 128);
            capabilities.addCapability(SMIMECapability.dES_CBC);
            ASN1EncodableVector attributes = new ASN1EncodableVector();
            attributes.add(new SMIMEEncryptionKeyPreferenceAttribute(new IssuerAndSerialNumber(new X509Name(cert.getIssuerDN().getName()), cert.getSerialNumber())));
            attributes.add(new SMIMECapabilitiesAttribute(capabilities));
            SMIMESignedGenerator gen = new SMIMESignedGenerator();
            gen.addSigner(privateKey, cert, "DSA".equals(privateKey.getAlgorithm()) ? SMIMESignedGenerator.DIGEST_SHA1 : SMIMESignedGenerator.DIGEST_MD5, new AttributeTable(attributes), null);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(cert);
            CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(certs);
            MimeMultipart mm = gen.generate(message, "BC");
            signedMessage = new MimeMessage(SFMailer.getMailSession(null));
            Enumeration headers = message.getAllHeaderLines();
            while (headers.hasMoreElements()) {
                signedMessage.addHeaderLine((String)headers.nextElement());
            }
            signedMessage.setContent(mm);
            signedMessage.saveChanges();
        }
        catch (MessagingException ex) {
            throw new RemoteAppException("Error al firmar el mensaje", ex);
        }
        catch (GeneralSecurityException ex) {
            throw new RemoteAppException("Error al firmar el mensaje", ex);
        }
        catch (SMIMEException ex) {
            throw new RemoteException("Error al firmar el mensaje", ex.getUnderlyingException());
        }
        return signedMessage;
    }
}

