/*
 * Decompiled with CFR 0.152.
 */
package s.f.util.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import s.f.util.Utils;

public class HTTPRequestSender {
    public static StringBuffer sendGetRequest(String destination, String queryString) {
        return HTTPRequestSender.sendGetRequest(destination, queryString, null);
    }

    public static StringBuffer sendGetRequest(String destination, String queryString, String cookies) {
        StringBuffer result = null;
        if (destination.startsWith("http://")) {
            try {
                String line;
                String urlStr = destination;
                if (queryString != null && queryString.length() > 0) {
                    urlStr = urlStr + "?" + queryString;
                }
                URL url = new URL(urlStr);
                URLConnection conn = url.openConnection();
                if (Utils.isParameterValid(cookies)) {
                    conn.setRequestProperty("Cookie", cookies);
                }
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                result = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                rd.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void sendPostRequest(Reader data, URL destination, String contentType, String charsetEnconding, Writer output) throws IOException {
        HTTPRequestSender.sendPostRequest(data, destination, new StringBuffer(), contentType, charsetEnconding, output);
    }

    public static void sendPostRequest(Reader data, URL destination, StringBuffer cookies, String contentType, String charsetEnconding, Writer output) throws IOException {
        HttpURLConnection urlc = null;
        try {
            urlc = (HttpURLConnection)destination.openConnection();
            try {
                urlc.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new IOException("Error de protocolo HTTP. No se puede enviar por POST.");
            }
            urlc.setDoOutput(true);
            urlc.setDoInput(true);
            urlc.setUseCaches(false);
            urlc.setAllowUserInteraction(false);
            if (contentType == null) {
                urlc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            } else {
                urlc.setRequestProperty("Content-type", contentType);
            }
            if (cookies.length() > 0) {
                urlc.setRequestProperty("Cookie", cookies.toString());
            }
            OutputStream out = urlc.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, charsetEnconding != null ? charsetEnconding : "ISO-8859-1");
                HTTPRequestSender.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new IOException("Error al enviar los datos por POST");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlc.getInputStream();
            if (urlc.getHeaderFields().containsKey("Set-Cookie")) {
                cookies.delete(0, cookies.length());
                Iterator<String> it = urlc.getHeaderFields().get("Set-Cookie").iterator();
                while (it.hasNext()) {
                    cookies.append((Object)it.next());
                    if (!it.hasNext()) continue;
                    cookies.append("; ");
                }
            }
            try {
                InputStreamReader reader = new InputStreamReader(in);
                HTTPRequestSender.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new IOException("Error al leer la respuesta del servidor");
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new IOException("No se puede conectar a " + destination + ". ");
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[1024];
        int read = 0;
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }
}

