/*
 * Decompiled with CFR 0.152.
 */
package s.f.util;

import com.lowagie.text.html.HtmlEncoder;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Utils {
    public static final int DDMMYYYY = 0;
    public static final int YYYYMMDD = 1;
    public static final int MMDDYYYY = 2;
    public static final int SPANISH = 3;
    public static final int ENGLISH = 4;
    public static final int SPANISH_DOW = 5;
    public static final int ENGLISH_DOW = 6;
    public static final int SPANISH_SHORTCUT = 7;
    public static final int ENGLISH_SHORTCUT = 8;
    public static final int SPANISH_DOW_SHORTCUT = 9;
    public static final int ENGLISH_DOW_SHORTCUT = 10;
    public static final int ANIVERSARIO_DDMM = 11;
    public static final int ANIVERSARIO_SPANISH = 12;
    public static final int ANIVERSARIO_SPANISH_SHORTCUT = 13;
    public static String[] MESES = new String[]{"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"};
    public static String[] DIAS = new String[]{"Domingo", "Lunes", "Martes", "Mi&eacute;rcoles", "Jueves", "Viernes", "S&aacute;bado"};
    public static String[] NUMBERDIAS = new String[]{"Primer", "Segundo", "Tercer", "Cuarto", "&Uacute;ltimo"};

    public static boolean isRFCValid(String RFC) {
        return Utils.cleanString(RFC).toUpperCase().matches("^[A-Z&][A-Z&]([A-Z&]|[A-Z&][A-Z&])[0-9][0-9][0-9][0-9][0-9][0-9][A-Z0-9][A-Z0-9][A-Z0-9]$");
    }

    public static boolean isParameterValid(String value, int min_length) {
        return Utils.cleanString(value).length() >= min_length;
    }

    public static SimpleDateFormat getFormatter() {
        return new SimpleDateFormat("MMMMM, dd, yyyy", new Locale("es", "MX"));
    }

    public static String cleanString(String s) {
        return s != null ? s : "";
    }

    public static void sendRedirect(HttpServletResponse response, String URL2) throws IOException {
        String[] s = URL2.split("\\?");
        StringBuffer buffer = new StringBuffer();
        buffer.append(s[0]);
        buffer.append(";s=" + Utils.getMD5Hash(Calendar.getInstance().toString()) + "?");
        for (int i = 1; i < s.length; ++i) {
            buffer.append(s[i]);
            if (i + 1 >= s.length) continue;
            buffer.append("?");
        }
        response.sendRedirect(response.encodeRedirectURL(buffer.toString()));
    }

    public static void sendRedirect(HttpServletResponse response, String goTo, String URL2) throws IOException {
        StringTokenizer st = new StringTokenizer(URL2, "?");
        String action = st.nextToken();
        String params = st.nextToken();
        response.sendRedirect(response.encodeRedirectURL(goTo + "?url=" + action + "&" + params));
    }

    public static boolean isEmailValid(String address) {
        return Utils.cleanString(address).matches("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
    }

    public static boolean isParameterValid(String value) {
        return Utils.isParameterValid(value, 1);
    }

    public static String getMD5Hash(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] r = md.digest();
            return Utils.asHex(r);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String asHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString().toUpperCase();
    }

    public static String stringChanger(String cadena, String espacio, String guionBajo) {
        StringBuffer buffer = new StringBuffer();
        if (cadena == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(cadena, espacio);
        while (st.hasMoreElements()) {
            if (st.countTokens() == 1) {
                buffer.append(st.nextToken());
                continue;
            }
            buffer.append(st.nextToken() + guionBajo);
        }
        return buffer.toString();
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static SimpleDateFormat getDateFormatter(int formato, String separador, boolean _time, boolean am_pm) {
        SimpleDateFormat sdf = null;
        switch (formato) {
            case 0: {
                sdf = new SimpleDateFormat("dd'" + separador + "'MM'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 1: {
                sdf = new SimpleDateFormat("yyyy'" + separador + "'MM'" + separador + "'dd" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 2: {
                sdf = new SimpleDateFormat("MM'" + separador + "'dd'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 3: {
                sdf = new SimpleDateFormat("dd'" + separador + "'MMMMM'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 4: {
                sdf = new SimpleDateFormat("MMMMM dd, yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("en"));
                break;
            }
            case 5: {
                sdf = new SimpleDateFormat("EEE dd'" + separador + "'MMMMM'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 6: {
                sdf = new SimpleDateFormat("EEE MMMMM dd, yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("en"));
                break;
            }
            case 7: {
                sdf = new SimpleDateFormat("dd'" + separador + "'MMM'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 8: {
                sdf = new SimpleDateFormat("MMM dd, yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("en"));
                break;
            }
            case 9: {
                sdf = new SimpleDateFormat("EEE dd'" + separador + "'MMM'" + separador + "'yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("es"));
                break;
            }
            case 10: {
                sdf = new SimpleDateFormat("EEE MMM dd, yyyy" + (_time ? " " + (am_pm ? "hh:mm:ss a" : "HH:mm:ss") : ""), new Locale("en"));
                break;
            }
            case 11: {
                sdf = new SimpleDateFormat("dd/MM", new Locale("es"));
                break;
            }
            case 12: {
                sdf = new SimpleDateFormat("dd'" + separador + "'MMMMM", new Locale("es"));
                break;
            }
            case 13: {
                sdf = new SimpleDateFormat("dd'" + separador + "'MMM", new Locale("es"));
                break;
            }
            default: {
                sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a", new Locale("es"));
            }
        }
        return sdf;
    }

    public static String formaFecha(Date date, int formato, String separador, boolean _time, boolean am_pm) {
        if (date == null) {
            return "";
        }
        return Utils.getDateFormatter(formato, separador, _time, am_pm).format(date);
    }

    public static String formaFecha(Date date) {
        return Utils.formaFecha(date, 0, "/", false, false);
    }

    public static String formaFecha(Date date, int formato) {
        return Utils.formaFecha(date, formato, "/", false, false);
    }

    public static String formaFecha(Date date, int formato, String separador) {
        return Utils.formaFecha(date, formato, separador, false, false);
    }

    public static String formaFecha(Date date, int formato, boolean _time, boolean am_pm) {
        return Utils.formaFecha(date, formato, "/", _time, am_pm);
    }

    public static String formatCurrency(double n) {
        Locale l = new Locale("es", "MX");
        NumberFormat ret = NumberFormat.getCurrencyInstance(l);
        return ret.format(n);
    }

    public static String formatCurrency(Double n) {
        return Utils.formatCurrency((double)n);
    }

    public static String formatNumber(Double n) {
        Locale.setDefault(new Locale("es", "MX"));
        if (n == null) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat("############0.00", new DecimalFormatSymbols(new Locale("es", "MX")));
        return formatter.format(n);
    }

    public static String formatearNumero(double n) {
        return Utils.formatearNumero(new Double(n));
    }

    public static String formatearNumero(Double n) {
        DecimalFormat formatter = new DecimalFormat("###,###,###,###,###,###,##0.00", new DecimalFormatSymbols(new Locale("es", "MX")));
        return formatter.format(Utils.redondearNumero(n, 2));
    }

    public static String formatearNumero(Object num, int precision) {
        String p = "";
        if (precision > 0) {
            p = ".";
            for (int j = 0; j < precision; ++j) {
                p = p + "0";
            }
        }
        DecimalFormat formatter = new DecimalFormat("#,##0" + p, new DecimalFormatSymbols(new Locale("es", "MX")));
        return formatter.format(num);
    }

    public static DecimalFormat getFormater(int precision) {
        String p = "";
        if (precision > 0) {
            p = ".";
            for (int j = 0; j < precision; ++j) {
                p = p + "0";
            }
        }
        return new DecimalFormat("#,##0" + p, new DecimalFormatSymbols(new Locale("es", "MX")));
    }

    public static BigDecimal redondearNumero(Double num, int scale) {
        if (num == null) {
            num = new Double(0.0);
        }
        BigDecimal n = new BigDecimal(num);
        n = n.setScale(scale, 6);
        return n;
    }

    public static String formatTimestamp(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.format(date);
    }

    public static String formatTimestamp(Date date, String separador) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'" + separador + "'HH:mm:ss");
        return sdf.format(date);
    }

    public static String formatCurrency(BigDecimal num) {
        return Utils.formatCurrency(num, 2, 6);
    }

    public static String formatCurrency(BigDecimal num, MathContext m) {
        Locale inLocale = new Locale("es", "MX");
        NumberFormat formatter = DecimalFormat.getCurrencyInstance(inLocale);
        return formatter.format(num.setScale(m.getPrecision(), m.getRoundingMode()));
    }

    public static String formatCurrency(BigDecimal num, int scale, int roundingMode) {
        Locale inLocale = new Locale("es", "MX");
        NumberFormat formatter = DecimalFormat.getCurrencyInstance(inLocale);
        return formatter.format(num.setScale(scale, roundingMode));
    }

    public static String formatNumber(BigDecimal num) {
        return Utils.formatNumber(num, 2, 6);
    }

    public static String formatNumber(BigDecimal num, MathContext m) {
        if (num == null) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("es", "MX")));
        return formatter.format(num.setScale(m.getPrecision(), m.getRoundingMode()));
    }

    public static String formatNumber(BigDecimal num, int scale, int roundingMode) {
        if (num == null) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("es", "MX")));
        return formatter.format(num.setScale(scale, roundingMode));
    }

    public static boolean borrarDirectorio(String dir) {
        String sep = File.separator;
        File file = new File(dir);
        if (file.exists()) {
            try {
                String[] s = file.list();
                for (int i = 0; i < s.length; ++i) {
                    Utils.borrarArchivo(dir + sep + s[i]);
                }
                return file.delete();
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            return false;
        }
        return true;
    }

    public static void borrarArchivo(String dir) {
        try {
            File file = new File(dir);
            if (!file.isDirectory()) {
                file.delete();
            } else {
                Utils.borrarDirectorio(dir);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static String encodeHTML(String text) {
        return HtmlEncoder.encode((String)text);
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setRequestEncoding(HttpServletRequest request, String encoding) {
        try {
            request.setCharacterEncoding(encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

