/*
 * Decompiled with CFR 0.152.
 */
package s.f.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import s.f.util.Messages;

public final class Debug {
    public static boolean debuggingOn = true;

    public static final void print(String msg) {
        if (debuggingOn) {
            System.out.print(msg);
        }
    }

    public static final void print(Object obj) {
        if (debuggingOn) {
            if (obj != null) {
                if (obj instanceof Collection || obj instanceof ArrayList) {
                    Debug.printMapCollection((Collection)obj);
                } else if (obj instanceof Map || obj instanceof HashMap || obj instanceof Hashtable) {
                    Debug.printMap((Map)obj);
                } else {
                    System.out.print(" [" + obj.getClass().getName() + "] " + obj.toString());
                }
            } else {
                Debug.print(Messages.getString("Debug_null"));
            }
        }
    }

    public static final void print(String msg, Object object) {
        if (debuggingOn) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(object.getClass().getName());
            buffer.append(" ");
            buffer.append(msg);
            System.out.print(buffer.toString());
        }
    }

    public static void toString(HttpSession session) {
        Enumeration nombres = session.getAttributeNames();
        while (nombres.hasMoreElements()) {
            String nombre = (String)nombres.nextElement();
            System.out.print(nombre + " = " + session.getAttribute(nombre));
        }
    }

    public static void toString(HttpServletRequest respuesta) {
        StringBuffer sb = new StringBuffer();
        Enumeration nombres = respuesta.getParameterNames();
        while (nombres.hasMoreElements()) {
            String nombre = (String)nombres.nextElement();
            sb.append(nombre + " - " + respuesta.getParameter(nombre) + "\n");
        }
        System.out.print(sb.toString());
    }

    public static void printMapCollection(Collection a) {
        Debug.printMapCollection(a, "");
    }

    public static void printMapCollection(Collection a, String str) {
        Debug.print();
        Iterator it = a.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            try {
                Debug.printMap((Map)next, " " + str);
                if (!it.hasNext()) continue;
                Debug.print("");
            }
            catch (Exception e) {
                Debug.print(str + next);
            }
        }
        Debug.print();
    }

    public static void printMap(Map map) {
        Debug.printMap(map, "");
    }

    public static void printMap(Map map, String str) {
        for (Object key : map.keySet()) {
            if (map.get(key) instanceof Map) {
                Debug.printMap((Map)map.get(key), " " + str);
                continue;
            }
            if (map.get(key) instanceof Collection) {
                Debug.printMapCollection((Collection)map.get(key), " " + str);
                continue;
            }
            Debug.print(" " + str + key + ": " + map.get(key));
        }
    }

    public static void print() {
        Debug.print(Messages.getString("Debug_line"));
    }
}

