/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.utils.fs.watcher;

import java.io.File;
import org.apache.log4j.Logger;
import s.f.erp.utils.fs.watcher.BaseListener;
import s.f.erp.utils.fs.watcher.IFileListener;

public class FileListener
extends BaseListener
implements IFileListener {
    Logger logger = Logger.getLogger(FileListener.class);

    @Override
    public void onStart(Object monitoredResource) {
        File resource;
        if (monitoredResource instanceof File && (resource = (File)monitoredResource).isDirectory()) {
            this.logger.info("Start to monitor " + resource.getAbsolutePath());
        }
    }

    @Override
    public void onStop(Object notMonitoredResource) {
    }

    @Override
    public void onAdd(Object newResource) {
        File file;
        if (newResource instanceof File && (file = (File)newResource).isFile()) {
            this.logger.info(file.getAbsolutePath() + " is added");
        }
    }

    @Override
    public void onChange(Object changedResource) {
        File file;
        if (changedResource instanceof File && (file = (File)changedResource).isFile()) {
            this.logger.info(file.getAbsolutePath() + " is changed");
        }
    }

    @Override
    public void onDelete(Object deletedResource) {
        if (deletedResource instanceof String) {
            String deletedFile = (String)deletedResource;
            this.logger.info(deletedFile + " is deleted");
        }
    }
}

