/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.utils.fs.watcher;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.utils.fs.watcher.AbstractResourceWatcher;
import s.f.erp.utils.fs.watcher.FileListener;

public class DirectoryWatcher
extends AbstractResourceWatcher {
    private Map currentFiles = new HashMap();
    private String directory;
    private Map prevFiles = new HashMap();
    private boolean executeOnce = false;
    Logger logger = Logger.getLogger(DirectoryWatcher.class);

    public DirectoryWatcher(String directoryPath, int intervalSeconds) throws IllegalArgumentException {
        super(intervalSeconds, directoryPath + " interval watcher.");
        File theDirectory = new File(directoryPath);
        if (theDirectory != null && !theDirectory.isDirectory()) {
            String message = "The path " + directoryPath + " does not represent a valid directory.";
            throw new IllegalArgumentException(message);
        }
        this.directory = directoryPath;
    }

    public static void main(String[] args) {
        int seconds = 5;
        if (args.length == 0) {
            System.out.print("\nUsage: " + DirectoryWatcher.class.getName() + " directory [interval]\n\n");
            System.exit(0);
        }
        try {
            seconds = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        DirectoryWatcher dw = new DirectoryWatcher(args[0], seconds);
        dw.addListener(new FileListener());
        dw.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getCurrentFiles() {
        HashMap<String, Long> cF = new HashMap<String, Long>();
        Connection conection = CONFIG.doConnection();
        try {
            ResultSet rs = conection.createStatement().executeQuery("SELECT * FROM currentFiles;");
            while (rs.next()) {
                cF.put(rs.getString("path"), new Long(rs.getLong("creation_date")));
            }
        }
        catch (SQLException sqle) {
            this.logger.error("SQLException Message:" + sqle.getMessage());
        }
        finally {
            try {
                if (conection != null) {
                    conection.close();
                }
            }
            catch (Exception exception) {}
        }
        return cF;
    }

    @Override
    public void start() {
        this.currentFiles = this.getCurrentFiles();
        super.start();
        this.logger.debug("Monitoreo del directorio: " + this.directory + " iniciado");
        File theDirectory = new File(this.directory);
        this.monitoringStarted(theDirectory);
    }

    @Override
    public void stop() {
        super.stop();
        File theDirectory = new File(this.directory);
        this.monitoringStopped(theDirectory);
    }

    private void takeSnapshot() {
        this.prevFiles.clear();
        this.prevFiles.putAll(this.currentFiles);
        this.currentFiles.clear();
        File theDirectory = new File(this.directory);
        File[] children = theDirectory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File file = children[i];
            this.currentFiles.put(file.getAbsolutePath(), new Long(file.lastModified()));
            this.logger.debug("Registrando el archivo" + file.getAbsolutePath() + " ultima modificacion:" + file.lastModified());
        }
    }

    public void executeOnce() {
        this.executeOnce = true;
    }

    @Override
    protected void doInterval() {
        this.takeSnapshot();
        for (String fileName : this.currentFiles.keySet()) {
            Long prevModified;
            Long lastModified = (Long)this.currentFiles.get(fileName);
            if (!this.prevFiles.containsKey(fileName)) {
                this.resourceAdded(new File(fileName));
                continue;
            }
            if (!this.prevFiles.containsKey(fileName) || (prevModified = (Long)this.prevFiles.get(fileName)).compareTo(lastModified) == 0) continue;
            this.resourceChanged(new File(fileName));
        }
        for (String fileName : this.prevFiles.keySet()) {
            if (this.currentFiles.containsKey(fileName)) continue;
            this.resourceDeleted(new File(fileName));
        }
        if (this.currentFiles.isEmpty() && this.executeOnce) {
            this.logger.info("No se encontr\u00f3 ningun archivo... terminando programa...");
            System.exit(0);
        }
    }
}

