/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client.invoice;

import com.solucionfactible.ws.cfdi.CFDIPortType;
import com.solucionfactible.ws.cfdi.CFDI_ServiceLocator;
import com.solucionfactible.ws.cfdi.Envio;
import com.solucionfactible.ws.cfdi.RespuestaEnvio;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientController;
import s.f.util.InvalidDataException;

public class ERPMailSender
extends Thread {
    ClientApp application = null;
    String userName = null;
    String password = null;
    Long folio = null;
    String serie = null;
    Boolean zip = null;
    Boolean xml = null;
    String subject = null;
    String customMessage = null;
    String to = null;
    Long disenoPDF = null;
    Long disegnoMail = null;
    Logger logger = Logger.getLogger(ERPMailSender.class);

    public ERPMailSender(ClientApp app, String userName, String password, Long folio, String serie, Boolean zip, Boolean xml, String subject, String customMessage, String to, Long disenoPDF, Long disegnoMail) {
        this.application = app;
        this.folio = folio;
        this.disenoPDF = disenoPDF;
        this.serie = serie;
        this.userName = userName;
        this.password = password;
        this.to = to;
        this.zip = zip;
        this.xml = xml;
        this.customMessage = customMessage;
        this.subject = subject;
        this.disegnoMail = disegnoMail;
    }

    @Override
    public void run() {
        ERPClientController app = null;
        if (this.application instanceof ERPClientController) {
            app = (ERPClientController)this.application;
            try {
                boolean sent = this.send(this.userName, this.password, this.disenoPDF, this.folio, this.serie, this.to);
                if (sent) {
                    this.logger.info(String.format("EL CFD %d%s ha sido enviado con \u00e9xito usando el dise\u00f1o %d a %s.", this.folio, this.serie, this.disenoPDF, this.to));
                    app.addToMainLog(String.format("EL CFD %d%s ha sido enviado con \u00e9xito usando el dise\u00f1o %d a %s.", this.folio, this.serie, this.disenoPDF, this.to));
                }
            }
            catch (InvalidDataException e) {
                this.logger.error(String.format("Error al enviar el CFD %d%s con el dise\u00f1o %d a %s. ", this.folio, this.serie, this.disenoPDF, this.to, e.getSource()));
            }
            catch (Exception e) {
                this.logger.error(String.format("Error al enviar el CFD %d%s con el dise\u00f1o %d a %s. [%s] %s", this.folio, this.serie, this.disenoPDF, this.to, e.getClass().getName(), e.getMessage()));
            }
        }
    }

    private boolean send(String username, String password, Long diseno, Long folio, String serie, String to) throws InvalidDataException {
        try {
            if (this.application instanceof ERPClientController) {
                ERPClientController clientapp = (ERPClientController)this.application;
                URL webServiceURL = new URL("https", ERPClientApp.getApplication().getUsingHost(), "/ws/services/CFDI");
                this.logger.debug("Localizando WebService");
                CFDI_ServiceLocator service = new CFDI_ServiceLocator();
                this.logger.debug("Conectandose a: " + webServiceURL.toString());
                CFDIPortType port = service.getCFDIHttpsSoap11Endpoint(webServiceURL);
                this.logger.debug("Conexi\u00f3n exitosa!");
                Envio[] env = new Envio[]{new Envio(to.split("[,;]"), this.disenoPDF, folio, serie, null)};
                RespuestaEnvio respuesta = port.enviar(username, password, this.disegnoMail, this.subject, this.customMessage, this.zip, env);
                if (respuesta.getMensaje() != null && respuesta.getEstatus() == 500) {
                    this.logger.error(String.format("Error al generar el mensaje de e-mail para el env\u00edo del comprobante %d%s a %s. %s", folio, serie, to, respuesta.getMensaje()));
                    clientapp.addToMainLog(String.format("Error al generar el mensaje de e-mail para el env\u00edo del comprobante %d%s a %s. %s", folio, serie, to, respuesta.getMensaje()));
                    return false;
                }
            }
        }
        catch (AxisFault af) {
            System.err.println("");
            System.err.println("SOAP request generated a fault: " + af.getMessage());
            System.err.println("");
            this.logger.error("AxisFault", af);
            throw new InvalidDataException(String.format("Error al enviar CFD %d%s con el dise\u00f1o %d %s", folio, serie, diseno, af.getFaultString()));
        }
        catch (ServiceException e) {
            this.logger.error("Serviceexception", e);
            throw new InvalidDataException("Error al enviar el mensaje de correo electr\u00f3nico.");
        }
        catch (RemoteException e) {
            this.logger.error("RemoteException", e);
            throw new InvalidDataException("Error al invoicar el m\u00edtodo para el ev\u00ed0 del CFD.");
        }
        catch (MalformedURLException e) {
            this.logger.debug("Error en la URL del WS", e);
        }
        return true;
    }
}

