/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client.invoice;

import com.solucionfactible.crm.ws.factura.WSFacturaControllerRemote;
import com.solucionfactible.crm.ws.factura.WSFacturaControllerRemoteServiceLocator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientController;
import s.f.util.InvalidDataException;

public class ERPInvoiceDownloader
extends Thread {
    ERPClientController application = null;
    Long folio = null;
    Long diseno = null;
    String serie = null;
    String userName = null;
    String password = null;
    File path = null;
    File pdfFile = null;
    private String fileType = null;
    private Logger logger = Logger.getLogger(ERPInvoiceDownloader.class);

    public ERPInvoiceDownloader(ClientApp app, String userName, String password, Long folio, String serie, File path) {
        this(app, userName, password, null, folio, serie, path);
    }

    public ERPInvoiceDownloader(ClientApp app, String userName, String password, Long diseno, Long folio, String serie, File path) {
        if (app instanceof ERPClientController) {
            this.application = (ERPClientController)app;
        }
        this.folio = folio;
        this.diseno = diseno;
        this.serie = serie;
        this.userName = userName;
        this.password = password;
        this.path = path;
    }

    @Override
    public void run() {
        this.fileType = this.diseno == null ? "XML" : "PDF";
        try {
            String fileName = this.download(this.userName, this.password, this.diseno, this.folio, this.serie);
            this.logger.info(String.format("EL %s del comprobante %d%s ha sido descargado con \u00e9xito y almacenado como %s.", this.fileType, this.folio, this.serie, fileName));
            this.application.addToMainLog(String.format("EL %s del comprobante %d%s ha sido descargado con \u00e9xito y almacenado como %s.", this.fileType, this.folio, this.serie, fileName));
            this.application.printDownloadedFile(this.pdfFile);
        }
        catch (InvalidDataException e) {
            this.logger.error(String.format("Error al descargar el %s de comprobante %d%s con el dise\u00f1o %d.", this.fileType, this.folio, this.serie, this.diseno), e);
        }
        catch (Exception e) {
            this.logger.error(String.format("Error al descargar el %s de comprobante %d%s con el dise\u00f1o %d. [%s] %s", this.fileType, this.folio, this.serie, this.diseno, e.getClass().getName(), e.getMessage()));
        }
    }

    private String download(String username, String password, Long diseno, Long folio, String serie) throws InvalidDataException {
        HashMap response = null;
        String extensionArchivo = "";
        try {
            this.logger.debug("Localizando WebService para descarga de archivos");
            WSFacturaControllerRemoteServiceLocator service = new WSFacturaControllerRemoteServiceLocator();
            WSFacturaControllerRemote stub = null;
            try {
                URL urlToWebService = new URL("https", ERPClientApp.getApplication().getUsingHost(), "/crm/ws/WSFactura");
                this.logger.debug("Conectandose usando url=" + urlToWebService.toString());
                stub = service.getWSFactura(urlToWebService);
            }
            catch (MalformedURLException e) {
                this.logger.debug("MalformedURLException", e);
            }
            String rName = null;
            String rData = null;
            if (diseno == null) {
                this.logger.debug("Descargando archivo XML");
                response = stub.getData(username, password, folio, serie);
                this.logger.debug("Archivo XML descargado con \u00e9xito!");
                rData = (String)response.get("XML");
                rName = "CFD";
                extensionArchivo = "XML";
            } else {
                this.logger.debug("Descargando archivo PDF");
                response = stub.getPDF(username, password, diseno, folio, serie);
                this.logger.debug("Archivo PDF descargado con \u00e9xito!");
                extensionArchivo = "PDF";
                rName = (String)response.get("REPORT_NAME");
                rData = (String)response.get("REPORT");
            }
            String err = (String)response.get("ERROR");
            if (err != null) {
                this.logger.debug("ERROR " + err);
                throw new InvalidDataException(err);
            }
            this.logger.debug("Procesando archivo \" " + extensionArchivo + "\"");
            return this.savePDF(rName, Base64.decode(rData));
        }
        catch (AxisFault af) {
            this.logger.error("SOAP request generated a fault: ", af);
            this.logger.error(String.format("Error al descargar el %s del comprobante %d%s con el dise\u00f1o %d.", extensionArchivo, folio, serie, diseno), af);
            throw new InvalidDataException(String.format("Error al descargar el %s del comprobante %d%s con el dise\u00f1o %d. %s", extensionArchivo, folio, serie, diseno, af.getFaultString()));
        }
        catch (ServiceException e) {
            this.logger.error("Error al enviar el archivo", e);
            throw new InvalidDataException("Error al enviar el archivo.");
        }
        catch (RemoteException e) {
            this.logger.error("Error al invocar el m\u00edtodo para el ev\u00ed0 del archivo.", e);
            throw new InvalidDataException("Error al invocar el m\u00edtodo para el ev\u00ed0 del archivo.");
        }
    }

    private String savePDF(String name, byte[] pdf) {
        String fName = String.format("%s-%d%s." + this.fileType.toLowerCase(), name.replaceAll("\\s", "_"), this.folio, this.serie);
        File file = new File(this.path.getAbsolutePath(), fName);
        try {
            this.logger.debug("Generando el archivo \"" + fName + "\"");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(pdf);
            fos.close();
            this.pdfFile = file;
            this.logger.debug("Archivo generado y almacenado correctamente \"" + fName + "\"");
        }
        catch (IOException e) {
            this.logger.error(String.format("Error al almacenar el archivo descargado en %s.", file.getAbsolutePath()), e);
        }
        return fName;
    }
}

