/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client.invoice;

import com.solucionfactible.cfdi.ws.timbrado.TimbradoLocator;
import com.solucionfactible.cfdi.ws.timbrado.TimbradoPortType;
import com.solucionfactible.cfdi.ws.timbrado.xsd.CFDICertificacion;
import com.solucionfactible.ws.cfdi.CFDIPortType;
import com.solucionfactible.ws.cfdi.CFDI_ServiceLocator;
import com.solucionfactible.ws.cfdi.RespuestaCreacion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.file.ERPFileListener;
import s.f.util.InvalidDataException;

public class ERPFileSender
extends Thread {
    private ERPClientApp application = null;
    private ERPFileListener listener = null;
    private String userName = null;
    private String password = null;
    private File file = null;
    private long delay = 0L;
    private String action = null;
    private String environment = null;
    protected final String SF_TIMBRADO_TESTING = "http://testing.solucionfactible.com/ws/services/Timbrado?wsdl";
    Logger logger = Logger.getLogger(ERPFileSender.class);

    public ERPFileSender(ClientApp app, ERPFileListener listener, String userName, String password, File file, Integer delay, String action, String environment) {
        super("ERPSenderThread-" + file.getName());
        if (app instanceof ERPClientApp) {
            this.application = (ERPClientApp)app;
        }
        this.listener = listener;
        this.userName = userName;
        this.password = password;
        this.file = file;
        this.action = action;
        this.environment = environment;
        if (delay != null) {
            this.delay = 1000L * delay.longValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception e) {
                this.logger.error("Exception", e);
            }
        }
        this.logger.debug("Se va a mandar el archivo " + this.file + "acci\u00f3n: [" + this.action + "] ambiente: [" + this.environment + "]");
        try {
            this.logger.debug("Enviando el archivo");
            Object resp = this.send(this.userName, this.password, this.file, this.action, this.environment);
            RespuestaCreacion mResponse = null;
            CFDICertificacion cResponse = null;
            try {
                mResponse = (RespuestaCreacion)resp;
                this.application.log(this.file, mResponse);
                this.logger.debug("Envio terminado");
                this.application.sendCompleted(mResponse);
            }
            catch (ClassCastException e) {
                this.application.log(this.file, e.getMessage());
            }
            try {
                cResponse = (CFDICertificacion)resp;
                if (this.application instanceof ERPClientApp) {
                    ERPClientApp app = this.application;
                    app.log(this.file, cResponse);
                    this.logger.debug("Envio terminado");
                    app.sendCompleted(this.file, cResponse);
                }
            }
            catch (ClassCastException e) {
                this.application.log(this.file, e.getMessage());
            }
        }
        catch (InvalidDataException ex) {
            this.application.log(this.file, ex.getSource());
        }
        catch (Exception e) {
            this.logger.error(this.file, e);
        }
        finally {
            this.listener.decrementaEnvios();
        }
    }

    public Object send(String userName, String password, File iFile, String action, String environment) throws InvalidDataException {
        Serializable response = null;
        byte[] fileContent = null;
        try {
            FileInputStream fis = new FileInputStream(iFile);
            int avail = fis.available();
            if (avail > 0x100000) {
                this.logger.error(String.format("[ERROR] Archivo demasiado grande: %s [%d bytes]", iFile.getName(), avail));
                fis.close();
                throw new InvalidDataException(String.format("[ERROR] Archivo demasiado grande: %s [%d bytes]", iFile.getName(), avail));
            }
            fileContent = new byte[avail];
            fis.read(fileContent);
            fis.close();
        }
        catch (FileNotFoundException e) {
            this.application.log("[ERROR] No se encontr\u00f3 el archivo " + iFile.getAbsolutePath());
            throw new InvalidDataException("[ERROR] Al tratar de enviar el archivo. No se encontr\u00f3 el archivo " + iFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.application.log("[ERROR] No se pudo leer el archivo");
            throw new InvalidDataException("Error al leer el archivo");
        }
        if ("generar".equals(action)) {
            response = this.sendGenerar(userName, password, iFile, fileContent);
        } else if ("timbrar".equals(action)) {
            response = this.sendTimbrar(userName, password, iFile, fileContent, environment);
        } else {
            this.application.log("[ERROR] No se ha especificado un comportamiento valido para esta aplicaci\u00f3n");
        }
        this.application.addToMainTable(this.file.getName(), "ENVIADO", "El archivo a sido enviado, esperando respuesta...", new Date());
        return response;
    }

    private RespuestaCreacion sendGenerar(String userName, String password, File iFile, byte[] fileContent) throws InvalidDataException {
        RespuestaCreacion respuestaCreacion = null;
        boolean isZip = false;
        try {
            URL webServiceURL = new URL("https", ERPClientApp.getApplication().getUsingHost(), "/ws/services/CFDI");
            this.logger.debug("Localizando WebService");
            CFDI_ServiceLocator service = new CFDI_ServiceLocator();
            this.logger.debug("Conectandose a: " + webServiceURL.toString());
            CFDIPortType port = service.getCFDIHttpsSoap11Endpoint(webServiceURL);
            this.logger.debug("Conexi\u00f3n exitosa!");
            if (iFile.getName().endsWith(".zip")) {
                isZip = true;
            }
            this.logger.debug(String.format("Llamando al m\u00e9todo importar con datos: userName: %s password: ***** fileContent: %s isZip: %s", userName, fileContent.toString(), isZip));
            respuestaCreacion = port.importar(userName, password, fileContent, isZip);
            this.logger.debug("Ejecuci\u00f3n del m\u00e9todo importar() se realiz\u00f3 con  \u00e9xito!");
        }
        catch (AxisFault af) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, se reintentar\u00e1 enviar el archivo:" + this.file.getName());
            this.logger.error("[ERROR] Al enviar el archivo " + iFile.getName() + ". " + af.getFaultString());
            this.logger.error("SOAP request generated a fault", af);
            this.file.setLastModified(new Date().getTime());
            throw new InvalidDataException("[ERROR] Al enviar el archivo " + iFile.getName() + ". " + af.getFaultString());
        }
        catch (ServiceException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidorse reintentar\u00e1 enviar el archivo:" + this.file.getName());
            this.logger.error("ServiceException", e);
            this.file.setLastModified(new Date().getTime());
            throw new InvalidDataException("[ERROR] Mientras se enviaba el archivo " + iFile.getName() + " " + e.getLinkedCause());
        }
        catch (RemoteException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, se reintentar\u00e1 enviar el archivo:" + this.file.getName());
            this.logger.error("[ERROR] RemoteException ", e);
            this.file.setLastModified(new Date().getTime());
            throw new InvalidDataException("[ERROR] Al invocar el m\u00edtodo para el ev\u00ed0 del archivo. " + iFile.getName());
        }
        catch (IOException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, se reintentar\u00e1 enviar el archivo:" + this.file.getName());
            this.logger.error("IOException", e);
            this.file.setLastModified(new Date().getTime());
            throw new InvalidDataException("[ERROR] Ocurri\u00f3n un error mientras se intentaba conectar al servidor");
        }
        return respuestaCreacion;
    }

    private CFDICertificacion sendTimbrar(String userName, String password, File iFile, byte[] fileContent, String environment) throws InvalidDataException {
        CFDICertificacion response = null;
        TimbradoLocator tService = new TimbradoLocator();
        TimbradoPortType port = null;
        try {
            port = "testing".equals(environment) ? tService.getTimbradoHttpsSoap11Endpoint(new URL("http://testing.solucionfactible.com/ws/services/Timbrado?wsdl")) : tService.getTimbradoHttpsSoap11Endpoint(new URL("https", ERPClientApp.getApplication().getUsingHost(), "/ws/services/Timbrado"));
            response = port.timbrar(userName, password, fileContent, Boolean.FALSE);
        }
        catch (MalformedURLException ex) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.logger.fatal("Fatal", ex);
        }
        catch (AxisFault af) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            System.err.println("");
            System.err.println("[ERROR] SOAP request generated a fault: " + af.getMessage());
            System.err.println("");
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, revisar log para mayor informaci\u00f3n");
            this.logger.error("[ERROR] Al enviar el archivo MalformedURLException ", af);
            throw new InvalidDataException("[ERROR] al enviar el archivo " + iFile.getName() + ". " + af.getFaultString());
        }
        catch (ServiceException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, revisar log para mayor informaci\u00f3n");
            this.logger.error("[ERROR] Al enviar el archivo. ServiceException", e);
            throw new InvalidDataException("[ERROR] Al enviar el archivo.");
        }
        catch (RemoteException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, revisar log para mayor informaci\u00f3n");
            this.logger.error("[ERROR] Al invocar el m\u00edtodo para el ev\u00ed0 del archivo. InvalidDataException ", e);
            throw new InvalidDataException("[ERROR] Al invocar el m\u00edtodo para el ev\u00ed0 del archivo.");
        }
        catch (IOException e) {
            this.application.addToMainTable(iFile.getName(), "ERROR", "Error de conexi\u00f3n", new Date());
            this.application.addToMainLog("ERROR No se pudo establecer conexi\u00f3n con servidor, revisar log para mayor informaci\u00f3n");
            this.logger.error("IOException", e);
        }
        return response;
    }

    private void setProxySettings() {
    }

    @Override
    public void start() {
        super.start();
        this.listener.incrementaEnvios();
    }
}

