/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client.file;

import java.io.File;
import java.sql.Connection;
import java.util.Map;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.invoice.ERPFileSender;
import s.f.erp.utils.fs.watcher.BaseListener;
import s.f.erp.utils.fs.watcher.IFileListener;
import s.f.util.Utils;

public class ERPFileListener
extends BaseListener
implements IFileListener {
    private Map config = null;
    private ClientApp application = null;
    private Connection connection = null;
    private volatile int contadorEnvios = 0;
    private int maxEnvios = 1;
    private ERPClientApp ERPApp = null;

    public ERPFileListener(ClientApp application, Map config) {
        this.config = config;
        this.application = application;
        if (application instanceof ERPClientApp) {
            this.ERPApp = (ERPClientApp)application;
        }
        this.connection = CONFIG.doConnection();
    }

    public ERPFileListener(ClientApp app, String name, Map config) {
        this.config = config;
        this.application = app;
        if (this.application instanceof ERPClientApp) {
            this.ERPApp = (ERPClientApp)this.application;
        }
        this.connection = CONFIG.doConnection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConfig(Map config) {
        this.config = config;
    }

    @Override
    public void onStart(Object monitoredResource) {
        if (monitoredResource instanceof File) {
            this.onAdd(monitoredResource);
        }
    }

    @Override
    public void onStop(Object notMonitoredResource) {
    }

    @Override
    public void onAdd(Object newResource) {
        if (newResource instanceof File && ((File)newResource).isFile()) {
            File file = (File)newResource;
            String fName = file.getName();
            this.ERPApp.addToMainLog("Se ha encontrado el archivo: \"" + fName + "\"");
            String ext = Utils.cleanString((String)this.config.get("FILE_EXTENSION")).toLowerCase();
            if (file.getName().toLowerCase().endsWith(ext)) {
                this.ERPApp.addToMainLog("Se enviar\u00e1 el archivo: \"" + fName + "\"");
                String path = file.getAbsolutePath();
                long lastModified = file.lastModified();
                CONFIG.doInserts(path, this.connection, lastModified);
                this.sendFile(file);
            } else {
                this.ERPApp.addToMainLog("No se enviar\u00e1 el archivo: \"" + fName + "\" porque no cumple con el criterio");
            }
        }
    }

    @Override
    public synchronized void onChange(Object changedResource) {
        if (changedResource instanceof File && ((File)changedResource).isFile()) {
            File file = (File)changedResource;
            String fName = file.getName();
            this.ERPApp.addToMainLog("Se han detectado cambios en el archivo: \"" + fName + "\"");
            String ext = Utils.cleanString((String)this.config.get("FILE_EXTENSION"));
            if (file.getName().endsWith(ext)) {
                this.ERPApp.addToMainLog("Se enviar\u00e1 el archivo: " + fName);
                String path = file.getAbsolutePath();
                long lastModified = file.lastModified();
                CONFIG.updateRecord(this.connection, path, lastModified);
                this.sendFile(file);
            } else {
                this.ERPApp.addToMainLog("No se enviar\u00e1 el archivo : \"" + fName + "\" porque no cumple con el criterio");
            }
        }
    }

    @Override
    public void onDelete(Object deletedResource) {
        if (deletedResource instanceof File) {
            File file = (File)deletedResource;
            String path = file.getAbsolutePath();
            CONFIG.deleteRecord(path, this.connection);
        }
    }

    private void sendFile(File file) {
        if (file.isFile()) {
            String userName = (String)this.config.get("USERNAME");
            String password = (String)this.config.get("PASSWORD");
            Integer delayToSend = (Integer)this.config.get("DELAY_TO_SEND");
            String action = (String)this.config.get("ACTION");
            String environment = (String)this.config.get("ENVIRONMENT");
            ERPFileSender sender = new ERPFileSender(this.application, this, userName, password, file, delayToSend, action, environment);
            sender.start();
        }
    }

    public synchronized void incrementaEnvios() {
        try {
            if (this.contadorEnvios == this.maxEnvios) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ++this.contadorEnvios;
    }

    public synchronized void decrementaEnvios() {
        --this.contadorEnvios;
        this.notifyAll();
    }
}

