/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.remote.client.ERPClientAboutBox;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientConfigDialog;
import s.f.erp.remote.client.ERPClientLogDialog;

public class ERPClientView
extends FrameView {
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog configFrame;
    private JDialog logDialog;
    private Map config = null;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JSplitPane jSplitPane1;
    private JLabel lblDir;
    private JList mainLog;
    private JScrollPane mainLogContainer;
    private JPanel mainPanel;
    private JScrollPane mainTblContainer;
    private JMenuBar menuBar;
    private JMenuItem openConfig;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JTable tblMain;

    public ERPClientView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.config = ERPClientApp.getApplication().getConfig();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERPClientView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERPClientView.this.busyIconIndex = (ERPClientView.this.busyIconIndex + 1) % ERPClientView.this.busyIcons.length;
                ERPClientView.this.statusAnimationLabel.setIcon(ERPClientView.this.busyIcons[ERPClientView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ERPClientView.this.busyIconTimer.isRunning()) {
                        ERPClientView.this.statusAnimationLabel.setIcon(ERPClientView.this.busyIcons[0]);
                        ERPClientView.this.busyIconIndex = 0;
                        ERPClientView.this.busyIconTimer.start();
                    }
                    ERPClientView.this.progressBar.setVisible(true);
                    ERPClientView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ERPClientView.this.busyIconTimer.stop();
                    ERPClientView.this.statusAnimationLabel.setIcon(ERPClientView.this.idleIcon);
                    ERPClientView.this.progressBar.setVisible(false);
                    ERPClientView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ERPClientView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ERPClientView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ERPClientView.this.progressBar.setVisible(true);
                    ERPClientView.this.progressBar.setIndeterminate(false);
                    ERPClientView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ERPClientApp.getApplication().getMainFrame();
            this.aboutBox = new ERPClientAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ERPClientApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void openConfig() {
        JFrame mainFrame = ERPClientApp.getApplication().getMainFrame();
        boolean firstBoot = false;
        if (this.config.isEmpty()) {
            firstBoot = true;
        }
        this.configFrame = new ERPClientConfigDialog((Frame)mainFrame, true, firstBoot);
        this.configFrame.setLocationRelativeTo(mainFrame);
        ERPClientApp.getApplication().show(this.configFrame);
    }

    public void openConfig(boolean firstBoot) {
        JFrame mainFrame = ERPClientApp.getApplication().getMainFrame();
        this.configFrame = new ERPClientConfigDialog((Frame)mainFrame, true, firstBoot);
        this.configFrame.setLocationRelativeTo(mainFrame);
        ERPClientApp.getApplication().show(this.configFrame);
    }

    @Action
    public void showLog() {
        JFrame mainFrame = ERPClientApp.getApplication().getMainFrame();
        if (this.logDialog == null) {
            this.logDialog = new ERPClientLogDialog((Frame)mainFrame, false);
        }
        this.logDialog.setLocationRelativeTo(mainFrame);
        this.logDialog.setSize(600, 400);
        ERPClientApp.getApplication().show(this.logDialog);
    }

    @Action
    public void startMonitor() {
    }

    @Action
    public void stopMonitor() {
    }

    @Action
    public void clearTable() {
        DefaultTableModel model = (DefaultTableModel)this.tblMain.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    @Action
    public void reiniciarApp() {
        try {
            CONFIG.shutdownDB();
            String command = System.getProperty("user.dir") + File.separator + "consola.sh";
            System.out.println("Ejecutando comando " + command);
            Process pr = Runtime.getRuntime().exec(command);
            System.out.println("Comando ejecutado");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("[ERROR] " + e.getMessage());
        }
    }

    @Action
    public void exitApp() {
        CONFIG.shutdownDB();
        System.exit(0);
    }

    @Action
    public void clearMainLog() {
        DefaultListModel model = (DefaultListModel)this.mainLog.getModel();
        model.clear();
    }

    @Action
    public void abrirDirDescargas() {
        String dirDescargas = "";
        Map config = ERPClientApp.getApplication().getConfig();
        if (config.containsKey("PDF_DIRECTORY")) {
            dirDescargas = (String)config.get("PDF_DIRECTORY");
            this.abrirDir(dirDescargas);
        }
    }

    @Action
    public void abrirDirEscaner() {
        String dirDescargas = "";
        Map config = ERPClientApp.getApplication().getConfig();
        if (config.containsKey("DIRECTORY")) {
            dirDescargas = (String)config.get("DIRECTORY");
            this.abrirDir(dirDescargas);
        }
    }

    public void abrirDir(String pathDir) {
        File fDir = null;
        if (Desktop.isDesktopSupported() && !pathDir.isEmpty()) {
            try {
                fDir = new File(pathDir);
                Desktop.getDesktop().open(fDir);
            }
            catch (IOException e) {
                System.out.println("No se pudo abrir la carpeta " + e.getLocalizedMessage());
            }
            catch (SecurityException e) {
                System.out.println("No se tienen los permisos necesarios para abrir la carpeta" + pathDir + e.getLocalizedMessage());
            }
        }
    }

    public void addToLogWindow(String msg) {
        if (this.logDialog != null && this.logDialog instanceof ERPClientLogDialog) {
            ((ERPClientLogDialog)this.logDialog).appendToLogWindow(msg);
        }
    }

    public void addToMainTable(String file, String status, String detalles, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Object[] row = new Object[]{sdf.format(date), file, status, detalles};
        DefaultTableModel model = (DefaultTableModel)this.tblMain.getModel();
        model.addRow(row);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ERPClientView.this.tblMain.scrollRectToVisible(ERPClientView.this.tblMain.getCellRect(ERPClientView.this.tblMain.getRowCount() - 1, 0, true));
            }
        });
    }

    public void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public void addMainLog(String message) {
        DefaultListModel model = (DefaultListModel)this.mainLog.getModel();
        int pos = model.getSize();
        model.add(pos, message);
        this.mainLog.ensureIndexIsVisible(pos);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ERPClientView.this.mainLog.ensureIndexIsVisible(ERPClientView.this.mainLog.getModel().getSize());
            }
        });
    }

    public void showErrorMessage(String err) {
    }

    public void setLabelWacthingDirectory(String dir) {
        this.lblDir.setText(dir);
    }

    public void setTitle(String title) {
        this.getFrame().setTitle(title);
    }

    public void setMainWindowGUIMisc() {
        if (this.config.isEmpty()) {
            this.config = ERPClientApp.getApplication().getConfig();
        }
        this.setLabelWacthingDirectory((String)this.config.get("DIRECTORY"));
        if (this.config.containsKey("ACTION")) {
            String action = ((String)this.config.get("ACTION")).toUpperCase();
            String env = "";
            if ("TIMBRAR".equals(action) && this.config.containsKey("ENVIRONMENT")) {
                env = (String)this.config.get("ENVIRONMENT");
                env = env.toUpperCase();
            }
            this.setTitle(String.format("SF:ERP Connector [%s %s]", action, env));
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane(0);
        this.mainTblContainer = new JScrollPane();
        this.tblMain = new JTable();
        this.mainLogContainer = new JScrollPane();
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement("Log");
        this.mainLog = new JList(model);
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.openConfig = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.lblDir = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.mainPanel.setName("SFERP Client Connector");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.mainTblContainer.setAutoscrolls(true);
        this.mainTblContainer.setName("mainTblContainer");
        this.tblMain.setModel(new DefaultTableModel(new Object[0][], new String[]{"Fecha/Hora", "Archivo", "Status", "Detalle"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblMain.setName("tblMain");
        this.mainTblContainer.setViewportView(this.tblMain);
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(ERPClientView.class);
        this.tblMain.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("jTable1.columnModel.title2", new Object[0]));
        this.tblMain.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("tblMain.columnModel.title0", new Object[0]));
        this.tblMain.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("tblMain.columnModel.title1", new Object[0]));
        this.tblMain.getColumnModel().getColumn(3).setHeaderValue(resourceMap.getString("jTable1.columnModel.title3", new Object[0]));
        this.jSplitPane1.setLeftComponent(this.mainTblContainer);
        this.mainLogContainer.setAutoscrolls(true);
        this.mainLogContainer.setName("mainLogContainer");
        this.mainLog.setName("mainLog");
        this.mainLogContainer.setViewportView(this.mainLog);
        this.jSplitPane1.setRightComponent(this.mainLogContainer);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 723, Short.MAX_VALUE).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 412, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setTopComponent(this.mainTblContainer);
        this.jSplitPane1.setBottomComponent(this.mainLogContainer);
        this.jSplitPane1.setDividerLocation(300);
        this.menuBar.setName("menuBar");
        fileMenu.setMnemonic('A');
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setToolTipText(resourceMap.getString("fileMenu.toolTipText", new Object[0]));
        fileMenu.setName("fileMenu");
        fileMenu.setPreferredSize(new Dimension(65, 23));
        ApplicationActionMap actionMap = Application.getInstance().getContext().getActionMap(ERPClientView.class, this);
        this.openConfig.setAction(actionMap.get("openConfig"));
        this.openConfig.setText(resourceMap.getString("openConfig.text", new Object[0]));
        this.openConfig.setToolTipText(resourceMap.getString("openConfig.toolTipText", new Object[0]));
        this.openConfig.setName("openConfig");
        this.openConfig.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ERPClientView.this.openConfigMouseClicked(evt);
            }
        });
        this.openConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ERPClientView.this.openConfigActionPerformed(evt);
            }
        });
        fileMenu.add(this.openConfig);
        this.jMenuItem1.setAction(actionMap.get("clearTable"));
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        fileMenu.add(this.jMenuItem1);
        this.jMenuItem3.setAction(actionMap.get("clearMainLog"));
        this.jMenuItem3.setText(resourceMap.getString("jMenuItem3.text", new Object[0]));
        this.jMenuItem3.setName("jMenuItem3");
        fileMenu.add(this.jMenuItem3);
        this.jMenuItem2.setAction(actionMap.get("showLog"));
        this.jMenuItem2.setText(resourceMap.getString("jMenuItem2.text", new Object[0]));
        this.jMenuItem2.setName("jMenuItem2");
        fileMenu.add(this.jMenuItem2);
        exitMenuItem.setAction(actionMap.get("exitApp"));
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setToolTipText(resourceMap.getString("exitMenuItem.toolTipText", new Object[0]));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.jMenu3.setMnemonic('I');
        this.jMenu3.setText(resourceMap.getString("jMenu3.text", new Object[0]));
        this.jMenu3.setToolTipText(resourceMap.getString("jMenu3.toolTipText", new Object[0]));
        this.jMenu3.setName("jMenu3");
        this.jMenuItem5.setAction(actionMap.get("abrirDirEscaner"));
        this.jMenuItem5.setText(resourceMap.getString("jMenuItem5.text", new Object[0]));
        this.jMenuItem5.setName("jMenuItem5");
        this.jMenu3.add(this.jMenuItem5);
        this.jMenuItem4.setAction(actionMap.get("abrirDirDescargas"));
        this.jMenuItem4.setText(resourceMap.getString("jMenuItem4.text", new Object[0]));
        this.jMenuItem4.setName("jMenuItem4");
        this.jMenu3.add(this.jMenuItem4);
        this.menuBar.add(this.jMenu3);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setText(resourceMap.getString("aboutMenuItem.text", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.lblDir.setText(resourceMap.getString("lblDir.text", new Object[0]));
        this.lblDir.setToolTipText(resourceMap.getString("lblDir.toolTipText", new Object[0]));
        this.lblDir.setName("lblDir");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 723, Short.MAX_VALUE).addComponent(this.statusAnimationLabel).addContainerGap()).addComponent(statusPanelSeparator, -1, 747, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap(599, Short.MAX_VALUE).addComponent(this.progressBar, -2, 136, -2).addContainerGap()).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lblDir, -1, 54, Short.MAX_VALUE).addContainerGap(502, Short.MAX_VALUE)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel)).addComponent(this.progressBar, -2, -1, -2)).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblDir))).addContainerGap()));
        this.jMenuBar1.setName("jMenuBar1");
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText(resourceMap.getString("jMenu2.text", new Object[0]));
        this.jMenu2.setName("jMenu2");
        this.jMenuBar1.add(this.jMenu2);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void openConfigActionPerformed(ActionEvent evt) {
    }

    private void openConfigMouseClicked(MouseEvent evt) {
    }
}

