/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientAppLauncher;
import s.f.util.InvalidDataException;
import s.f.util.Utils;
import s.f.util.xml.XMLUtils;

public class ERPClientMasterConfigThread
extends Thread {
    private final int seconds = 10;
    private final String name = "MasterConfigFileCheckThread";
    private String masterConfigFile = null;
    private boolean active = false;
    Logger logger = Logger.getLogger(ERPClientMasterConfigThread.class);

    public void ERPClientMasterConfigThread() {
        this.masterConfigFile = "master.xml";
    }

    @Override
    public void start() {
        this.active = true;
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                this.checkConfigFile();
                ERPClientMasterConfigThread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkConfigFile() {
        String wName = null;
        String wActive = null;
        String wConfigPath = null;
        try {
            File f = new File(this.masterConfigFile);
            if (f.exists() && f.isFile()) {
                this.logger.debug("Archivo " + this.masterConfigFile + " existe, procesando");
                Document doc = XMLUtils.loadXML(new FileInputStream(this.masterConfigFile));
                Element conf = doc.getRootElement();
                List xmlWatchers = conf.getChildren();
                ArrayList<Map> configs = new ArrayList<Map>();
                HashMap<String, Object> watcher = null;
                for (Element e : xmlWatchers) {
                    wName = e.getAttributeValue("name");
                    wActive = e.getAttributeValue("active");
                    wConfigPath = e.getAttributeValue("configPath");
                    if (Utils.isParameterValid(wName) && Utils.isParameterValid(wConfigPath) && Utils.isParameterValid(wActive)) {
                        watcher = new HashMap<String, Object>();
                        watcher.put("NAME", wName);
                        watcher.put("ACTIVE", wActive);
                        watcher.put("CONFIG_FILE", wConfigPath);
                        HashMap<String, String> options = new HashMap<String, String>();
                        watcher.put("CONFIG", ERPClientAppLauncher.loadConfig(options));
                        configs.add(watcher);
                        continue;
                    }
                    this.logger.error(String.format("Error al cargar configuraci\u00f3n de watcher name=%s configPath=%s active=%s", wName, wConfigPath, wActive));
                }
                if (watcher != null) {
                    this.logger.debug("Procesando configuracion de watchers");
                    ERPClientApp.getApplication().newWatcher(configs);
                }
            } else {
                this.logger.debug("Archivo " + this.masterConfigFile + " NO existe");
            }
        }
        catch (InvalidDataException e) {
            this.logger.error(String.format("Error al cargar configuraci\u00f3n de watcher name=%s configPath=%s active=%s", wName, wConfigPath, wActive));
        }
        catch (NullPointerException e) {
            this.logger.error("Error verificar por la existencia del archivo " + this.masterConfigFile);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Problemas al cargar la configuraci\u00f3n del archivo", e);
        }
    }
}

