/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import s.f.erp.remote.client.MyDailyRollingFileAppender;

public class ERPClientLogDialog
extends JDialog {
    Logger logger = Logger.getLogger(ERPClientLogDialog.class);
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JRadioButton radBtnDebug;
    private JRadioButton radBtnLogDetallado;
    private JRadioButton radBtnNormalLog;

    public ERPClientLogDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.loadLog();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.radBtnLogDetallado = new JRadioButton();
        this.radBtnDebug = new JRadioButton();
        this.radBtnNormalLog = new JRadioButton();
        this.buttonGroup1.add(this.radBtnDebug);
        this.buttonGroup1.add(this.radBtnLogDetallado);
        this.buttonGroup1.add(this.radBtnNormalLog);
        this.setDefaultCloseOperation(2);
        this.setTitle("SF:ERP Log");
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setCursor(new Cursor(0));
        this.setMinimumSize(new Dimension(400, 200));
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setAutoscrolls(true);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton1.setText("Cerrar");
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ERPClientLogDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.radBtnLogDetallado.setText("Log Detallado");
        this.radBtnLogDetallado.setName("radBtnLogDetallado");
        this.radBtnLogDetallado.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ERPClientLogDialog.this.radBtnLogDetalladoMouseClicked(evt);
            }
        });
        this.radBtnDebug.setText("Debug");
        this.radBtnDebug.setName("radBtnDebug");
        this.radBtnDebug.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ERPClientLogDialog.this.radBtnDebugMouseClicked(evt);
            }
        });
        this.radBtnNormalLog.setSelected(true);
        this.radBtnNormalLog.setText("Log Normal");
        this.radBtnNormalLog.setName("radBtnNormalLog");
        this.radBtnNormalLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ERPClientLogDialog.this.radBtnNormalLogMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 476, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.radBtnNormalLog).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radBtnLogDetallado).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radBtnDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 86, Short.MAX_VALUE).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 240, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.radBtnLogDetallado).addComponent(this.radBtnDebug).addComponent(this.radBtnNormalLog)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void radBtnDebugMouseClicked(MouseEvent evt) {
        if (this.radBtnDebug.isSelected()) {
            String pattern = " %d  [%-5p]  (%c:%L) - %m%n";
            this.configureLogging(Level.DEBUG, pattern);
            ERPClientLogDialog eRPClientLogDialog = this;
            eRPClientLogDialog.logger.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    private void radBtnLogDetalladoMouseClicked(MouseEvent evt) {
        if (this.radBtnLogDetallado.isSelected()) {
            String pattern = "%d - %m%n";
            this.configureLogging(Level.DEBUG, pattern);
            ERPClientLogDialog eRPClientLogDialog = this;
            eRPClientLogDialog.logger.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    private void radBtnNormalLogMouseClicked(MouseEvent evt) {
        if (this.radBtnNormalLog.isSelected()) {
            String pattern = "%d - %m%n";
            this.configureLogging(Level.INFO, pattern);
            ERPClientLogDialog eRPClientLogDialog = this;
            eRPClientLogDialog.logger.getRootLogger().setLevel(Level.INFO);
        }
    }

    private void loadLog() {
        try {
            File logFile = new File("log/sf-erp-client.log");
            if (logFile.exists() && logFile.isFile()) {
                BufferedReader reader = new BufferedReader(new FileReader(logFile));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.jTextArea1.append(line + "\n");
                }
            } else {
                System.err.println("No se puede cargar el Log. No existe o no es un archivo regular " + logFile.getPath());
            }
        }
        catch (IOException e) {
            System.out.println("[ERROR] " + e.getMessage());
        }
    }

    private void configureLogging(Level level, String pattern) {
        Logger rootLogger = Logger.getRootLogger();
        if (pattern != null && !pattern.isEmpty()) {
            MyDailyRollingFileAppender appender = (MyDailyRollingFileAppender)rootLogger.getAppender("ERPClientLog");
            appender.setLayout(new PatternLayout(pattern));
        }
        if (!level.isGreaterOrEqual(rootLogger.getLevel())) {
            rootLogger.setLevel(level);
        }
    }

    public void appendToLogWindow(String msg) {
        this.jTextArea1.append(msg);
    }
}

