/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import com.solucionfactible.cfdi.ws.timbrado.xsd.CFDICertificacion;
import com.solucionfactible.cfdi.ws.timbrado.xsd.CFDIResultadoCertificacion;
import com.solucionfactible.ws.cfdi.RespuestaCreacion;
import com.solucionfactible.ws.cfdi.ResultadoCreacion;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.print.attribute.PrintServiceAttributeSet;
import org.apache.log4j.Logger;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientView;
import s.f.erp.remote.client.file.ERPFilePrinting;
import s.f.erp.remote.client.invoice.ERPInvoiceDownloader;
import s.f.erp.remote.client.invoice.ERPMailSender;
import s.f.util.Utils;

public class ERPClientController
implements ClientApp {
    private Map config = null;
    private SimpleDateFormat logDateFormat = null;
    private SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static ERPClientView view;
    private Logger logger = Logger.getLogger(ERPClientController.class);
    private PrinterJob printerJob = null;
    private PrintServiceAttributeSet printAttrs = null;

    public ERPClientController(ERPClientView view, Map config, boolean setGUI) {
        this.config = config;
        if (setGUI) {
            ERPClientController.view = view;
        }
    }

    public void addToMainLog(String message) {
        if (view != null) {
            view.addMainLog(this.format(this.formatDate(new Date()), message));
        }
    }

    public void setPrinterJob(PrinterJob pj) {
        this.printerJob = pj;
    }

    public void setPrintAttrs(PrintServiceAttributeSet printAttrs) {
        this.printAttrs = printAttrs;
    }

    public void addToMainTable(String file, String status, String detalles, Date date) {
        if (view != null) {
            view.addToMainTable(file, status, detalles, date);
        } else {
            this.logger.info(date.toString() + " " + file + " " + status);
        }
    }

    public synchronized void writeLog(String message) {
        this.logger.info(message);
    }

    private String formatDate(Date d) {
        if (this.logDateFormat == null) {
            this.logDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        }
        return this.logDateFormat.format(d);
    }

    @Override
    public void log(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void log(File file, String error) {
        this.logger.error(this.format(file.getName(), error));
    }

    @Override
    public void log(File file, RespuestaCreacion response) {
        boolean delete = false;
        boolean errors = false;
        String tMessage = "El archivo se ha procesado sin errores";
        String status = "OK";
        String message = "";
        String detailMessage = "";
        this.logger.debug("Leyendo respuesta recibida");
        if (response.getResultadosCreacion() != null) {
            this.logger.debug("Respuesta contiene informaci\u00f3n v\u00e1lida, se interpretara a continuaci\u00f3n");
            ResultadoCreacion[] creationReults = response.getResultadosCreacion();
            if (creationReults != null) {
                this.logger.debug("Respuesta con " + creationReults.length + " resultados");
            } else {
                this.logger.debug("Respuesta no regres\u00f3 resultados");
            }
            for (int i = 0; i < creationReults.length; ++i) {
                this.logger.debug(String.format("Desglozando resultado[%s]", i));
                ResultadoCreacion result = creationReults[i];
                if (result != null && new Integer(-1).equals(result.getEstatus())) {
                    this.logger.debug(String.format("Se recibi\u00f3 un error en el resultado [%s] el estatus es:%s", i, result.getEstatus()));
                    message = result.getMensaje();
                    BufferedReader bufferReader = new BufferedReader(new StringReader(message));
                    String _m = null;
                    try {
                        StringBuilder data = new StringBuilder();
                        data.append(file.getName());
                        while ((_m = bufferReader.readLine()) != null) {
                            data.append(" -- ").append(_m).append("\t");
                            this.addToMainLog(this.format(file.getName(), _m));
                        }
                        this.logger.info(data.toString());
                    }
                    catch (Exception e) {
                        this.logger.error("Error leyendo respuesta CREATION_RESULTS", e);
                    }
                    tMessage = "Ocurrieron errores al procesar el archivo";
                    status = "ERROR";
                    errors = true;
                    continue;
                }
                if (result != null && Integer.valueOf(1).equals(result.getEstatus())) {
                    boolean creationError;
                    this.logger.debug(String.format("Se recibi\u00f3 respuesta exitosa en el resultado [%s] el estatus es:%s", i, result.getEstatus()));
                    if (result.getOperacion().equals(new Integer(0))) {
                        if (result.getFolio() != null) {
                            detailMessage = "folio " + result.getFolio() + Utils.cleanString(result.getSerie());
                        }
                        if (creationError = this.handleCreationError(result.getMensaje())) {
                            this.logger.debug(String.format("Se encontraron errores del lado del servidor en el resultado[%s], operacion:Cancelaci\u00f3n (%s)  mensaje: %s", i, result.getOperacion(), result.getMensaje()));
                            if (CONFIG.connection != null) {
                                this.logger.debug(String.format("Actualizando la fecha de modificaci\u00f3n del archivo [%s] para su reenv\u00edo", file.getAbsolutePath()));
                                file.setLastModified(new Date().getTime());
                                this.logger.debug(String.format("Fecha de modificaci\u00f3n del archivo Archivo \"%s\" actualizada correctamente", file.getAbsolutePath()));
                                errors = true;
                            }
                            message = "Se encontr\u00f3 un error en el servidor, se reintentar\u00e1 enviar el archivo:" + file;
                        } else {
                            message = "El comprobante con " + detailMessage + " ha sido Cancelado";
                            delete = true;
                        }
                    }
                    if (Integer.valueOf(1).equals(result.getOperacion())) {
                        this.logger.debug(String.format("Se recibi\u00f3 respuesta exitosa en el resultado [%s] el estatus es:%s", i, result.getEstatus()));
                        if (result.getFolio() != null) {
                            detailMessage = "folio " + result.getFolio() + result.getSerie();
                        }
                        if (creationError = this.handleCreationError(result.getMensaje())) {
                            this.logger.debug(String.format("Se encontraron errores del lado del servidor en el resultado[%s], operacion:Creaci\u00f3n (%s)  mensaje: %s", i, result.getOperacion(), result.getMensaje()));
                            if (CONFIG.connection != null) {
                                this.logger.debug(String.format("Actualizando la fecha de modificaci\u00f3n del archivo [%s] para su reenv\u00edo", file.getAbsolutePath()));
                                file.setLastModified(new Date().getTime());
                                this.logger.debug(String.format("Fecha de modificaci\u00f3n del archivo Archivo \"%s\" actualizada correctamente", file.getAbsolutePath()));
                                errors = true;
                            }
                            message = "Se encontr\u00f3 un error en el servidor, se reintentar\u00e1 enviar el archivo:" + file;
                        } else {
                            message = "El comprobante ha sido creado con " + detailMessage;
                            delete = true;
                        }
                    }
                    if (!Integer.valueOf(2).equals(result.getOperacion())) continue;
                    this.logger.debug(String.format("Se recibi\u00f3 respuesta exitosa en el resultado [%s] el estatus es:%s", i, result.getEstatus()));
                    if (result.getFolio() != null) {
                        detailMessage = "folio " + result.getFolio() + result.getSerie();
                    }
                    message = "El comprobante con " + detailMessage + " ya existia y no fue modificado";
                    delete = true;
                    continue;
                }
                if (result != null) continue;
                this.logger.error("Problemas al leer la respuesta: ResultadoCreacion en la posici\u00f3n= " + i + " es nulo (NULL)");
            }
            this.logger.info(this.format(file.getName(), message));
            this.addToMainLog(this.format(file.getName(), message));
            if (delete && !errors) {
                this.logger.debug("El archivo se proceso sin errores, se borrar\u00e1 el archivo: \"" + file.getName() + "\" ");
                this.addToMainLogIfDebugEnabled("El archivo se proceso sin errores, se borrar\u00e1 el archivo: \"" + file.getName() + "\" ");
                file.delete();
                this.addToMainLogIfDebugEnabled("Se elimin\u00f3 el archivo: \"" + file.getName() + "\" ");
                this.logger.debug("Se elimin\u00f3 el archivo: \"" + file.getName() + "\" ");
            }
            this.addToMainTable(file.getName(), status, tMessage, new Date());
        }
        this.logger.debug("El proceso de env\u00edo e interpretaci\u00f3n del archivo ha terminado, leyendo dem\u00e1s instrucciones");
    }

    private boolean handleCreationError(String mensaje) {
        boolean creationError = false;
        if (mensaje != null && mensaje.matches("^\\[[0-9]{3}\\].*")) {
            try {
                Integer num = Integer.parseInt(mensaje.substring(1, 4));
                if (num >= 500 && num < 600) {
                    creationError = true;
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception", e);
            }
        } else if (mensaje == null) {
            creationError = true;
        }
        return creationError;
    }

    private void addToMainLogIfDebugEnabled(String message) {
        if (this.logger.isDebugEnabled()) {
            this.addToMainLog(message);
        }
    }

    public void log(File file, CFDICertificacion response) {
        this.logger.info(response.getStatus() + " " + file.getName() + " " + response.getMensaje());
        this.logger.info(this.format(file.getName(), response.getMensaje()));
        boolean errors = false;
        for (CFDIResultadoCertificacion results : response.getResultados()) {
            if (results != null && results.getStatus() == 200) continue;
            this.logger.error(results.getStatus() + " " + file.getName() + " " + results.getMensaje());
            this.logger.error(this.format(file.getName(), results.getMensaje()));
            this.logger.info(results.getMensaje());
            errors = true;
        }
        if (!errors) {
            this.logger.debug("El archivo se proceso sin errores, se borrar\u00e1 el archivo: \"" + file.getName() + "\" ");
            this.addToMainLogIfDebugEnabled("El archivo se proceso sin errores, se borrar\u00e1 el archivo: \"" + file.getName() + "\" ");
            file.delete();
            this.addToMainLogIfDebugEnabled("Se elimin\u00f3 el archivo: \"" + file.getName() + "\" ");
            this.logger.debug("Se elimin\u00f3 el archivo: \"" + file.getName() + "\" ");
        } else {
            this.addToMainLog("[ERROR] No se pudo completar la operaci\u00f3n, revise el log para m\u00e1s informaci\u00f3n");
        }
    }

    @Override
    public void monitor(Map config) {
        ERPClientApp.getApplication().monitor(config);
    }

    private String format(String fileName, String msg) {
        return String.format("%s -- %s", fileName, msg);
    }

    public synchronized void sendCompleted(File file, CFDICertificacion response) {
        this.logger.debug("Iniciando descarga de archivos");
        String pathToPDF = (String)this.config.get("PDF_DIRECTORY");
        File path = null;
        if (Utils.isParameterValid(pathToPDF)) {
            path = new File(pathToPDF);
            this.logger.debug(String.format("La ruta %s es un directorio v\u00e1lido", pathToPDF));
        } else {
            this.logger.debug(String.format("La ruta %s NO es un directorio v\u00e1lido", pathToPDF));
        }
        byte[] xmlResultado = null;
        if (response.getStatus() == 200) {
            for (CFDIResultadoCertificacion resultado : response.getResultados()) {
                if (resultado.getStatus() != 200) continue;
                xmlResultado = resultado.getCfdiTimbrado();
                String fName = file.getName();
                File writeFile = new File(path, fName);
                try {
                    FileOutputStream fos = new FileOutputStream(writeFile);
                    fos.write(xmlResultado);
                    fos.close();
                }
                catch (IOException e) {
                    this.logger.error(String.format("Hubo problemas almacenar el XML en %s. %s", writeFile.getAbsolutePath(), e.getLocalizedMessage()));
                    this.addToMainLog(String.format("[ERROR] Al almacenar el XML en %s. %s", writeFile.getAbsolutePath(), e.getLocalizedMessage()));
                }
            }
        }
    }

    public void printDownloadedFile(File pdfToPrint) {
        boolean descargaAutomatica = false;
        try {
            boolean bl = descargaAutomatica = this.config.containsKey("AUTOMATIC_PRINT") ? Boolean.valueOf(this.config.get("AUTOMATIC_PRINT").toString()) : false;
            if (descargaAutomatica) {
                this.logger.info("Se mandar\u00e1 a imprimir el archivo " + pdfToPrint);
                this.addToMainLog("Se mandar\u00e1 a imprimir el archivo " + pdfToPrint.getName());
                String printerName = this.config.containsKey("PRINTER_NAME") ? (String)this.config.get("PRINTER_NAME") : null;
                new ERPFilePrinting().printFile(pdfToPrint, printerName, this.printerJob);
            }
        }
        catch (Exception e) {
            this.logger.error("Error al imprimir", e);
        }
    }

    public boolean isEmailValid(String email) {
        if (Utils.isParameterValid(email)) {
            return email.matches("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");
        }
        return false;
    }

    public boolean isEmailAddressValid(String address) {
        if (Utils.isParameterValid(address)) {
            if (this.isEmailValid(address)) {
                return true;
            }
            try {
                InternetAddress ia = new InternetAddress(address, true);
                return true;
            }
            catch (AddressException e) {
                if (e.getLocalizedMessage() != null) {
                    this.logger.error("Email no v\u00e1lido: " + e.getLocalizedMessage());
                }
                this.logger.error("Email no v\u00e1lido: ", e);
            }
        }
        return false;
    }

    @Override
    public synchronized void sendCompleted(RespuestaCreacion response) {
        this.logger.debug("Leyendo informaci\u00f3n para descargar");
        ResultadoCreacion[] respCreacion = response.getResultadosCreacion();
        Long dienoDefault = (Long)this.config.get("PDF_DESIGN");
        String pathToPDF = (String)this.config.get("PDF_DIRECTORY");
        Map pdfSeries = (Map)this.config.get("PDF_SERIES");
        Map mailSeries = (Map)this.config.get("EMAIL_SERIES");
        String userName = (String)this.config.get("USERNAME");
        String password = (String)this.config.get("PASSWORD");
        File path = null;
        boolean descargaPDF = false;
        boolean descargaXML = false;
        boolean multipleDesignsPerSerie = false;
        if (this.config.containsKey("DOWNLOAD_PDF")) {
            descargaPDF = true;
        }
        if (this.config.containsKey("DOWNLOAD_XML")) {
            descargaXML = true;
        }
        if (Utils.isParameterValid(pathToPDF)) {
            path = new File(pathToPDF);
            this.logger.debug(String.format("La ruta %s es un directorio v\u00e1lido", pathToPDF));
        } else {
            this.logger.debug(String.format("La ruta %s NO es un directorio v\u00e1lido", pathToPDF));
        }
        for (int i = 0; i < respCreacion.length; ++i) {
            ResultadoCreacion r = respCreacion[i];
            Integer op = r.getOperacion();
            Integer st = r.getEstatus();
            Long folio = r.getFolio();
            String serie = r.getSerie();
            String to = Utils.cleanString(r.getEmail());
            if (path == null || !path.exists() || !path.isDirectory()) continue;
            Long ridDesignToDownload = null;
            List ridDisenos = null;
            if (pdfSeries == null && pdfSeries.isEmpty()) {
                this.logger.info("NO se encontr\u00f3 configuraci\u00f3n de serie - dise\u00f1o, intentando usar dise\u00f1o por default: " + ridDesignToDownload);
                ridDesignToDownload = dienoDefault;
            } else {
                this.logger.info("Se encontr\u00f3 configuraci\u00f3n de serie - dise\u00f1o");
                ridDisenos = (List)pdfSeries.get(serie);
                if (ridDisenos != null && !ridDisenos.isEmpty() && ridDisenos.size() > 1) {
                    multipleDesignsPerSerie = true;
                } else {
                    ridDesignToDownload = (Long)ridDisenos.get(0);
                }
            }
            if (st == 1 && (op == 0 || op == 1)) {
                if (pathToPDF != null) {
                    if (descargaPDF && ridDesignToDownload != null && !multipleDesignsPerSerie) {
                        this.addToMainLog(String.format("Iniciando descarga de PDF para el comprobante serie=[%s] folio=[%d] ", serie, folio));
                        this.logger.info(String.format("Iniciando descarga de PDF para el comprobante serie=[%s] folio=[%d] ", serie, folio));
                        new ERPInvoiceDownloader(this, userName, password, ridDesignToDownload, folio, serie, path).start();
                    } else if (descargaPDF && multipleDesignsPerSerie) {
                        this.logger.info(String.format("Iniciando descarga de multiples PDF para serie=[%s] folio=[%d] ", serie, folio));
                        for (int j = 0; j < ridDisenos.size(); ++j) {
                            Long descargaDiseno = (Long)ridDisenos.get(j);
                            this.logger.info(String.format("Descargando serie=[%s] folio=[%d] dise\u00f1o=[%s]", serie, folio, descargaDiseno));
                            new ERPInvoiceDownloader(this, userName, password, descargaDiseno, folio, serie, path).start();
                        }
                    } else {
                        this.logger.error("Error al descargar PDF  no se encontro configuraci\u00f3n [serie-dise\u00f1o] y no se encontr\u00f3 un dise\u00f1o por default");
                    }
                    if (descargaXML) {
                        this.logger.info(String.format("Iniciando descarga de XML serie=[%s] folio=[%d] ", serie, folio));
                        this.addToMainLog(String.format("Iniciando descarga de XML para el comprobante serie=[%s] folio=[%d] ", serie, folio));
                        new ERPInvoiceDownloader(this, userName, password, folio, serie, path).start();
                        this.addToMainLog("Descarga finalizada");
                    }
                } else {
                    this.logger.error(String.format("Hubo problemas al descargar el PDF directorio de descarga es inv\u00e1lido \"s%\"", path));
                    this.addToMainLog(String.format("[ERROR] Al descargar el PDFdirectorio de descarga es inv\u00e1lido \"s%\"", path));
                }
            }
            if (Utils.isParameterValid(to) && this.config.containsKey("EMAIL_DESIGN") && Boolean.valueOf(this.config.get("SEND_ALLOWED").toString()).booleanValue()) {
                Long pdfDesign;
                this.logger.debug("Env\u00edo de emails activado");
                this.logger.info("Iniciando proceso de envio de email");
                Long disenoMail = (Long)this.config.get("EMAIL_DESIGN");
                Long disenoPDF = pdfDesign = (Long)this.config.get("EMAIL_PDF_DESIGN");
                Boolean zip = (Boolean)this.config.get("EMAIL_ZIP_ATTACHMENTS");
                Boolean xml = (Boolean)this.config.get("EMAIL_SEND_XML");
                String subject = (String)this.config.get("EMAIL_SUBJECT");
                String customMessage = (String)this.config.get("EMAIL_CUSTOM_MESSAGE");
                if (mailSeries != null && mailSeries.containsKey(serie)) {
                    disenoPDF = (Long)mailSeries.get(serie);
                }
                String[] _to = to.split("[,;]");
                to = "";
                for (int j = 0; j < _to.length; ++j) {
                    String t = _to[j].trim();
                    if (this.isEmailAddressValid(t)) {
                        to = to + t;
                        if (j >= _to.length - 1) continue;
                        to = to + ",";
                        continue;
                    }
                    this.logger.error(String.format("La direcci\u00f3n \"%s\" no es un e-mail v\u00e1lido.", t));
                    this.addToMainLogIfDebugEnabled(String.format("[ERROR] La direcci\u00f3n \"%s\" no es un e-mail v\u00e1lido.", t));
                }
                this.logger.debug("Direcion(es) de correo(s): " + to);
                if (Utils.isParameterValid(to) && serie != null) {
                    this.logger.info("Enviando correo");
                    ERPMailSender sender = new ERPMailSender(this, userName, password, folio, serie, zip, xml, subject, customMessage, to, disenoPDF, disenoMail);
                    sender.start();
                    continue;
                }
                this.logger.error(String.format("No se env\u00eda el CFD %d%s no se encontraron direcciones de correo electr\u00f3nico v\u00e1lidas.", folio, serie, to));
                this.addToMainLog(String.format("[ERROR] No se env\u00eda el CFD %d%s no se encontraron direcciones de correo electr\u00f3nico v\u00e1lidas.", folio, serie, to));
                continue;
            }
            this.logger.debug("env\u00edo de emails desactivado");
        }
    }
}

