/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import com.solucionfactible.ws.cfdi.RespuestaCreacion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.hsqldb.Server;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientApp;
import s.f.erp.remote.client.ERPClientController;
import s.f.util.InvalidDataException;
import s.f.util.Utils;
import s.f.util.xml.XMLUtils;

public class ERPClientAppLauncher
extends Thread
implements ClientApp {
    private Map config = null;
    static SimpleDateFormat logDateFormat = null;
    static SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyy-MM-dd");
    ERPClientController clientController = null;
    static String[] globalDBArgs = null;
    static final Logger logger = Logger.getLogger(ERPClientAppLauncher.class);
    protected static final String LOG_PROPERTIES_FILE = "log4j";
    private static boolean CONSOLE_MODE = false;

    private static void checkDir(String path) {
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!f.canWrite()) {
                    logger.warn(String.format("No se tienen los permisos necesarios para escribir en el directorio %s.", path));
                }
                if (f.canRead()) {
                    String[] archivos = f.list();
                    logger.info(String.format("El directorio %s contiene actualmente %d archivos y/o directorios", path, archivos.length));
                }
            } else {
                logger.error(String.format("La ruta %s no se hace referencia a un directorio.", path));
            }
        } else {
            logger.error(String.format("El directorio %s no existe.", path));
        }
    }

    public Map getConfig() {
        return this.config;
    }

    private static void log4jVervoseHandler(String msg, Throwable t) {
        if (CONSOLE_MODE) {
            if (t == null) {
                logger.error(msg);
            } else {
                logger.error(msg, t);
            }
        } else {
            logger.debug(msg);
        }
    }

    public static Map loadConfig(Map<String, String> options) throws InvalidDataException {
        HashMap data;
        block71: {
            data = new HashMap();
            try {
                String name;
                HashMap<String, Object> cfg = new HashMap<String, Object>();
                String pathToFile = Utils.cleanString(options.get("CONFIG_FILE")).trim();
                if (!Utils.isParameterValid(pathToFile)) {
                    pathToFile = "config.xml";
                }
                if (Utils.isParameterValid(name = Utils.cleanString(options.get("NAME")))) {
                    cfg.put("NAME", name);
                }
                File cFile = new File(pathToFile);
                cfg.putAll(options);
                if (cFile.exists() && cFile.isFile()) {
                    List designs;
                    Document doc = XMLUtils.loadXML(new FileInputStream(cFile));
                    Element conf = doc.getRootElement();
                    Element login = conf.getChild("login");
                    Element watch = conf.getChild("watch");
                    Element log = conf.getChild("log");
                    Element download = conf.getChild("download");
                    Element pdfDesigns = conf.getChild("pdfDesigns");
                    Element emailSend = conf.getChild("send");
                    Element emailDesigns = conf.getChild("emailDesigns");
                    Element dbArgs = conf.getChild("dbArgs");
                    Element behavior = conf.getChild("behavior");
                    Element printConfig = conf.getChild("printConfig");
                    Element serverConfig = conf.getChild("server");
                    if (login != null) {
                        cfg.put("USERNAME", Utils.cleanString(login.getAttributeValue("user")));
                        cfg.put("PASSWORD", Utils.cleanString(login.getAttributeValue("password")));
                    } else {
                        ERPClientAppLauncher.log4jVervoseHandler("No se encuentran los datos de autenticaci\u00f3n en el archivo de configuraci\u00f3n.", null);
                    }
                    String watchDir = ".";
                    Integer delayToSend = null;
                    Integer interval = new Integer(5);
                    if (watch != null) {
                        watchDir = Utils.cleanString(watch.getAttributeValue("directory"));
                        cfg.put("FILE_EXTENSION", Utils.cleanString(watch.getAttributeValue("fileExtension")));
                        try {
                            interval = new Integer(watch.getAttributeValue("interval"));
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("No se pudo cargar el valor interval", e);
                        }
                        try {
                            logger.info("Loading delay to send");
                            delayToSend = new Integer(Utils.cleanString(watch.getAttributeValue("delayToSend")));
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("No se pudo cargar el valor delayToSend", e);
                        }
                    } else {
                        logger.warn("No se encuentran los datos del directorio de monitoreo en el archivo de configuraci\u00f3n.");
                    }
                    cfg.put("DIRECTORY", watchDir);
                    cfg.put("INTERVAL", interval);
                    logger.info(String.format("Usando directorio \"%s\" para monitoreo de archivos cada %d segundos.", watchDir, interval));
                    ERPClientAppLauncher.checkDir(watchDir);
                    if (delayToSend != null) {
                        cfg.put("DELAY_TO_SEND", delayToSend);
                        logger.info(String.format("Se har\u00e1 una espera de %d segundos para enviar el archivo luego de detectar cambios.", delayToSend));
                    }
                    String logDir = "";
                    if (log != null) {
                        logDir = Utils.cleanString(log.getAttributeValue("directory"));
                        try {
                            logDateFormat = new SimpleDateFormat(log.getAttributeValue("dateFormat"));
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("Hubo problemas al obtener el valor del atributo \"dateFormat\"", e);
                        }
                        try {
                            fileNameFormat = new SimpleDateFormat(log.getAttributeValue("fileNameFormat"));
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("Hubo problemas al obtener el valor del atributo \"fileNameFormat\"", e);
                        }
                    } else {
                        ERPClientAppLauncher.log4jVervoseHandler("No se encuentran los datos del directorio de logging en el archivo de configuraci\u00f3n.", null);
                    }
                    cfg.put("LOG_DIRECTORY", logDir);
                    logger.info(String.format("Usando directorio \"%s\" para almacenar achivos de log.", logDir));
                    ERPClientAppLauncher.checkDir(logDir);
                    if (download != null) {
                        List designs2;
                        String downloadDir = Utils.cleanString(download.getAttributeValue("directory")).trim();
                        String disenoDefault = Utils.cleanString(download.getAttributeValue("design")).trim();
                        try {
                            Boolean downloadAllowed = Boolean.valueOf(Utils.cleanString(download.getAttributeValue("allowed")));
                            cfg.put("PDF_DIRECTORY", downloadDir);
                            cfg.put("DOWNLOAD_ALLOWED", downloadAllowed);
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("Error al cargar el identificador de dise\u00f3 para PDF. Esta caracter\u00edstica no estar\u00e1 activada.", e);
                        }
                        String downloadTypes = null;
                        try {
                            downloadTypes = download.getAttribute("types").toString();
                        }
                        catch (Exception e) {
                            ERPClientAppLauncher.log4jVervoseHandler("No hay un tipo de archivo definido para descargar, opciones:PDF o XML", null);
                        }
                        if (downloadTypes != null && downloadTypes.toUpperCase().contains("XML")) {
                            cfg.put("DOWNLOAD_XML", "true");
                            logger.info("Caracter\u00edstica de descarga de XML's activada.");
                            logger.info("Las descargas se almacenan en " + downloadDir);
                        }
                        if (downloadTypes != null && downloadTypes.toUpperCase().contains("PDF")) {
                            if (disenoDefault != null && disenoDefault.length() > 0) {
                                cfg.put("PDF_DESIGN", new Long(disenoDefault));
                            }
                            logger.info("Caracter\u00edstica de descarga de PDF's activada. ");
                            logger.info("Las descargas se almacenar\u00e1n en " + downloadDir);
                            logger.info("El dise\u00f1o predeterminado es " + disenoDefault);
                            cfg.put("DOWNLOAD_PDF", "true");
                            List series = download.getChildren("serie");
                            if (series != null) {
                                HashMap seriesConfig = new HashMap();
                                for (Element sData : series) {
                                    ArrayList<Long> disenos = new ArrayList<Long>();
                                    String sName = Utils.cleanString(sData.getAttributeValue("name"));
                                    try {
                                        String d = sData.getAttributeValue("design");
                                        try {
                                            Long l = new Long(sData.getAttributeValue("design"));
                                            disenos.add(l);
                                            logger.info(String.format("Se asocia el dise\u00f1o \"%d\" a la serie \"%s\".", l, sName));
                                        }
                                        catch (Exception e) {
                                            logger.info("No se encontr\u00f3 dise\u00f1o valido para la serie" + sName);
                                            logger.debug("No se encontr\u00f3 atributo design para la serie" + sName);
                                        }
                                        List designsList = sData.getChildren("design");
                                        if (!designsList.isEmpty()) {
                                            for (Element sDesign : designsList) {
                                                String designId = sDesign.getAttributeValue("id");
                                                try {
                                                    Long rid = new Long(designId);
                                                    disenos.add(rid);
                                                    logger.info(String.format("Se descargaran Comprobantes en PDF de la serie \"%s\" con dise\u00f1o:\"%d\"", sName, rid));
                                                }
                                                catch (Exception e) {
                                                    logger.info("No se encontr\u00f3 dise\u00f1o valido para la serie" + sName);
                                                    logger.debug("No se encontr\u00f3 atributo design para la serie" + sName);
                                                }
                                            }
                                            seriesConfig.put(sName, disenos);
                                            continue;
                                        }
                                        seriesConfig.put(sName, disenos);
                                    }
                                    catch (Exception e) {
                                        ERPClientAppLauncher.log4jVervoseHandler(String.format("Error al cargar la configuraci\u00f3n de dise\u00f1o para la serie \"%s\" ", sName), e);
                                    }
                                }
                                cfg.put("PDF_SERIES", seriesConfig);
                            } else {
                                logger.debug("No se encontr\u00f3 configuraci\u00f3n serie - dise\u00f1o");
                            }
                        }
                        if (pdfDesigns != null && (designs2 = pdfDesigns.getChildren("design")) != null) {
                            HashMap<Long, String> designsConfig = new HashMap<Long, String>();
                            for (Element dData : designs2) {
                                String dName = Utils.cleanString(dData.getAttributeValue("name"));
                                try {
                                    Long desigId = new Long(dData.getAttributeValue("id"));
                                    designsConfig.put(desigId, dName);
                                }
                                catch (Exception e) {
                                    ERPClientAppLauncher.log4jVervoseHandler("Error al cargar la configuraci\u00f3n de dise\u00f1os para PDFs ", e);
                                }
                            }
                            cfg.put("PDF_DESIGNS", designsConfig);
                        }
                    }
                    if (emailSend != null) {
                        String subjectStr = Utils.cleanString(emailSend.getAttributeValue("subject"));
                        String customMessageStr = Utils.cleanString(emailSend.getAttributeValue("customMessage"));
                        Boolean sendAllowed = Boolean.valueOf(Utils.cleanString(emailSend.getAttributeValue("allowed")));
                        cfg.put("SEND_ALLOWED", sendAllowed);
                        if (!Utils.isParameterValid(subjectStr)) {
                            subjectStr = "Comprobantes Fiscales Digitales";
                        }
                        if (!Utils.isParameterValid(customMessageStr)) {
                            customMessageStr = "";
                        }
                        Long disenoEmail = null;
                        Long disenoPDF = null;
                        Boolean zip = Boolean.valueOf(emailSend.getAttributeValue("zipAttachments"));
                        Boolean xml = Boolean.valueOf(emailSend.getAttributeValue("sendXML"));
                        String _tmp = emailSend.getAttributeValue("emailDesign");
                        try {
                            disenoEmail = new Long(Utils.cleanString(_tmp));
                        }
                        catch (NumberFormatException e) {
                            ERPClientAppLauncher.log4jVervoseHandler(String.format("No se puede cargar el dise\u00f1o de e-mail \"%s\" ", _tmp), null);
                            ERPClientAppLauncher.log4jVervoseHandler("Caracter\u00edstica de env\u00edo de emails desactivada", null);
                        }
                        _tmp = emailSend.getAttributeValue("PDFDesign");
                        try {
                            disenoPDF = new Long(Utils.cleanString(_tmp));
                        }
                        catch (NumberFormatException e) {
                            ERPClientAppLauncher.log4jVervoseHandler(String.format("No se puede cargar el dise\u00f1o de PDF para env\u00edo por e-mail \"%s\".", _tmp), null);
                            ERPClientAppLauncher.log4jVervoseHandler("Caracter\u00edstica de env\u00edo de emails desactivada", null);
                        }
                        if (disenoEmail != null && disenoPDF != null) {
                            cfg.put("EMAIL_DESIGN", disenoEmail);
                            cfg.put("EMAIL_PDF_DESIGN", disenoPDF);
                            cfg.put("EMAIL_ZIP_ATTACHMENTS", zip);
                            cfg.put("EMAIL_SEND_XML", xml);
                            cfg.put("EMAIL_SUBJECT", subjectStr);
                            cfg.put("EMAIL_CUSTOM_MESSAGE", customMessageStr);
                            logger.info("Caracter\u00edstica de env\u00ed0 de e-mail activada. ");
                            logger.info("      Asunto de e-mail: " + subjectStr);
                            logger.info("      Cuerpo de e-mail: " + customMessageStr);
                            logger.info("      Dise\u00f1o de e-mail: " + disenoEmail);
                            logger.info("      Dise\u00f1o de PDF predeterminado por e-mail: " + disenoPDF);
                            logger.info("      Adjuntar CFD en formato XML: " + (xml != false ? "S\u00ed" : "No"));
                            logger.info("      Comprimir adjuntos en ZIP: " + (zip != false ? "S\u00ed" : "No"));
                            List series = emailSend.getChildren("serie");
                            if (series != null) {
                                HashMap<String, Long> seriesConfig = new HashMap<String, Long>();
                                for (Element sData : series) {
                                    String sName = Utils.cleanString(sData.getAttributeValue("name"));
                                    try {
                                        String d = sData.getAttributeValue("design");
                                        Long l = new Long(sData.getAttributeValue("design"));
                                        seriesConfig.put(sName, l);
                                        logger.info(String.format("Se asocia el dise\u00f1o %d a la serie \"%s\" para el env\u00edo de e-mail.", l, sName));
                                    }
                                    catch (Exception e) {
                                        ERPClientAppLauncher.log4jVervoseHandler(String.format("Error al cargar la configuraci\u00f3n de dise\u00f1o para la serie \"%s\" para el env\u00ed0 de e-mail. %s", sName), e);
                                    }
                                }
                                cfg.put("EMAIL_SERIES", seriesConfig);
                            }
                        } else {
                            ERPClientAppLauncher.log4jVervoseHandler("La caracter\u00edstica de env\u00ed0 de e-mail no ser\u00e1 activada", null);
                        }
                    }
                    if (emailDesigns != null && (designs = emailDesigns.getChildren("design")) != null) {
                        HashMap<Long, String> designsConfig = new HashMap<Long, String>();
                        for (Element dData : designs) {
                            String dName = Utils.cleanString(dData.getAttributeValue("name"));
                            try {
                                Long dId = new Long(dData.getAttributeValue("id"));
                                designsConfig.put(dId, dName);
                            }
                            catch (Exception e) {
                                ERPClientAppLauncher.log4jVervoseHandler("Error al cargar la configuraci\u00f3n de dise\u00f1os para emails", e);
                            }
                        }
                        cfg.put("EMAIL_DESIGNS", designsConfig);
                    }
                    if (dbArgs != null) {
                        try {
                            Integer dbPort = new Integer(Utils.cleanString(dbArgs.getAttributeValue("port")));
                            CONFIG.dbPort = dbPort;
                            cfg.put("DB_PORT", dbPort);
                        }
                        catch (Exception e) {
                            logger.info("No se especifica un puerto para la base de datos en el archivo de configuraci\u00f3n si no se especifica uno mas adelante se usar\u00e1 9001");
                        }
                    }
                    if (behavior != null) {
                        String action = behavior.getAttributeValue("action");
                        if (behavior.getAttribute("environment") != null) {
                            String env = Utils.cleanString(behavior.getAttributeValue("environment"));
                            cfg.put("ENVIRONMENT", env);
                        }
                        cfg.put("ACTION", action);
                    }
                    if (printConfig != null) {
                        try {
                            String printerName = printConfig.getAttributeValue("printerName");
                            String automaticPrintingEnabled = printConfig.getAttributeValue("automaticPrintingEnabled");
                            cfg.put("PRINTER_NAME", printerName);
                            cfg.put("AUTOMATIC_PRINT", automaticPrintingEnabled);
                        }
                        catch (Exception e) {
                            logger.debug("No se pudo cargar configuraci\u00f3n de impresi\u00f3n, \n no existe o no esta en el formato correcto");
                        }
                    } else {
                        logger.warn("No se encontr\u00f3 configuraci\u00f3n de impresi\u00f3n,\ncaracter\u00edstica de impresi\u00f3n autom\u00e1tica no ser\u00e1 activada");
                    }
                    if (serverConfig != null) {
                        cfg.put("SERVER", serverConfig.getAttribute("serverName"));
                    }
                    data.putAll(cfg);
                    break block71;
                }
                if (CONSOLE_MODE) {
                    logger.fatal("No se puede cargar la configuraci\u00f3n. No existe o no es un archivo regular: " + cFile.getPath());
                    logger.info("EJECUTE COMANDO: --generate-config para obtener un archivo de configuraci\u00f3n limpio");
                    logger.info("LA APLICACI\u00d3N TERMINAR\u00c1 AHORA");
                    System.exit(0);
                }
                logger.info("No se puede cargar la configuraci\u00f3n. No existe o no es un archivo regular ");
            }
            catch (Exception ex) {
                ERPClientAppLauncher.log4jVervoseHandler("Hubo problemas cargando la configuraci\u00f3n", ex);
            }
        }
        return data;
    }

    public void run(Map<String, String> options, String[] args) throws InvalidDataException {
        this.config = ERPClientAppLauncher.loadConfig(options);
        if (CONSOLE_MODE) {
            Server.main(CONFIG.getDBArgsWithPort());
            this.clientController = new ERPClientController(null, this.config, false);
            System.out.println("");
            System.out.println("Launching ERP Client application in Console Mode");
            System.out.println("");
            this.start();
        } else {
            ERPClientApp.setParent(this);
            ERPClientApp.launch(ERPClientApp.class, args);
            this.clientController = ERPClientApp.getApplication().clientController;
        }
    }

    @Override
    public void run() {
        this.monitor(this.config);
    }

    private static void configureLogging(Level level, String pattern) {
        Logger rootLogger = Logger.getRootLogger();
        if (pattern != null && !pattern.isEmpty()) {
            ConsoleAppender appender = (ConsoleAppender)rootLogger.getAppender("A1");
            appender.setLayout(new PatternLayout(pattern));
            rootLogger.addAppender(appender);
            rootLogger.setLevel(level);
        }
    }

    public static void main(String[] args) {
        ERPClientAppLauncher.initializeLogger();
        HashMap<String, String> options = new HashMap<String, String>();
        ArrayList<String> dbArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().startsWith("--config-file") || args[i].toLowerCase().startsWith("-cf")) {
                try {
                    File f = new File(args[i + 1]);
                    if (f.exists() && f.isFile()) {
                        options.put("CONFIG_FILE", args[i + 1]);
                        continue;
                    }
                    logger.debug("Archivo de configuraci\u00f3n ");
                }
                catch (Exception e) {
                    logger.error("Archivo de configuraci\u00f3n invalido, cerrando programa");
                    System.exit(0);
                }
                continue;
            }
            if (args[i].toLowerCase().equals("--port") || args[i].toLowerCase().equals("-p")) {
                try {
                    CONFIG.dbPort = Integer.parseInt(args[i + 1]);
                    dbArgs.add(args[i]);
                    dbArgs.add(args[i + 1]);
                }
                catch (Exception e) {
                    logger.error("Unable to parse port number:", e);
                }
                continue;
            }
            if (args[i].toLowerCase().equals("--console") || args[i].toLowerCase().equals("-c")) {
                options.put("CONSOLE_MODE", "true");
                CONSOLE_MODE = true;
                continue;
            }
            if (args[i].toLowerCase().equals("--help") || args[i].toLowerCase().equals("-h")) {
                ERPClientAppLauncher.printUsage();
                System.exit(0);
                continue;
            }
            if (args[i].toLowerCase().equals("--clean")) {
                ERPClientAppLauncher.removeAllConfigFiles();
                System.exit(0);
                continue;
            }
            if (args[i].toLowerCase().equals("--create-config") || args[i].toLowerCase().equals("-cc") || args[i].toLowerCase().equals("--generate-config")) {
                String path = null;
                try {
                    path = args[i + 1];
                }
                catch (Exception e) {
                    logger.debug("Exception", e);
                }
                ERPClientAppLauncher.generateConfig(path);
                System.exit(0);
                continue;
            }
            if (args[i].toLowerCase().equals("--debug") || args[i].toLowerCase().equals("-d")) {
                String pattern = " %d  [%-5p]  (%c:%L) - %m%n";
                ERPClientAppLauncher.configureLogging(Level.DEBUG, pattern);
                logger.getRootLogger().setLevel(Level.DEBUG);
                logger.info("Nivel de log: DEBUG activado");
                continue;
            }
            if (args.length <= 0) continue;
            ERPClientAppLauncher.printUsage();
            System.exit(0);
        }
        if (!options.containsKey("CONSOLE_MODE") || "false".equals(options.get("CONSOLE_MODE"))) {
            // empty if block
        }
        String[] _dbArgs = new String[dbArgs.size()];
        _dbArgs = dbArgs.toArray(_dbArgs);
        globalDBArgs = _dbArgs;
        try {
            new ERPClientAppLauncher().run(options, args);
        }
        catch (InvalidDataException e) {
            System.err.println(e.getSource());
            logger.error("Error al lanzar la aplicaci\u00f3n", e);
        }
    }

    public static void generateConfig(String path) {
        Document doc = ERPClientAppLauncher.generateXML();
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        if (path != null) {
            File f = new File(path);
            if (f.exists() && f.isDirectory()) {
                if (doc != null) {
                    ERPClientAppLauncher.writeConfig(doc, path);
                    logger.info("Se creo un archivo de configuraci\u00f3n limpio en: " + path + "/config.xml");
                } else {
                    logger.error("Error al generar el archivo de configuraci\u00f3n");
                }
            } else {
                logger.error("La ruta para generar el archivo no es valida");
            }
        } else {
            ERPClientAppLauncher.writeConfig(doc, ".");
            logger.info("Se creo un archivo de configuraci\u00f3n limpio en: " + path + "/config.xml");
        }
    }

    public static Document generateXML() {
        Element root = new Element("config");
        Document doc = new Document(root);
        Element login = new Element("login");
        root.addContent(new Comment("Este es un archivo de configuraci\u00f3n base, debe ser configurado  acorde a la informaci\u00f3n de su implementaci\u00f3n en Soluci\u00f3n Factible"));
        login.setAttribute("user", "");
        login.setAttribute("password", "");
        root.addContent(login);
        Element watch = new Element("watch");
        root.addContent(new Comment("directorio que el sistema escaneara por cambios;\nintervalo de tiempo en que el sistema comprobara si hay cambios/nuevos archivos;\ndelayToSend tiempo que se tardar\u00e1 en mandar un archivo despues de encontrarlo;\nfileExtension extensi\u00f3n del archivo que se enviar\u00e1"));
        watch.setAttribute("directory", "");
        watch.setAttribute("interval", "");
        watch.setAttribute("delayToSend", "");
        watch.setAttribute("fileExtension", "");
        root.addContent(watch);
        Element log = new Element("log");
        log.setAttribute("directory", "");
        log.setAttribute("dateFormat", "yyyy-MM-dd HH:mm:ss");
        log.setAttribute("fileNameFormat", "yyyy-MM-dd");
        root.addContent(log);
        Element download = new Element("download");
        root.addContent(new Comment("allowed:     si desea descargar=true, si no=false;\ndirectory:   ruta del directorio donde se almacenaran los archivos descargados;\ntypes:       tipo de archivos que se va a descargar XML \u00f3 PDF o ambos XML,PDF;\ndesign:      id del dise\u00f1o que se va a descargar"));
        download.setAttribute("allowed", "true");
        download.setAttribute("directory", "");
        Attribute types = new Attribute("types", "");
        download.setAttribute("design", "");
        download.setAttribute(types);
        root.addContent(new Comment("A continuaci\u00f3n se muestran series de ejemplo"));
        Element serie = new Element("serie");
        serie.setAttribute("name", "S");
        serie.setAttribute("design", "123");
        download.addContent(serie);
        root.addContent(download);
        Element send = new Element("send");
        send.setAttribute("allowed", "trueORfalse");
        send.setAttribute("zipAttachments", "trueORfalse");
        send.setAttribute("sendXML", "trueORfalse");
        send.setAttribute("customMessage", "");
        send.setAttribute("subject", "");
        send.setAttribute("emailDesign", "");
        send.setAttribute("PDFDesign", "");
        Element serie2 = new Element("serie");
        serie2.setAttribute("name", "nombreDise\u00f1o");
        serie2.setAttribute("design", "idDise\u00f1o");
        send.addContent(serie2);
        root.addContent(send);
        Element pdfDesigns = new Element("pdfDesigns");
        Element diseno = new Element("design");
        diseno.setAttribute("name", "nombreDise\u00f1o");
        diseno.setAttribute("id", "idDise\u00f1o");
        pdfDesigns.addContent(diseno);
        Element xmlEmailDesigns = new Element("emailDesigns");
        Element diseno2 = new Element("design");
        diseno2.setAttribute("name", "");
        diseno2.setAttribute("id", "");
        xmlEmailDesigns.addContent(diseno2);
        Element dbArgs = new Element("dbArgs");
        dbArgs.setAttribute("port", "9001");
        root.addContent(dbArgs);
        Element behavior = new Element("behavior");
        behavior.setAttribute("action", "timbrarORgenerar");
        behavior.setAttribute("environment", "testORprod");
        root.addContent(behavior);
        Element printConfig = new Element("printConfig");
        printConfig.setAttribute("printerName", "");
        printConfig.setAttribute("automaticPrintingEnabled", "false");
        root.addContent(printConfig);
        return doc;
    }

    private static boolean writeConfig(Document doc, String path) {
        boolean done = false;
        XMLOutputter xmlout = new XMLOutputter(Format.getPrettyFormat());
        String fileName = "config.xml";
        path = path + System.getProperty("file.separator") + fileName;
        try {
            FileOutputStream fos = new FileOutputStream(path);
            xmlout.output(doc, (OutputStream)fos);
            fos.flush();
            fos.close();
            done = true;
        }
        catch (Exception e) {
            logger.error("Problemas al escribir la configuraci\u00f3n", e);
        }
        return done;
    }

    public static void initializeLogger() {
        PropertyResourceBundle p = (PropertyResourceBundle)PropertyResourceBundle.getBundle(LOG_PROPERTIES_FILE);
        Properties log4jProperties = new Properties();
        Enumeration<String> keys = p.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            log4jProperties.setProperty(key, p.getString(key));
        }
        PropertyConfigurator.configure(log4jProperties);
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.print("UnsupportedLookAndFeelException" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException" + e.getMessage());
        }
        catch (InstantiationException e) {
            System.err.print("InstantiationException" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.err.print("IllegalAccessException" + e.getMessage());
        }
    }

    private static void removeAllConfigFiles() {
        File[] files = new File(".").listFiles();
        ArrayList<String> dFiles = new ArrayList<String>();
        dFiles.add("test.tmp");
        dFiles.add("test.log");
        dFiles.add("test.properties");
        dFiles.add("test.script");
        dFiles.add("test.lck");
        logger.info("Eliminando todos los archivos de configuraci\u00f3n (no incluye config.xml)");
        for (File fi : files) {
            if (!fi.exists() || !dFiles.contains(fi.getName())) continue;
            try {
                logger.info("Eliminando " + fi.getName());
                fi.delete();
            }
            catch (SecurityException e) {
                logger.error(String.format("No se pudo borrar el archivo %s", fi.getName()), e);
            }
        }
    }

    private static void printUsage() {
        PropertiesConfiguration b = null;
        String props = "s/f/erp/remote/client/resources/ERPClientApp.properties";
        System.out.println("");
        System.out.println("= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = \n");
        try {
            b = new PropertiesConfiguration(props);
            System.out.println(String.format("%s Versi\u00f3n %s", b.getString("Application.title"), b.getString("Application.version")));
        }
        catch (Exception e) {
            logger.error(String.format("Error al buscar el recurso %s", props), e);
        }
        System.out.println("Pa\u0155ametros opcionales");
        System.out.println("\t-cf, --config-file <ruta>     Usar archivo de configuraci\u00f3n en la ruta especificada");
        System.out.println("\t-c, --console                 Ejecutar en modo consola");
        System.out.println("\t-h, --help                    Muestra la informaci\u00f3n sobre los par\u00e1metros opcionales disponibles ");
        System.out.println("\t-p, --port <puerto>           Especificar el puerto en el que se ejecutar\u00e1 el servidor de base de datos");
        System.out.println("\t-c, --clean                   Elimina todos los archivos de configuraci\u00f3n de base de datos");
        System.out.println("\t-cc, --create-config          Crea un archivo de configuraci\u00f3n \"config.xml\" con todos los\n \t                                      valores requeridos para configurar el sistema manualmente si se\n \t                                      da una ruta el archivo se crea en ese lugar, si no, se crea\n\t                                      en el directorio de trabajo");
        System.out.println("\t-d, --debug                   Activa el nivel DEBUG de logging de la aplicaci\u00f3n\n");
        System.out.println("");
        System.out.println("= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = \n");
    }

    private synchronized void writeLog(String message) {
        logger.debug(message);
        this.clientController.writeLog(message);
    }

    private String format(String fileName, String msg) {
        return String.format("%s -- %s", fileName, msg);
    }

    @Override
    public void log(String msg) {
        logger.debug(msg);
        this.clientController.writeLog(msg);
    }

    @Override
    public void log(File file, String error) {
        logger.debug(this.format(file.getName(), error));
        this.clientController.writeLog(this.format(file.getName(), error));
    }

    @Override
    public void log(File file, RespuestaCreacion response) {
        logger.debug(response);
        this.clientController.log(file, response);
    }

    @Override
    public void monitor(Map config) {
        ERPClientApp.getApplication().monitor(config);
    }

    @Override
    public synchronized void sendCompleted(RespuestaCreacion response) {
        this.clientController.sendCompleted(response);
    }
}

