/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import com.solucionfactible.cfdi.ws.timbrado.xsd.CFDICertificacion;
import com.solucionfactible.cfdi.ws.timbrado.xsd.CFDIResultadoCertificacion;
import com.solucionfactible.ws.cfdi.RespuestaCreacion;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import s.f.erp.remote.client.CONFIG;
import s.f.erp.remote.client.ClientApp;
import s.f.erp.remote.client.ERPClientAppLauncher;
import s.f.erp.remote.client.ERPClientController;
import s.f.erp.remote.client.ERPClientLogDialog;
import s.f.erp.remote.client.ERPClientSetupHandler;
import s.f.erp.remote.client.ERPClientView;
import s.f.erp.remote.client.file.ERPFileListener;
import s.f.erp.utils.fs.watcher.DirectoryWatcher;

public class ERPClientApp
extends SingleFrameApplication
implements ClientApp {
    private static Map config = null;
    private static ERPClientView view;
    private boolean isTrayIconSet = false;
    private DirectoryWatcher watcher = null;
    private ERPFileListener listener = null;
    private ERPClientLogDialog logWindow = null;
    private SimpleDateFormat logDateFormat = null;
    private static ERPClientAppLauncher launcher;
    public ERPClientController clientController = null;
    private Logger logger = Logger.getLogger(ERPClientApp.class);
    private Map<String, DirectoryWatcher> watchers = null;
    public static final String SF_HOST = "solucionfactible.com";
    public static final String FACTDIGITAL_HOST = "sistema.factdigital.com";
    private String USING_HOST = "sistema.factdigital.com";

    public void setUsingHost(String host) {
        if (SF_HOST.equals(host) || FACTDIGITAL_HOST.equals(host)) {
            this.USING_HOST = host;
        }
    }

    public String getUsingHost() {
        return this.USING_HOST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startup() {
        this.getMainFrame().setDefaultCloseOperation(3);
        config = launcher.getConfig();
        ERPClientApp eRPClientApp = this;
        synchronized (eRPClientApp) {
            if (view == null) {
                view = new ERPClientView(this);
                this.setupMainWindowGUIMisc();
                this.logger.debug("Iniciando Interfaz Gr\u00e1fica");
                this.show(view);
            }
        }
        if (config.isEmpty()) {
            boolean dbResponse;
            this.myWait(800L);
            this.logger.debug("Configuraci\u00f3n vacia, abriendo ventana de configuraci\u00f3n");
            view.openConfig(true);
            this.setupMainWindowGUIMisc();
            if (config.containsKey("DB_PORT")) {
                CONFIG.dbPort = Integer.valueOf(config.get("DB_PORT").toString());
            }
            if (dbResponse = this.initializeDB(CONFIG.getDBArgsWithPort())) {
                this.monitor(config);
            } else {
                this.logger.error("No se pudo iniciar la base de datos");
            }
        } else {
            this.logger.debug("Iniciando base de datos local");
            boolean dbResponse = this.initializeDB(CONFIG.getDBArgsWithPort());
            if (dbResponse) {
                this.monitor(config);
            } else {
                this.addToMainLog("Parece que ya hay otra aplicaci\u00f3n usando el puerto " + CONFIG.dbPort);
            }
        }
    }

    public void newWatcher(List<Map> watchersConfig) {
    }

    public DirectoryWatcher getWatcher() {
        return this.watcher;
    }

    public boolean initializeDB(String[] args) {
        this.logger.debug("Inicializando base de datos");
        boolean isPortAbailable = this.checkPort();
        if (isPortAbailable) {
            try {
                Server.main(args);
                this.logger.info("Base de datos inicializada en el puerto: " + CONFIG.dbPort);
            }
            catch (RuntimeException e) {
                this.logger.error("No se pudo inicializar la base de datos", e);
            }
        }
        return isPortAbailable;
    }

    public void setupMainWindowGUIMisc() {
        this.myWait(600L);
        view.setMainWindowGUIMisc();
    }

    public synchronized void myWait(long milliSeconds) {
        try {
            this.wait(milliSeconds);
        }
        catch (IllegalMonitorStateException e) {
            this.logger.error("IllegalMonitorStateException", e);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("IllegalArgumentException", e);
        }
        catch (InterruptedException e) {
            this.logger.error("InterruptedException", e);
        }
    }

    public static void setParent(ERPClientAppLauncher launcher) {
        ERPClientApp.launcher = launcher;
    }

    private boolean checkPort() {
        boolean response = false;
        try {
            response = CONFIG.isPortAvailable(CONFIG.dbPort);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("IllegalArgumentException", e);
        }
        this.myWait(800L);
        return response;
    }

    public Map getConfig() {
        return config;
    }

    public boolean changeDBPort(int dbPort) {
        boolean success = true;
        this.logger.info("Cambiando el puerto de la base de datos a " + dbPort);
        if (this.checkPort()) {
            CONFIG.dbPort = dbPort;
            CONFIG.shutdownDB();
            this.addToMainLog("Reiniciando base de datos");
            Server.main(CONFIG.getDBArgsWithPort());
            this.logger.info("Base de datos inicializada en el puerto: " + dbPort);
        } else {
            success = false;
            this.logger.error("No se pudo cambiar la base de datos al puerto:" + dbPort);
        }
        return success;
    }

    public void setConfig(Map conf) {
        config = conf;
    }

    public void restarMonitor() {
        this.watcher.removeAllListeners();
        this.watcher.stop();
        this.listener = new ERPFileListener(this, config);
        this.watcher.addListener(this.listener);
        this.monitor(config);
        this.watcher.start();
    }

    public void appendToLogWindow(Object message) {
        if (view != null) {
            view.addToLogWindow((String)message);
        }
    }

    @Override
    public void monitor(Map config) {
        this.clientController = new ERPClientController(view, config, true);
        String dir = (String)config.get("DIRECTORY");
        Integer interval = (Integer)config.get("INTERVAL");
        this.watchers = new HashMap<String, DirectoryWatcher>();
        String watcherName = "ERPClientWatcher";
        DirectoryWatcher currentWatcher = null;
        if (this.watchers.containsKey(watcherName)) {
            currentWatcher = this.watchers.get(watcherName);
            currentWatcher.removeAllListeners();
            currentWatcher.stop();
        } else {
            this.logger.debug("Se va a iniciar el monitoreo del dir: " + dir + " con un intervalo de " + interval + "segundos");
            try {
                File f = new File(dir);
                if (f.exists() && f.isDirectory()) {
                    if (f.canRead()) {
                        currentWatcher = new DirectoryWatcher(dir, interval);
                        currentWatcher.addListener(new ERPFileListener(this, config));
                        currentWatcher.start();
                        this.watchers.put(watcherName, currentWatcher);
                    } else {
                        this.logger.error(String.format("No se cuentan con los permisos necesarios en el directorio %s", dir));
                        this.addToMainLog(String.format("No se cuentan con los permisos necesarios en el directorio %s", dir));
                    }
                } else {
                    this.logger.error(String.format("No existe el directorio %s o no es un directorio v\u00e1lido", dir));
                    this.addToMainLog(String.format("No existe el directorio %s o no es un directorio v\u00e1lido", dir));
                }
            }
            catch (Exception e) {
                this.logger.fatal("No se pudo iniciar el monitor", e);
                this.addToMainLog("Ocurrio un error grave, revise el log para mayor informaci\u00f3n");
            }
        }
    }

    @Override
    protected void configureWindow(Window root) {
        root.addWindowListener(new myWindowClosingListener(root));
    }

    public static ERPClientApp getApplication() {
        return Application.getInstance(ERPClientApp.class);
    }

    public void setup(ERPClientSetupHandler setup) {
    }

    @Override
    public void log(File file, String error) {
        HashMap<String, String> k = new HashMap<String, String>();
        k.put("ERROR", error);
    }

    private String formatDate(Date d) {
        if (this.logDateFormat == null) {
            this.logDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        }
        return this.logDateFormat.format(d);
    }

    @Override
    public void log(File file, RespuestaCreacion response) {
        this.clientController.log(file, response);
    }

    public void addToMainTable(String file, String status, String detalles, Date date) {
        if (view != null) {
            view.addToMainTable(file, status, detalles, date);
        } else {
            this.logger.debug("ERPClientApp.addToMainTable called, but view = null, parameters: " + date.toString() + " " + file + " " + status);
        }
    }

    public void log(File file, CFDICertificacion response) {
        String status = "OK";
        String mensaje = "El proceso de validaci\u00f3n se ha completado correctamente";
        String detailedMessage = "";
        if (response.getStatus() == 500) {
            status = "ERROR";
            mensaje = "Han ocurrido errores que no han permitido completar el proceso de validaci\u00f3n/certificaci\u00f3n";
            detailedMessage = "Archivo: " + file.getName();
            if (view != null) {
                view.addToMainTable(file.getName(), status, mensaje, new Date());
            }
        } else {
            CFDIResultadoCertificacion[] results = response.getResultados();
            for (int i = 0; i < results.length; ++i) {
                CFDIResultadoCertificacion resultado = results[i];
                if (resultado.getStatus().equals(200)) {
                    status = "OK";
                    detailedMessage = resultado.getMensaje() + " " + resultado.getUuid();
                    mensaje = "El proceso de validaci\u00f3n se ha completado correctamente";
                } else {
                    status = "ERROR";
                    mensaje = "Han ocurrido errores que no han permitido completar el proceso de validaci\u00f3n/certificaci\u00f3n";
                    detailedMessage = resultado.getMensaje();
                }
                if (view != null) {
                    view.addToMainTable(file.getName(), status, mensaje, new Date());
                }
                this.logger.info(response.toString());
            }
        }
        this.addToMainLog(String.format("%s -- %s", status, detailedMessage));
        this.clientController.log(file, response);
    }

    public void addToMainLog(String message) {
        if (view != null) {
            view.addMainLog(String.format("%s -- %s ", this.formatDate(new Date()), message));
        } else {
            this.logger.debug("ERPClientApp.addToMainLog called, but view = null, message: " + message);
        }
    }

    @Override
    public void sendCompleted(RespuestaCreacion response) {
        if (this.clientController != null) {
            this.clientController.sendCompleted(response);
        }
    }

    public void sendCompleted(File file, CFDICertificacion response) {
        if (this.clientController != null) {
            this.clientController.sendCompleted(file, response);
        }
    }

    @Override
    public void log(String msg) {
        System.out.println(msg);
        if (this.clientController != null) {
            this.clientController.writeLog(msg);
        }
    }

    public void requestSetSystemTrayIcon() {
    }

    public void setSystemTrayIcon() {
        TrayIcon trayIcon = null;
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/s/f/erp/remote/client/resources/flechaICON 22x22.gif"));
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("Mouse clicked!!");
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    System.out.println("Mouse Pressed");
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    System.out.println("Mouse Released");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    System.out.println("Mouse Entered");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    System.out.println("Mouse Exited");
                }
            };
            PopupMenu popup = new PopupMenu();
            String action = null;
            String env = null;
            String tooltip = "SFERPClient";
            if (config != null && !config.isEmpty() && (action = (String)config.get("ACTION")) != null && (env = (String)config.get("ENVIRONMENT")) != null) {
                tooltip = action + " [" + env + "]";
            }
            trayIcon = new TrayIcon(image, tooltip, popup);
            MenuItem defaultItem = new MenuItem("Salir");
            MenuItem openInterface = new MenuItem("Abrir");
            defaultItem.addActionListener(new myExitingActionListener(trayIcon));
            popup.add(defaultItem);
            openInterface.addActionListener(new myOpenInterfaceActionListener(trayIcon));
            popup.add(openInterface);
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(new myActionListenerclass(trayIcon));
            trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(trayIcon);
                this.isTrayIconSet = true;
            }
            catch (AWTException e) {
                this.log("[ERROR] TrayIcon could not be added" + e.getMessage() + " " + e.getCause());
                System.err.println("TrayIcon could not be added.");
            }
        }
    }

    static {
        launcher = null;
    }

    class myOpenInterfaceActionListener
    implements ActionListener {
        TrayIcon trayIcon = null;

        @Override
        public void actionPerformed(ActionEvent e) {
            ERPClientApp.this.startup();
        }

        public myOpenInterfaceActionListener(TrayIcon trayIcon) {
            this.trayIcon = trayIcon;
        }
    }

    class myExitingActionListener
    implements ActionListener {
        TrayIcon trayIcon = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public myExitingActionListener(TrayIcon trayIcon) {
            this.trayIcon = trayIcon;
        }
    }

    class myActionListenerclass
    implements ActionListener {
        TrayIcon trayIcon = null;

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public myActionListenerclass(TrayIcon trayIcon) {
            this.trayIcon = trayIcon;
        }
    }

    class myWindowClosingListener
    extends WindowAdapter {
        Window root = null;

        public myWindowClosingListener(Window root) {
            this.root = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosing(WindowEvent e) {
            String closedWindow = e.getWindow().getName();
            if ("mainFrame".equals(closedWindow)) {
                try {
                    CONFIG.shutdownDB();
                }
                catch (Exception ex) {
                    ERPClientApp.this.logger.debug("Problemas al cerrar la aplicaci\u00f3n", ex);
                }
                finally {
                    System.exit(0);
                }
            }
        }
    }
}

