/*
 * Decompiled with CFR 0.152.
 */
package s.f.erp.remote.client;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class CONFIG {
    public static final String configFileName = "config.xml";
    public static final String LOG_PATH = ".";
    public static final String masterConfigFile = "master.xml";
    public static int dbPort = 9001;
    private static Logger cLogger = Logger.getLogger(CONFIG.class);
    public static Connection connection = null;

    public static Connection doConnection() {
        Connection conection = null;
        String driver = "org.hsqldb.jdbcDriver";
        String user = "sa";
        String pass = "";
        String url = "jdbc:hsqldb:hsql://127.0.0.1:" + dbPort + "/";
        try {
            Class.forName(driver);
            conection = DriverManager.getConnection(url, user, pass);
            if (!CONFIG.existTable(conection)) {
                CONFIG.createTable(conection);
            }
        }
        catch (Exception e) {
            cLogger.error("Failed to load HSQLDB JDBC driver.", e);
        }
        connection = conection;
        return conection;
    }

    public static void shutdownDB() {
        try {
            Connection conn = CONFIG.doConnection();
            cLogger.debug("Ejecutando SQL Command: SHUTDOWN");
            conn.createStatement().execute("SHUTDOWN;");
            cLogger.debug("Ejecutado SHUTDOWN correctamente");
        }
        catch (SQLException e) {
            cLogger.error("Hubo problemas al ejecutar el comando SHUTDOWN en la base de datos", e);
        }
    }

    private static boolean existTable(Connection conection) {
        boolean exist = false;
        StringBuilder query = new StringBuilder();
        try {
            query.append("SELECT * FROM currentFiles;");
            PreparedStatement pstmt = conection.prepareStatement(query.toString());
            ResultSet rs = pstmt.executeQuery();
            exist = true;
        }
        catch (SQLException sqle) {
            cLogger.info("Tabla currentFiles no existe, creando... ");
        }
        return exist;
    }

    private static void createTable(Connection conection) {
        StringBuilder query = new StringBuilder();
        query.append(" CREATE TABLE currentFiles( path varchar(300) not null,  creation_date bigint not null, PRIMARY KEY( path ) ); ");
        try {
            PreparedStatement pstmt = conection.prepareStatement(query.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException sqler) {
            cLogger.error("Ha ocurrido un error al crear la tabla.", sqler);
        }
    }

    public static void updateRecord(Connection conection, String path, long modificationDate) {
        StringBuilder query = new StringBuilder();
        query.append("UPDATE currentFiles SET creation_date=? WHERE path=?");
        try {
            PreparedStatement pstmt = conection.prepareStatement(query.toString());
            pstmt.setLong(1, modificationDate);
            pstmt.setString(2, path);
            int rowsAff = pstmt.executeUpdate();
            if (rowsAff == 0) {
                query = new StringBuilder();
                pstmt.close();
                query.append("INSERT INTO currentFiles VALUES(?,?);");
                pstmt = conection.prepareStatement(query.toString());
                pstmt.setString(1, path);
                pstmt.setLong(2, modificationDate);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            cLogger.error("Ha ocurrido un error al actualizar la tabla de archivos. ", sqle);
        }
    }

    public static void deleteRecord(String path, Connection conection) {
        try {
            PreparedStatement pstmt = conection.prepareStatement("DELETE FROM currentFiles WHERE path = ?;");
            pstmt.setString(1, path);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            cLogger.error("Ha ocurrido un error al quitar un elemento de la tabla de archivos. ", sqle);
        }
    }

    public static void doInserts(String path, Connection conection, long lastModified) {
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO currentFiles VALUES(?, ?);");
        try {
            PreparedStatement pstmt = conection.prepareStatement(query.toString());
            pstmt.setString(1, path);
            pstmt.setLong(2, lastModified);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            cLogger.error("Ha ocurrido un error al agregar un elemento a la tabla de archivos. ", sqle);
        }
    }

    public static String[] getDBArgsWithPort() {
        return new String[]{"--port", "" + dbPort, "--no_system_exit", "true"};
    }

    public static String[] getDBArgsDefault() {
        return new String[]{"--no_system_exit", "true"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port) {
        boolean response = false;
        if (port < 100 || port > 60000) {
            cLogger.error("Invalid start port: " + port);
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        cLogger.debug(String.format("Checando si esta disponible el puerto (%s)", port));
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            response = true;
            cLogger.debug(String.format("Esta disponible el puerto (%s)", port));
        }
        catch (IOException e) {
            cLogger.error("No esta disponible el puerto:" + port);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    cLogger.error("IOException", e);
                }
            }
        }
        return response;
    }
}

