/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.japura.util.date.DateMask;
import org.japura.util.date.DateSeparator;

public final class DateUtil {
    private static synchronized boolean validateDateWithRegex(String string, DateMask dateMask, DateSeparator dateSeparator) {
        String string2 = "[0-9]{1,2}";
        String string3 = "[0-9]{4}";
        String string4 = "";
        String string5 = "\\" + dateSeparator.getSeparatorString();
        if (dateMask.equals((Object)DateMask.MMDDYYYY) || dateMask.equals((Object)DateMask.DDMMYYYY)) {
            string4 = string2 + string5 + string2 + string5 + string3;
        } else if (dateMask.equals((Object)DateMask.YYYYMMDD) || dateMask.equals((Object)DateMask.YYYYDDMM)) {
            string4 = string3 + string5 + string2 + string5 + string2;
        }
        return string != null && string.matches(string4);
    }

    public static synchronized boolean validate(String string, DateMask dateMask, DateSeparator dateSeparator) {
        return DateUtil.validateDateWithRegex(string, dateMask, dateSeparator);
    }

    public static synchronized Date toDate(String string, Locale locale, DateSeparator dateSeparator) {
        DateMask dateMask = DateMask.getMask(locale);
        return DateUtil.toDate(string, dateMask, dateSeparator);
    }

    public static synchronized Date toDate(String string, DateMask dateMask, DateSeparator dateSeparator) {
        if (DateUtil.validateDateWithRegex(string, dateMask, dateSeparator)) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String[] stringArray = string.split("\\" + dateSeparator.getSeparatorString());
            if (dateMask == DateMask.DDMMYYYY) {
                n3 = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n = Integer.parseInt(stringArray[2]);
            } else if (dateMask == DateMask.MMDDYYYY) {
                n2 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n = Integer.parseInt(stringArray[2]);
            } else if (dateMask == DateMask.YYYYMMDD) {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n3 = Integer.parseInt(stringArray[2]);
            } else if (dateMask == DateMask.YYYYDDMM) {
                n = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
            }
            try {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setLenient(false);
                gregorianCalendar.clear();
                gregorianCalendar.set(5, n3);
                gregorianCalendar.set(2, n2 - 1);
                gregorianCalendar.set(1, n);
                return gregorianCalendar.getTime();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static synchronized String toString(Locale locale, DateSeparator dateSeparator, long l) {
        return DateUtil.toString(locale, dateSeparator, l, TimeZone.getDefault());
    }

    public static synchronized String toString(Locale locale, DateSeparator dateSeparator, long l, TimeZone timeZone) {
        DateMask dateMask = DateMask.getMask(locale);
        return DateUtil.toString(dateMask, dateSeparator, l, timeZone);
    }

    public static synchronized String toString(DateMask dateMask, DateSeparator dateSeparator, long l) {
        return DateUtil.toString(dateMask, dateSeparator, l, TimeZone.getDefault());
    }

    public static synchronized String toString(DateMask dateMask, DateSeparator dateSeparator, long l, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        return DateUtil.toString(dateMask, dateSeparator, n3, n2, n);
    }

    public static synchronized String toString(DateMask dateMask, DateSeparator dateSeparator, int n, int n2, int n3) {
        String string = dateSeparator.getSeparatorString();
        String string2 = "";
        if (n > 0 && n2 > 0 && n3 > 0) {
            if (dateMask.equals((Object)DateMask.DDMMYYYY)) {
                string2 = DateUtil.toString(n) + string + DateUtil.toString(n2) + string + DateUtil.toString(n3);
            } else if (dateMask.equals((Object)DateMask.MMDDYYYY)) {
                string2 = DateUtil.toString(n2) + string + DateUtil.toString(n) + string + DateUtil.toString(n3);
            } else if (dateMask.equals((Object)DateMask.YYYYMMDD)) {
                string2 = DateUtil.toString(n3) + string + DateUtil.toString(n2) + string + DateUtil.toString(n);
            } else if (dateMask.equals((Object)DateMask.YYYYDDMM)) {
                string2 = DateUtil.toString(n3) + string + DateUtil.toString(n) + string + DateUtil.toString(n2);
            }
        }
        return string2;
    }

    private static synchronized String toString(int n) {
        if (n >= 0 && n <= 9) {
            return "0" + n;
        }
        return Integer.toString(n);
    }
}

