/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util.date;

import java.util.HashMap;
import java.util.Locale;
import org.japura.util.date.LocaleToMask;

public enum DateMask {
    DDMMYYYY(1),
    MMDDYYYY(2),
    YYYYMMDD(3),
    YYYYDDMM(4);

    private final int id;
    private static HashMap<String, HashMap<String, DateMask>> registerMasks;

    private DateMask(int n2) {
        this.id = n2;
    }

    public int getId() {
        return this.id;
    }

    public static DateMask getMask(int n) {
        for (DateMask dateMask : DateMask.values()) {
            if (dateMask.getId() != n) continue;
            return dateMask;
        }
        return null;
    }

    public static synchronized void register(Locale locale, DateMask dateMask) {
        HashMap<String, DateMask> hashMap;
        if (locale == null || dateMask == null) {
            return;
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (registerMasks == null) {
            registerMasks = new HashMap();
        }
        if ((hashMap = registerMasks.get(string)) == null) {
            hashMap = new HashMap();
            registerMasks.put(string, hashMap);
        }
        hashMap.put(string2, dateMask);
    }

    public static synchronized void unregister(Locale locale) {
        String string;
        HashMap<String, DateMask> hashMap;
        if (registerMasks != null && (hashMap = registerMasks.get(string = locale.getLanguage())) != null) {
            String string2 = locale.getCountry();
            hashMap.remove(string2);
            if (hashMap.size() == 0) {
                registerMasks.remove(string);
                if (registerMasks.size() == 0) {
                    registerMasks = null;
                }
            }
        }
    }

    public static synchronized DateMask getMask(Locale locale) {
        String string;
        DateMask dateMask;
        Object object;
        HashMap<String, DateMask> hashMap;
        if (registerMasks != null && (hashMap = registerMasks.get(object = locale.getLanguage())) != null && (dateMask = hashMap.get(string = locale.getCountry())) != null) {
            return dateMask;
        }
        object = LocaleToMask.getMask(locale);
        if (object == null) {
            throw new RuntimeException("There is no DateMask for locale: " + locale);
        }
        return object;
    }
}

