/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakList<T>
extends AbstractList<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    @Override
    public boolean add(T t) {
        this.expungeStaleEntries();
        return this.list.add(new WeakReference<T>(t, this.queue));
    }

    @Override
    public T get(int n) {
        this.expungeStaleEntries();
        return this.list.get(n).get();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.list.size();
    }

    @Override
    public T remove(int n) {
        return this.list.remove(n).get();
    }

    private void expungeStaleEntries() {
        Reference<T> reference = this.queue.poll();
        while (reference != null) {
            int n = this.list.indexOf(reference);
            if (n != -1) {
                this.list.remove(n);
            }
            reference = this.queue.poll();
        }
    }
}

