/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.listener;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.japura.controller.Controller;
import org.japura.controller.ControllerWrapper;
import org.japura.gui.I18nStringKeys;
import org.japura.gui.WrapLabel;
import org.japura.i18n.I18nManager;
import org.japura.task.AbstractTask;
import org.japura.task.TaskManagerListener;
import org.japura.task.listener.InputEventBlocker;

public class TaskExecutionProgressListener
implements TaskManagerListener {
    private static final int TIME_TO_SHOW_MODAL = 600;
    private HashMap<Integer, TaskExecutionModalPanel> modalPanels;
    private HashMap<Integer, InputEventBlocker> eventHooks;
    private HashMap<Integer, Integer> tasksCount;
    private Icon progressBarIcon;

    public TaskExecutionProgressListener() {
        this.modalPanels = new HashMap();
        this.eventHooks = new HashMap();
        this.tasksCount = new HashMap();
        URL uRL = this.getClass().getResource("/resources/images/jpr_progressbar.gif");
        this.progressBarIcon = new ImageIcon(uRL);
    }

    public TaskExecutionProgressListener(Icon icon) {
        this.progressBarIcon = icon;
    }

    @Override
    public synchronized void submitted(AbstractTask<?> abstractTask) {
        if (abstractTask.isCanceled()) {
            return;
        }
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            return;
        }
        Integer n = controllerWrapper.getControllerGroupId();
        Integer n2 = this.tasksCount.get(n);
        if (n2 == null) {
            n2 = 0;
        }
        Object object = n2;
        Integer n3 = n2 = Integer.valueOf(n2 + 1);
        this.tasksCount.put(n, n2);
        if (n2 == 1) {
            object = new InputEventBlocker();
            ((InputEventBlocker)object).apply();
            this.eventHooks.put(n, (InputEventBlocker)object);
        }
    }

    @Override
    public synchronized void beforeExecute(AbstractTask<?> abstractTask) {
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            return;
        }
        final Integer n = controllerWrapper.getControllerGroupId();
        String string = abstractTask.getMessage();
        Controller<?> controller = Controller.getRoot(n);
        if (controller != null) {
            TaskExecutionModalPanel taskExecutionModalPanel = this.modalPanels.get(n);
            if (taskExecutionModalPanel == null) {
                taskExecutionModalPanel = new TaskExecutionModalPanel(string, this.progressBarIcon, new ModalPanelAction(){

                    @Override
                    public void execute() {
                        TaskExecutionProgressListener.this.removeEventHook(n);
                    }
                });
                this.modalPanels.put(n, taskExecutionModalPanel);
                taskExecutionModalPanel.start(n);
            } else {
                if (string == null) {
                    string = "";
                }
                taskExecutionModalPanel.setText(string);
            }
        }
    }

    private void removeEventHook(Integer n) {
        InputEventBlocker inputEventBlocker = this.eventHooks.remove(n);
        if (inputEventBlocker != null) {
            inputEventBlocker.remove();
        }
    }

    @Override
    public void removed(AbstractTask<?> abstractTask) {
        this.afterExecute(abstractTask);
    }

    @Override
    public synchronized void afterExecute(AbstractTask<?> abstractTask) {
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            return;
        }
        Integer n = controllerWrapper.getControllerGroupId();
        Integer n2 = this.tasksCount.remove(n);
        if (n2 == null) {
            this.removeEventHook(n);
            this.removeModalPanel(n);
            return;
        }
        Integer n3 = n2;
        Integer n4 = n2 = Integer.valueOf(n2 - 1);
        if (n2 == 0) {
            this.removeEventHook(n);
            this.removeModalPanel(n);
        } else if (n2 > 0) {
            this.tasksCount.put(n, n2);
        }
    }

    private void removeModalPanel(Integer n) {
        TaskExecutionModalPanel taskExecutionModalPanel = this.modalPanels.remove(n);
        if (taskExecutionModalPanel != null) {
            taskExecutionModalPanel.stop();
            Controller<?> controller = Controller.getRoot(n);
            if (controller != null) {
                controller.closeModal(taskExecutionModalPanel);
            }
        }
    }

    private static class TaskExecutionModalPanel
    extends JPanel {
        private static final long serialVersionUID = -8882308898730194272L;
        private WrapLabel label;
        private JLabel timerLabel;
        private long elapsedStartTime = 0L;
        private DecimalFormat integerTimeFormatter;
        private int width = 300;
        private String text;
        private StringBuilder textTimer;
        private Timer timer;
        private Timer starter;
        private boolean stop;
        private ModalPanelAction action;

        public TaskExecutionModalPanel(String string, Icon icon, ModalPanelAction modalPanelAction) {
            this.action = modalPanelAction;
            this.textTimer = new StringBuilder();
            this.integerTimeFormatter = new DecimalFormat("00");
            if (string == null) {
                string = "";
            }
            this.text = string;
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            Border border2 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
            this.setBackground(Color.WHITE);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.getLabel(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(20, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.getTimeLabel(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("progressComponent");
            this.add((Component)jLabel, gridBagConstraints);
        }

        public void setText(String string) {
            this.getLabel().setText(string);
        }

        private JLabel getTimeLabel() {
            if (this.timerLabel == null) {
                this.timerLabel = new JLabel();
                this.timerLabel.setName("timerLabel");
                this.timerLabel.setText(this.getTimerString(0L));
            }
            return this.timerLabel;
        }

        protected Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        long l = System.currentTimeMillis() - TaskExecutionModalPanel.this.elapsedStartTime;
                        TaskExecutionModalPanel.this.getTimeLabel().setText(TaskExecutionModalPanel.this.getTimerString(l));
                    }
                });
            }
            return this.timer;
        }

        public void start(final Integer n) {
            this.elapsedStartTime = System.currentTimeMillis();
            this.getTimer().start();
            if (this.starter == null) {
                this.starter = new Timer(600, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (TaskExecutionModalPanel.this.stop) {
                            return;
                        }
                        Controller<?> controller = Controller.getRoot(n);
                        if (controller != null) {
                            controller.addModal(TaskExecutionModalPanel.this, null, JLayeredPane.POPUP_LAYER + 1);
                        }
                        if (TaskExecutionModalPanel.this.action != null) {
                            TaskExecutionModalPanel.this.action.execute();
                        }
                    }
                });
                this.starter.setRepeats(false);
                this.starter.start();
            }
        }

        public void stop() {
            this.stop = true;
            if (this.starter != null) {
                this.starter.stop();
            }
            this.getTimer().stop();
        }

        private WrapLabel getLabel() {
            if (this.label == null) {
                this.label = new WrapLabel(this.text);
                this.label.setWrapWidth(this.width);
                this.label.setName("messageLabel");
            }
            return this.label;
        }

        private String getTimerString(long l) {
            if (l < 0L) {
                return "-";
            }
            l /= 1000L;
            this.textTimer.setLength(0);
            this.textTimer.append(I18nManager.getString(I18nStringKeys.TIME_ELAPSED.getKey()));
            this.textTimer.append(" ");
            long l2 = l;
            long l3 = 0L;
            long l4 = 0L;
            if (l2 >= 60L) {
                l3 = (int)l2 / 60;
                l2 -= l3 * 60L;
            }
            if (l3 >= 60L) {
                l4 = (int)l3 / 60;
                l3 -= l4 * 60L;
            }
            this.textTimer.append(this.integerTimeFormatter.format(l4));
            this.textTimer.append(I18nManager.getString(I18nStringKeys.HOUR_ACRONYM.getKey()));
            this.textTimer.append(" ");
            this.textTimer.append(this.integerTimeFormatter.format(l3));
            this.textTimer.append(I18nManager.getString(I18nStringKeys.MINUTE_ACRONYM.getKey()));
            this.textTimer.append(" ");
            this.textTimer.append(this.integerTimeFormatter.format(l2));
            this.textTimer.append(I18nManager.getString(I18nStringKeys.SECOND_ACRONYM.getKey()));
            return this.textTimer.toString();
        }
    }

    private static interface ModalPanelAction {
        public void execute();
    }
}

