/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.listener;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;

public class InputEventBlocker {
    private AWTEventListener listener;

    private AWTEventListener getListener() {
        if (this.listener == null) {
            this.listener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof InputEvent) {
                        InputEvent inputEvent = (InputEvent)aWTEvent;
                        inputEvent.consume();
                    }
                }
            };
        }
        return this.listener;
    }

    public void apply() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getListener(), Long.MAX_VALUE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void remove() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.getListener());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

