/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.japura.controller.Controller;
import org.japura.controller.ControllerWrapper;
import org.japura.controller.Group;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugResult;
import org.japura.debug.DebugWindow;
import org.japura.task.AbstractTask;
import org.japura.task.AsynchronousTaskExecutor;
import org.japura.task.DebugTasks;
import org.japura.task.Mode;
import org.japura.task.SynchronousTaskExecutor;
import org.japura.task.TaskEvent;
import org.japura.task.TaskExeception;
import org.japura.task.TaskManagerListener;

public final class TaskManager {
    private static ReentrantLock lock = new ReentrantLock();
    private static List<TaskManagerListener> listeners = new ArrayList<TaskManagerListener>();
    private static SynchronousTaskExecutor synchronousExecutor = new SynchronousTaskExecutor();
    private static AsynchronousTaskExecutor asynchronousExecutor = new AsynchronousTaskExecutor();
    private static Map<Group, SynchronousTaskExecutor> groupExecutors = new HashMap<Group, SynchronousTaskExecutor>();
    private static List<Group> pendingToRemove = new ArrayList<Group>();

    private TaskManager() {
    }

    static void fireBeforeExecuteListeners(AbstractTask<?> abstractTask) {
        for (TaskManagerListener taskManagerListener : listeners) {
            taskManagerListener.beforeExecute(abstractTask);
        }
    }

    static void fireRemovedListeners(AbstractTask<?> abstractTask) {
        for (TaskManagerListener taskManagerListener : listeners) {
            taskManagerListener.removed(abstractTask);
        }
    }

    static void fireAfterExecuteListeners(AbstractTask<?> abstractTask) {
        for (TaskManagerListener taskManagerListener : listeners) {
            taskManagerListener.afterExecute(abstractTask);
        }
    }

    public static synchronized void addListener(TaskManagerListener taskManagerListener) {
        listeners.add(taskManagerListener);
    }

    public static synchronized void removeListener(TaskManagerListener taskManagerListener) {
        listeners.remove(taskManagerListener);
    }

    public static synchronized List<TaskManagerListener> getListeners() {
        return Collections.unmodifiableList(listeners);
    }

    static List<DebugResult> addToDebugWindow(AbstractTask<?> abstractTask, TaskEvent taskEvent) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.AddParameterEvent addParameterEvent = new DebugTasks.AddParameterEvent(abstractTask, taskEvent, System.currentTimeMillis(), SwingUtilities.isEventDispatchThread(), TaskManager.getQueueCount());
            return DebugComponent.publish(DebugTasks.class, addParameterEvent);
        }
        return null;
    }

    static void addToDebugWindow(AbstractTask<?> abstractTask) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.AddParameter addParameter = new DebugTasks.AddParameter(abstractTask);
            DebugComponent.publish(DebugTasks.class, addParameter);
        }
    }

    static void removeToDebugWindow(AbstractTask<?> abstractTask) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.RemoveParameter removeParameter = new DebugTasks.RemoveParameter(abstractTask);
            DebugComponent.publish(DebugTasks.class, removeParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void submit(AbstractTask<?> abstractTask) {
        void var2_11;
        lock.lock();
        try {
            if (abstractTask.isSubmitted()) {
                throw new TaskExeception("Task already submitted");
            }
            abstractTask.setSubmitted(true);
        }
        finally {
            lock.unlock();
        }
        TaskManager.addToDebugWindow(abstractTask, TaskEvent.SUBMIT);
        for (TaskManagerListener object2 : listeners) {
            object2.submitted(abstractTask);
        }
        for (AbstractTask abstractTask2 : abstractTask.getNextTasks()) {
            for (TaskManagerListener taskManagerListener : listeners) {
                taskManagerListener.submitted(abstractTask2);
            }
        }
        abstractTask.submitted();
        for (AbstractTask abstractTask3 : abstractTask.getNextTasks()) {
            abstractTask3.submitted();
        }
        if (abstractTask.getMode().equals((Object)Mode.ASYNCHRONOUS)) {
            abstractTask.setCancelToken(asynchronousExecutor.getCancelToken());
            asynchronousExecutor.submit(abstractTask);
            return;
        }
        boolean bl = false;
        SynchronousTaskExecutor synchronousTaskExecutor = synchronousExecutor;
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper != null) {
            Group group = controllerWrapper.getController().getGroup();
            SynchronousTaskExecutor synchronousTaskExecutor2 = groupExecutors.get(group);
        }
        if (var2_11 == null) {
            throw new RuntimeException("There is no executor");
        }
        abstractTask.setCancelToken(var2_11.getCancelToken());
        for (AbstractTask<?> abstractTask4 : abstractTask.getNextTasks()) {
            abstractTask4.setCancelToken(var2_11.getCancelToken());
        }
        AbstractTask<?> abstractTask5 = var2_11.getTaskInExecution();
        if (abstractTask5 != null && abstractTask.getMode().equals((Object)Mode.NESTED) && !SwingUtilities.isEventDispatchThread() && abstractTask5.getThreadId() == Thread.currentThread().getId()) {
            bl = true;
        }
        if (bl) {
            var2_11.beforeExecute(abstractTask);
            abstractTask.run();
            var2_11.afterExecute(abstractTask);
        } else {
            var2_11.submit(abstractTask);
        }
    }

    static void checkAndClean(AbstractTask<?> abstractTask) {
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            return;
        }
        Group group = controllerWrapper.getController().getGroup();
        TaskManager.checkAndClean(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndClean(Group group) {
        lock.lock();
        try {
            if (pendingToRemove.size() == 0) {
                return;
            }
            if (!pendingToRemove.contains(group)) {
                return;
            }
            SynchronousTaskExecutor synchronousTaskExecutor = groupExecutors.get(group);
            if (synchronousTaskExecutor != null && !synchronousTaskExecutor.hasTask()) {
                synchronousTaskExecutor.cancel();
                pendingToRemove.remove(group);
                groupExecutors.remove(group);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void callTokenKey() {
        Controller.setTaskManagerTokenKey(new TokenKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Group group, TokenKey tokenKey) {
        if (tokenKey == null) {
            return;
        }
        lock.lock();
        try {
            groupExecutors.put(group, new SynchronousTaskExecutor());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Group group, TokenKey tokenKey) {
        if (tokenKey == null) {
            return;
        }
        lock.lock();
        try {
            pendingToRemove.add(group);
        }
        finally {
            lock.unlock();
        }
        TaskManager.checkAndClean(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTask(Group group) {
        if (asynchronousExecutor.hasTask(group.getId())) {
            return true;
        }
        lock.lock();
        try {
            SynchronousTaskExecutor synchronousTaskExecutor = groupExecutors.get(group);
            if (synchronousTaskExecutor != null) {
                boolean bl = synchronousTaskExecutor.hasTask();
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTask() {
        lock.lock();
        try {
            for (SynchronousTaskExecutor synchronousTaskExecutor : groupExecutors.values()) {
                if (!synchronousTaskExecutor.hasTask()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return synchronousExecutor.hasTask() || asynchronousExecutor.hasTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(int n) {
        lock.lock();
        try {
            for (Map.Entry<Group, SynchronousTaskExecutor> entry : groupExecutors.entrySet()) {
                Group group = entry.getKey();
                if (group.getId() != n) continue;
                entry.getValue().cancel();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        asynchronousExecutor.cancel();
        synchronousExecutor.cancel();
        lock.lock();
        try {
            for (SynchronousTaskExecutor synchronousTaskExecutor : groupExecutors.values()) {
                synchronousTaskExecutor.cancel();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQueueCount() {
        int n = 0;
        lock.lock();
        try {
            for (SynchronousTaskExecutor synchronousTaskExecutor : groupExecutors.values()) {
                n += synchronousTaskExecutor.getQueue().size();
            }
        }
        finally {
            lock.unlock();
        }
        n += synchronousExecutor.getQueue().size();
        return n += asynchronousExecutor.getQueue().size();
    }

    public static DebugComponent createDebugPanel() {
        DebugTasks debugTasks = new DebugTasks();
        DebugComponent.add(debugTasks);
        return debugTasks;
    }

    public static void showDebugWindow() {
        DebugWindow.showDebugWindow(TaskManager.createDebugPanel());
    }

    public static final class TokenKey {
        private TokenKey() {
        }
    }
}

