/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import org.japura.controller.Controller;
import org.japura.controller.ControllerWrapper;
import org.japura.debug.DebugResult;
import org.japura.task.AbstractTask;
import org.japura.task.Mode;
import org.japura.task.TaskEvent;

class TaskDebugLog
extends DebugResult {
    private String id;
    private String name;
    private String source;
    private TaskEvent event;
    private long time;
    private boolean edt;
    private boolean waitForEDT;
    private int queueTasks;
    private long timeSpent;
    private Mode mode;

    public TaskDebugLog(AbstractTask<?> abstractTask, TaskEvent taskEvent, long l, boolean bl, int n) {
        this.id = abstractTask.getId();
        this.queueTasks = n;
        this.name = abstractTask.getName();
        this.time = l;
        this.event = taskEvent;
        this.edt = bl;
        this.mode = abstractTask.getMode();
        this.waitForEDT = abstractTask.isWaitForEDT();
        this.timeSpent = abstractTask.getBackgroundTimeSpent();
        ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
        if (controllerWrapper == null) {
            this.source = "TaskManager";
        } else {
            Controller<?> controller = controllerWrapper.getController();
            this.source = controller.getClass().getSimpleName() + " [" + controller.stringToDebugComponent() + "]";
        }
    }

    public int getQueueTasks() {
        return this.queueTasks;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isEdt() {
        return this.edt;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public TaskEvent getEvent() {
        return this.event;
    }

    public boolean isWaitForEDT() {
        return this.waitForEDT;
    }

    public long getStartTime() {
        return this.time;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setTimeSpent(long l) {
        this.timeSpent = l;
    }

    public String getTimeSpent() {
        if (this.timeSpent < 1000L) {
            return Long.toString(this.timeSpent) + "ms";
        }
        long l = this.timeSpent % 1000L;
        long l2 = this.timeSpent / 1000L;
        long l3 = this.timeSpent / 60000L;
        long l4 = this.timeSpent / 3600000L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l4 > 0L) {
            stringBuilder.append(l4);
            stringBuilder.append("h");
        }
        if (l3 > 0L) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(l3);
            stringBuilder.append("m");
        }
        if (l2 > 0L) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(l2);
            stringBuilder.append("s");
        }
        if (l > 0L) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(l);
            stringBuilder.append("ms");
        }
        return stringBuilder.toString();
    }
}

