/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.japura.task.AbstractTask;
import org.japura.task.FutureTaskWrapper;

class TaskBlockingQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private List<Runnable> queue = new ArrayList<Runnable>();

    TaskBlockingQueue() {
    }

    public synchronized List<AbstractTask<?>> removeTasks() {
        ArrayList arrayList = new ArrayList();
        for (Runnable runnable : this.queue) {
            FutureTaskWrapper futureTaskWrapper = (FutureTaskWrapper)runnable;
            AbstractTask<?> abstractTask = futureTaskWrapper.getTask();
            arrayList.add(abstractTask);
        }
        this.queue.clear();
        return arrayList;
    }

    @Override
    public synchronized Runnable poll() {
        if (this.queue.size() > 0) {
            return this.queue.remove(0);
        }
        return null;
    }

    @Override
    public synchronized Runnable peek() {
        if (this.queue.size() > 0) {
            return this.queue.get(0);
        }
        return null;
    }

    @Override
    public synchronized boolean offer(Runnable runnable) {
        this.queue(runnable);
        return true;
    }

    @Override
    public synchronized void put(Runnable runnable) throws InterruptedException {
        this.queue(runnable);
    }

    @Override
    public synchronized boolean offer(Runnable runnable, long l, TimeUnit timeUnit) throws InterruptedException {
        this.queue(runnable);
        return true;
    }

    private synchronized void queue(Runnable runnable) {
        FutureTaskWrapper futureTaskWrapper = (FutureTaskWrapper)runnable;
        if (futureTaskWrapper.getTask().isPriority()) {
            this.queue.add(0, runnable);
            futureTaskWrapper.getTask().clearPriority();
        } else {
            this.queue.add(runnable);
        }
    }

    @Override
    public synchronized Runnable take() throws InterruptedException {
        if (this.queue.size() > 0) {
            return this.queue.remove(0);
        }
        return null;
    }

    @Override
    public synchronized Runnable poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.remove(0);
    }

    @Override
    public synchronized int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> collection) {
        collection.addAll(this.queue);
        int n = this.queue.size();
        this.queue.clear();
        return n;
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> collection, int n) {
        int n2;
        for (n2 = 0; n2 <= n && this.queue.size() > 0; ++n2) {
            collection.add(this.queue.remove(0));
        }
        this.queue.removeAll(collection);
        return n2;
    }

    @Override
    public synchronized Iterator<Runnable> iterator() {
        return this.queue.iterator();
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }
}

