/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.japura.task.AbstractTask;
import org.japura.task.AbstractTaskExecutor;
import org.japura.task.TaskBlockingQueue;
import org.japura.task.TaskEvent;
import org.japura.task.TaskManager;

final class SynchronousTaskExecutor
extends AbstractTaskExecutor {
    private Stack<AbstractTask<?>> tasksRunningStack = new Stack();

    public SynchronousTaskExecutor() {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new TaskBlockingQueue());
    }

    AbstractTask<?> getTaskInExecution() {
        if (this.tasksRunningStack.isEmpty()) {
            return null;
        }
        return this.tasksRunningStack.peek();
    }

    @Override
    void beforeExecute(AbstractTask<?> abstractTask) {
        TaskManager.addToDebugWindow(abstractTask);
        for (AbstractTask<?> abstractTask2 : abstractTask.getNextTasks()) {
            TaskManager.addToDebugWindow(abstractTask2, TaskEvent.SUBMIT);
            this.submit(abstractTask2);
        }
        abstractTask.clearNextTasks();
        abstractTask.setThreadId(Thread.currentThread().getId());
        TaskManager.addToDebugWindow(abstractTask, TaskEvent.BEFORE);
        TaskManager.fireBeforeExecuteListeners(abstractTask);
        if (abstractTask.isCanceled()) {
            return;
        }
        abstractTask.willExecute();
        this.tasksRunningStack.push(abstractTask);
    }

    @Override
    protected void afterExecute(AbstractTask<?> abstractTask) {
        TaskManager.removeToDebugWindow(abstractTask);
        TaskManager.addToDebugWindow(abstractTask, TaskEvent.AFTER);
        this.tasksRunningStack.remove(abstractTask);
        TaskManager.fireAfterExecuteListeners(abstractTask);
        if (abstractTask.hasException()) {
            TaskBlockingQueue taskBlockingQueue = (TaskBlockingQueue)this.getQueue();
            for (AbstractTask<?> abstractTask2 : taskBlockingQueue.removeTasks()) {
                abstractTask2.clearCancelToken();
                abstractTask2.setRemoved(true);
                abstractTask.addNextTask(abstractTask2);
                TaskManager.addToDebugWindow(abstractTask2, TaskEvent.REMOVED);
                TaskManager.fireRemovedListeners(abstractTask);
            }
        }
        this.applyAfterExecute(abstractTask);
    }
}

