/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.japura.controller.Controller;
import org.japura.controller.ControllerWrapper;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;
import org.japura.gui.CheckComboBox;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.model.ListCheckModel;
import org.japura.task.AbstractTask;
import org.japura.task.TaskDebugLog;
import org.japura.task.TaskEvent;

class DebugTasks
extends DebugComponent {
    private static final long serialVersionUID = -387375942292452243L;
    private CheckComboBox eventComboBox;
    private CheckComboBox columnComboBox;
    private JPanel northPanel;
    private JButton clearButton;
    private JTable table;
    private List<TaskDebugLog> taskLogs;
    private List<Column> visibleColumns = new ArrayList<Column>();
    private JList tasksList;
    private JSplitPane horizontalSplit;

    public DebugTasks() {
        ListCheckModel listCheckModel = this.getColumnComboBox().getModel();
        for (Column column : Column.values()) {
            listCheckModel.addElement(new Object[]{column});
            if (!column.defaultEnabled) continue;
            listCheckModel.addCheck(new Object[]{column});
            this.visibleColumns.add(column);
        }
        listCheckModel.addListCheckListener(new ListCheckListener(){

            @Override
            public void removeCheck(ListEvent listEvent) {
                this.updateVisibleColumns();
            }

            @Override
            public void addCheck(ListEvent listEvent) {
                this.updateVisibleColumns();
            }

            private void updateVisibleColumns() {
                DebugTasks.this.visibleColumns.clear();
                for (Object object : DebugTasks.this.getColumnComboBox().getModel().getCheckeds()) {
                    DebugTasks.this.visibleColumns.add((Column)((Object)object));
                }
                DebugTasks.this.getTable().tableChanged(null);
                DebugTasks.this.getTable().repaint();
            }
        });
        this.taskLogs = new ArrayList<TaskDebugLog>();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHorizontalSplit(), "Center");
        this.add((Component)this.getNorthPanel(), "North");
    }

    private JSplitPane getHorizontalSplit() {
        if (this.horizontalSplit == null) {
            this.horizontalSplit = new JSplitPane(1);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JLabel(" Tasks running: name [root controller]"), "North");
            jPanel.add((Component)new JScrollPane(this.getTasksList()), "Center");
            this.add((Component)jPanel, "East");
            this.horizontalSplit.setLeftComponent(new JScrollPane(this.getTable()));
            this.horizontalSplit.setRightComponent(jPanel);
            this.horizontalSplit.setResizeWeight(1.0);
        }
        return this.horizontalSplit;
    }

    private JList getTasksList() {
        if (this.tasksList == null) {
            this.tasksList = new JList();
            this.tasksList.setModel(new DefaultListModel());
        }
        return this.tasksList;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.table.setModel(new Model());
        }
        return this.table;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout(0);
            this.northPanel.setLayout(flowLayout);
            this.northPanel.add(new JLabel("Events:"));
            this.northPanel.add(this.getEventComboBox());
            this.northPanel.add(new JLabel("Columns:"));
            this.northPanel.add(this.getColumnComboBox());
            this.northPanel.add(this.getClearButton());
        }
        return this.northPanel;
    }

    private CheckComboBox getEventComboBox() {
        if (this.eventComboBox == null) {
            this.eventComboBox = new CheckComboBox();
            this.eventComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.eventComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.eventComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
            ListCheckModel listCheckModel = this.eventComboBox.getModel();
            for (TaskEvent taskEvent : TaskEvent.values()) {
                listCheckModel.addElement(new Object[]{taskEvent});
                listCheckModel.addCheck(new Object[]{taskEvent});
            }
        }
        return this.eventComboBox;
    }

    private CheckComboBox getColumnComboBox() {
        if (this.columnComboBox == null) {
            this.columnComboBox = new CheckComboBox();
            this.columnComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.columnComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.columnComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
        }
        return this.columnComboBox;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebugTasks.this.taskLogs.clear();
                    DebugTasks.this.getTable().revalidate();
                }
            });
        }
        return this.clearButton;
    }

    @Override
    protected String getTitle() {
        return "Tasks";
    }

    @Override
    protected DebugResult update(DebugParameter debugParameter) {
        if (debugParameter instanceof RemoveParameter) {
            RemoveParameter removeParameter = (RemoveParameter)debugParameter;
            this.removeTask(removeParameter.getTask());
            return null;
        }
        if (debugParameter instanceof AddParameter) {
            AddParameter addParameter = (AddParameter)debugParameter;
            this.addTask(addParameter.getTask());
            return null;
        }
        if (debugParameter instanceof AddParameterEvent) {
            AddParameterEvent addParameterEvent = (AddParameterEvent)debugParameter;
            return this.addTask(addParameterEvent.getTask(), addParameterEvent.getEvent(), addParameterEvent.getCurrentTime(), addParameterEvent.isEdt(), addParameterEvent.getQueueCount());
        }
        return null;
    }

    private void addTask(final AbstractTask<?> abstractTask) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)DebugTasks.this.getTasksList().getModel();
                defaultListModel.addElement(new TaskItem(abstractTask));
            }
        });
    }

    private void removeTask(final AbstractTask<?> abstractTask) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)DebugTasks.this.getTasksList().getModel();
                defaultListModel.removeElement(new TaskItem(abstractTask));
            }
        });
    }

    public TaskDebugLog addTask(AbstractTask<?> abstractTask, TaskEvent taskEvent, long l, boolean bl, int n) {
        if (!this.getEventComboBox().getModel().isChecked((Object)taskEvent)) {
            return null;
        }
        final TaskDebugLog taskDebugLog = new TaskDebugLog(abstractTask, taskEvent, l, bl, n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugTasks.this.taskLogs.add(taskDebugLog);
                DebugTasks.this.getTable().revalidate();
            }
        });
        return taskDebugLog;
    }

    static class AddParameterEvent
    extends Parameter {
        private long currentTime;
        private int queueCount;
        private TaskEvent event;
        private boolean edt;

        public AddParameterEvent(AbstractTask<?> abstractTask, TaskEvent taskEvent, long l, boolean bl, int n) {
            super(abstractTask);
            this.event = taskEvent;
            this.queueCount = n;
            this.edt = bl;
            this.currentTime = l;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        public int getQueueCount() {
            return this.queueCount;
        }

        public TaskEvent getEvent() {
            return this.event;
        }

        public boolean isEdt() {
            return this.edt;
        }
    }

    static class RemoveParameter
    extends Parameter {
        public RemoveParameter(AbstractTask<?> abstractTask) {
            super(abstractTask);
        }
    }

    static class AddParameter
    extends Parameter {
        public AddParameter(AbstractTask<?> abstractTask) {
            super(abstractTask);
        }
    }

    private static class Parameter
    extends DebugParameter {
        private AbstractTask<?> task;

        public Parameter(AbstractTask<?> abstractTask) {
            this.task = abstractTask;
        }

        public AbstractTask<?> getTask() {
            return this.task;
        }
    }

    private static class TaskItem {
        private String id;
        private String name;

        public TaskItem(AbstractTask<?> abstractTask) {
            this.id = abstractTask.getId();
            this.name = abstractTask.getName();
            if (this.name == null) {
                this.name = "---";
            }
            this.name = this.name.trim();
            ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
            if (controllerWrapper != null) {
                Controller<?> controller = controllerWrapper.getController().getRoot();
                this.name = this.name + " [" + controller.getClass().getSimpleName() + "]";
            } else {
                this.name = this.name + " []";
            }
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TaskItem taskItem = (TaskItem)object;
            return !(this.id == null ? taskItem.id != null : !this.id.equals(taskItem.id));
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum Column {
        ID("Id", false),
        NAME("Name", true),
        EVENT("Event", true),
        QUEUE_TASKS("QueueTasks", false),
        EDT("EDT", false),
        MODE("Mode", false),
        TIME_SPENT("TimeSpent", false),
        WAIT_FOR_EDT("WaitForEDT", false),
        START_TIME("StartTime", false),
        SOURCE("Source", true);

        private boolean defaultEnabled;
        private String columnName;

        private Column(String string2, boolean bl) {
            this.columnName = string2;
            this.defaultEnabled = bl;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private class Model
    implements TableModel {
        private Date date = new Date();

        private Model() {
        }

        @Override
        public int getRowCount() {
            return DebugTasks.this.taskLogs.size();
        }

        @Override
        public int getColumnCount() {
            return DebugTasks.this.visibleColumns.size();
        }

        @Override
        public String getColumnName(int n) {
            Column column = (Column)((Object)DebugTasks.this.visibleColumns.get(n));
            return column.columnName;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Column column = (Column)((Object)DebugTasks.this.visibleColumns.get(n2));
            TaskDebugLog taskDebugLog = (TaskDebugLog)DebugTasks.this.taskLogs.get(n);
            if (column.equals((Object)Column.ID)) {
                return taskDebugLog.getId();
            }
            if (column.equals((Object)Column.NAME)) {
                return taskDebugLog.getName();
            }
            if (column.equals((Object)Column.EVENT)) {
                return taskDebugLog.getEvent();
            }
            if (column.equals((Object)Column.QUEUE_TASKS)) {
                return Integer.toString(taskDebugLog.getQueueTasks());
            }
            if (column.equals((Object)Column.EDT)) {
                if (taskDebugLog.isEdt()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.MODE)) {
                return taskDebugLog.getMode().name().toLowerCase();
            }
            if (column.equals((Object)Column.TIME_SPENT)) {
                if (taskDebugLog.getEvent().equals((Object)TaskEvent.DO_IN_BACKGROUND)) {
                    return taskDebugLog.getTimeSpent();
                }
                return "";
            }
            if (column.equals((Object)Column.WAIT_FOR_EDT)) {
                if (taskDebugLog.isWaitForEDT()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.START_TIME)) {
                this.date.setTime(taskDebugLog.getStartTime());
                return this.date.toString();
            }
            if (column.equals((Object)Column.SOURCE)) {
                return taskDebugLog.getSource();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }
    }
}

