/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.japura.task.AbstractTask;
import org.japura.task.AbstractTaskExecutor;
import org.japura.task.TaskEvent;
import org.japura.task.TaskManager;

final class AsynchronousTaskExecutor
extends AbstractTaskExecutor {
    private List<AbstractTask<?>> tasksRunning = new ArrayList();

    public AsynchronousTaskExecutor() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    void beforeExecute(AbstractTask<?> abstractTask) {
        TaskManager.addToDebugWindow(abstractTask);
        abstractTask.setThreadId(Thread.currentThread().getId());
        TaskManager.addToDebugWindow(abstractTask, TaskEvent.BEFORE);
        TaskManager.fireBeforeExecuteListeners(abstractTask);
        if (abstractTask.isCanceled()) {
            return;
        }
        abstractTask.willExecute();
        this.tasksRunning.add(abstractTask);
    }

    @Override
    protected void afterExecute(AbstractTask<?> abstractTask) {
        this.tasksRunning.remove(abstractTask);
        TaskManager.removeToDebugWindow(abstractTask);
        TaskManager.addToDebugWindow(abstractTask, TaskEvent.AFTER);
        TaskManager.fireAfterExecuteListeners(abstractTask);
        this.applyAfterExecute(abstractTask);
    }
}

