/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.japura.controller.ControllerWrapper;
import org.japura.task.AbstractTask;
import org.japura.task.CancelToken;
import org.japura.task.FutureTaskWrapper;
import org.japura.task.TaskEvent;
import org.japura.task.TaskManager;

abstract class AbstractTaskExecutor
extends ThreadPoolExecutor {
    private CancelToken cancelToken;
    private List<AbstractTask<?>> tasks = new ArrayList();

    protected AbstractTaskExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    synchronized void cancel() {
        if (this.cancelToken != null) {
            this.cancelToken.cancel = true;
            this.cancelToken = null;
        }
    }

    synchronized CancelToken getCancelToken() {
        if (this.cancelToken == null) {
            this.cancelToken = new CancelToken();
        }
        return this.cancelToken;
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        AbstractTask abstractTask = (AbstractTask)runnable;
        this.tasks.add(abstractTask);
        return new FutureTaskWrapper<T>(abstractTask, t);
    }

    @Override
    protected final void beforeExecute(Thread thread, Runnable runnable) {
        FutureTaskWrapper futureTaskWrapper = (FutureTaskWrapper)runnable;
        this.beforeExecute(futureTaskWrapper.getTask());
    }

    final boolean hasTask() {
        return this.tasks.size() > 0;
    }

    final boolean hasTask(int n) {
        for (AbstractTask<?> abstractTask : this.tasks) {
            ControllerWrapper controllerWrapper = abstractTask.getControllerWrapper();
            if (controllerWrapper == null || controllerWrapper.getControllerGroupId() != n) continue;
            return true;
        }
        return false;
    }

    abstract void beforeExecute(AbstractTask<?> var1);

    @Override
    protected final void afterExecute(Runnable runnable, Throwable throwable) {
        FutureTaskWrapper futureTaskWrapper = (FutureTaskWrapper)runnable;
        AbstractTask<?> abstractTask = futureTaskWrapper.getTask();
        this.tasks.remove(abstractTask);
        TaskManager.checkAndClean(abstractTask);
        this.afterExecute(abstractTask);
    }

    protected abstract void afterExecute(AbstractTask<?> var1);

    protected void applyAfterExecute(final AbstractTask<?> abstractTask) {
        Runnable runnable = null;
        if (abstractTask.hasException()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    TaskManager.addToDebugWindow(abstractTask, TaskEvent.ERROR);
                    abstractTask.handleException(abstractTask.getException());
                    for (AbstractTask<?> abstractTask2 : abstractTask.getNextTasks()) {
                        abstractTask2.removed();
                    }
                }
            };
        } else if (abstractTask.isExecuted()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    TaskManager.addToDebugWindow(abstractTask, TaskEvent.DONE);
                    abstractTask.done();
                }
            };
        } else if (abstractTask.isCanceled()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    TaskManager.addToDebugWindow(abstractTask, TaskEvent.CANCELED);
                    abstractTask.canceled();
                }
            };
        }
        if (runnable == null) {
            return;
        }
        if (abstractTask.isWaitForEDT()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

