/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.japura.controller.ControllerWrapper;
import org.japura.exception.HandlerExceptionManager;
import org.japura.task.CancelToken;
import org.japura.task.Mode;
import org.japura.task.TaskExeception;
import org.japura.task.TaskManager;

public abstract class AbstractTask<T>
implements Runnable {
    private static Random randomID = new Random();
    private CancelToken cancelToken;
    private ControllerWrapper controllerWrapper;
    private long threadId;
    private boolean submitted;
    private boolean hasException;
    private boolean executed;
    private boolean canceled;
    private Exception exception;
    private T result;
    private String name;
    private String message;
    private boolean waitForEDT = false;
    private String id;
    private boolean priority;
    private boolean removed;
    private long backgroundTimeSpent;
    private List<AbstractTask<?>> nextTasks;
    private Mode mode = Mode.SYNCHRONOUS;

    AbstractTask() {
        int n = randomID.nextInt();
        long l = System.currentTimeMillis();
        int n2 = randomID.nextInt(255);
        this.id = Long.toHexString(n) + ":" + Long.toHexString(l) + ":" + Long.toHexString(n2);
        this.nextTasks = new ArrayList();
    }

    List<AbstractTask<?>> getNextTasks() {
        return Collections.unmodifiableList(this.nextTasks);
    }

    void clearNextTasks() {
        this.nextTasks.clear();
    }

    void addNextTask(AbstractTask<?> abstractTask) {
        if (!this.nextTasks.contains(abstractTask)) {
            this.nextTasks.add(abstractTask);
        }
    }

    void setBackgroundTimeSpent(long l) {
        this.backgroundTimeSpent = l;
    }

    public long getBackgroundTimeSpent() {
        return this.backgroundTimeSpent;
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(Mode mode) {
        if (mode != null) {
            this.mode = mode;
        }
    }

    public final String getId() {
        return this.id;
    }

    void setCancelToken(CancelToken cancelToken) {
        this.cancelToken = cancelToken;
    }

    void clearCancelToken() {
        this.cancelToken = null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved(boolean bl) {
        this.removed = bl;
    }

    void setHasException(boolean bl) {
        this.hasException = bl;
    }

    boolean hasException() {
        return this.hasException;
    }

    protected void handleException(Exception exception) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ControllerWrapper controllerWrapper = this.getControllerWrapper();
        if (controllerWrapper != null) {
            hashMap.put("CONTROLLER_GROUP_ID", controllerWrapper.getControllerGroupId());
            hashMap.put("CONTROLLER_ID", controllerWrapper.getControllerId());
        }
        HandlerExceptionManager.handle(this.getException(), hashMap);
        if (controllerWrapper != null) {
            controllerWrapper.taskExecutionError(this);
        }
    }

    public final void setControllerWrapper(ControllerWrapper controllerWrapper) {
        if (this.controllerWrapper == null) {
            this.controllerWrapper = controllerWrapper;
        }
    }

    public final ControllerWrapper getControllerWrapper() {
        return this.controllerWrapper;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public boolean isWaitForEDT() {
        return this.waitForEDT && this.getMode().equals((Object)Mode.SYNCHRONOUS);
    }

    public void setWaitForEDT(boolean bl) {
        this.waitForEDT = bl;
    }

    protected void canceled() {
    }

    protected void removed() {
    }

    public void submit() {
        TaskManager.submit(this);
    }

    void setSubmitted(boolean bl) {
        this.submitted = bl;
        this.setRemoved(false);
    }

    public final boolean isSubmitted() {
        return this.submitted;
    }

    public void cancel() {
        if (!this.isExecuted()) {
            this.canceled = true;
        }
    }

    public T getResult() {
        return this.result;
    }

    protected void setResult(T t) {
        this.result = t;
    }

    long getThreadId() {
        return this.threadId;
    }

    public boolean isCanceled() {
        if (this.isExecuted()) {
            return false;
        }
        return this.canceled || this.cancelToken != null && this.cancelToken.cancel;
    }

    void setThreadId(long l) {
        this.threadId = l;
    }

    protected void submitted() {
    }

    protected void willExecute() {
    }

    protected void done() {
    }

    void setExecuted() {
        this.executed = true;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void retry() {
        if (!this.hasException) {
            throw new TaskExeception("Task without exception");
        }
        this.setSubmitted(false);
        this.setHasException(false);
        this.setPriority();
        this.submit();
    }

    void setPriority() {
        this.priority = true;
    }

    boolean isPriority() {
        return this.priority;
    }

    void clearPriority() {
        this.priority = false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractTask abstractTask = (AbstractTask)object;
        return !(this.id == null ? abstractTask.id != null : !this.id.equals(abstractTask.id));
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }
}

