/*
 * Decompiled with CFR 0.152.
 */
package org.japura.modal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.InternalFrameListener;
import org.japura.modal.ModalEvent;
import org.japura.modal.ModalListener;
import org.japura.modal.ModalPanel;

public class Modal {
    private static Integer defaultModalDepth = JLayeredPane.DEFAULT_LAYER + 1;
    private static Hashtable<RootPaneContainer, Modal> modals = new Hashtable();
    private RootPaneContainer rootPane;
    private ModalPanel modalPanel;
    private int oldDefaultCloseOperation;
    private WindowListener[] oldWindowListeners;
    private InternalFrameListener[] oldInternalFrameListeners;
    private ComponentListener resizeListener;
    private List<Component> components;
    private HashMap<Component, List<ModalListener>> listeners;
    private HashMap<Component, Integer> depths;

    public static Component getCurrentModal(JFrame jFrame) {
        return Modal.getCurrentModal_(jFrame);
    }

    public static Component getCurrentModal(JDialog jDialog) {
        return Modal.getCurrentModal_(jDialog);
    }

    public static Component getCurrentModal(JInternalFrame jInternalFrame) {
        return Modal.getCurrentModal_(jInternalFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getCurrentModal_(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            if (modal != null && modal.getSize() > 0) {
                return modal.components.get(modal.components.size() - 1);
            }
            return null;
        }
    }

    public static void closeCurrentModal(JFrame jFrame) {
        Modal.closeCurrentModal_(jFrame);
    }

    public static void closeCurrentModal(JDialog jDialog) {
        Modal.closeCurrentModal_(jDialog);
    }

    public static void closeCurrentModal(JInternalFrame jInternalFrame) {
        Modal.closeCurrentModal_(jInternalFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeCurrentModal_(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            if (modal != null) {
                modal.closeCurrent();
                if (modal.getSize() == 0) {
                    modals.remove(rootPaneContainer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeModal(Component component) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            RootPaneContainer rootPaneContainer = null;
            Modal modal = null;
            for (Map.Entry<RootPaneContainer, Modal> entry : modals.entrySet()) {
                modal = entry.getValue();
                rootPaneContainer = entry.getKey();
                if (rootPaneContainer != null && modal != null && modal.components.contains(component)) break;
                rootPaneContainer = null;
                modal = null;
            }
            if (rootPaneContainer != null && modal != null) {
                super.close(component);
                if (modal.getSize() == 0) {
                    modals.remove(rootPaneContainer);
                }
            }
        }
    }

    public static void closeAllModals(JFrame jFrame) {
        Modal.closeAllModals_(jFrame);
    }

    public static void closeAllModals(JDialog jDialog) {
        Modal.closeAllModals_(jDialog);
    }

    public static void closeAllModals(JInternalFrame jInternalFrame) {
        Modal.closeAllModals_(jInternalFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeAllModals_(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            if (modal != null) {
                modal.closeAll();
                modals.remove(rootPaneContainer);
            }
        }
    }

    public static boolean hasModal(JFrame jFrame) {
        return Modal.hasModal_(jFrame);
    }

    public static boolean hasModal(JDialog jDialog) {
        return Modal.hasModal_(jDialog);
    }

    public static boolean hasModal(JInternalFrame jInternalFrame) {
        return Modal.hasModal_(jInternalFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasModal_(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            return modal != null && modal.getSize() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Modal getModal(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            if (modal == null) {
                modal = new Modal(rootPaneContainer);
                modals.put(rootPaneContainer, modal);
            }
            return modal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isModal(Component component) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            for (Map.Entry<RootPaneContainer, Modal> entry : modals.entrySet()) {
                if (!entry.getValue().components.contains(component)) continue;
                return true;
            }
            return false;
        }
    }

    public static void addModal(JInternalFrame jInternalFrame, Component component) {
        Modal.addModal(jInternalFrame, component, null);
    }

    public static void addModal(JInternalFrame jInternalFrame, Component component, ModalListener modalListener) {
        Modal.addModal_(jInternalFrame, component, modalListener, defaultModalDepth);
    }

    public static void addModal(JInternalFrame jInternalFrame, Component component, ModalListener modalListener, Integer n) {
        Modal.addModal_(jInternalFrame, component, modalListener, n);
    }

    public static void addModal(JDialog jDialog, Component component) {
        Modal.addModal(jDialog, component, null);
    }

    public static void addModal(JDialog jDialog, Component component, ModalListener modalListener) {
        Modal.addModal_(jDialog, component, modalListener, defaultModalDepth);
    }

    public static void addModal(JDialog jDialog, Component component, ModalListener modalListener, Integer n) {
        Modal.addModal_(jDialog, component, modalListener, n);
    }

    public static void addModal(JFrame jFrame, Component component) {
        Modal.addModal(jFrame, component, null);
    }

    public static void addModal(JFrame jFrame, Component component, ModalListener modalListener) {
        Modal.addModal_(jFrame, component, modalListener, defaultModalDepth);
    }

    public static void addModal(JFrame jFrame, Component component, ModalListener modalListener, Integer n) {
        Modal.addModal_(jFrame, component, modalListener, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addModal_(RootPaneContainer rootPaneContainer, Component component, ModalListener modalListener, Integer n) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            if (!Modal.isModal(component)) {
                Modal.getModal(rootPaneContainer).addModal(component, modalListener, n);
            }
        }
    }

    public static void addListener(JFrame jFrame, Component component, ModalListener modalListener) {
        Modal.addListener_(jFrame, component, modalListener);
    }

    public static void addListener(JDialog jDialog, Component component, ModalListener modalListener) {
        Modal.addListener_(jDialog, component, modalListener);
    }

    public static void addListener(JInternalFrame jInternalFrame, Component component, ModalListener modalListener) {
        Modal.addListener_(jInternalFrame, component, modalListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addListener_(RootPaneContainer rootPaneContainer, Component component, ModalListener modalListener) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            if (Modal.isModal(component)) {
                Modal.getModal(rootPaneContainer).addListener(component, modalListener);
            }
        }
    }

    public static int getModalCount(JFrame jFrame) {
        return Modal.getModalCount_(jFrame);
    }

    public static int getModalCount(JDialog jDialog) {
        return Modal.getModalCount_(jDialog);
    }

    public static int getModalCount(JInternalFrame jInternalFrame) {
        return Modal.getModalCount_(jInternalFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getModalCount_(RootPaneContainer rootPaneContainer) {
        Hashtable<RootPaneContainer, Modal> hashtable = modals;
        synchronized (hashtable) {
            Modal modal = modals.get(rootPaneContainer);
            if (modal != null) {
                return modal.getSize();
            }
            return 0;
        }
    }

    private Modal(RootPaneContainer rootPaneContainer) {
        this.rootPane = rootPaneContainer;
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Modal.this.resizeModalPanel();
            }
        };
        this.components = new ArrayList<Component>();
        this.depths = new HashMap();
        this.listeners = new HashMap();
        this.rootPane.getRootPane().addComponentListener(this.resizeListener);
        this.resizeModalPanel();
        if (rootPaneContainer instanceof JFrame) {
            this.backupProperties((JFrame)rootPaneContainer);
        } else if (rootPaneContainer instanceof JDialog) {
            this.backupProperties((JDialog)rootPaneContainer);
        } else if (rootPaneContainer instanceof JInternalFrame) {
            this.backupProperties((JInternalFrame)rootPaneContainer);
        }
        this.getModalPanel().setVisible(true);
    }

    private void backupProperties(JFrame jFrame) {
        this.oldDefaultCloseOperation = jFrame.getDefaultCloseOperation();
        jFrame.setDefaultCloseOperation(0);
        for (WindowListener windowListener : this.oldWindowListeners = jFrame.getWindowListeners()) {
            jFrame.removeWindowListener(windowListener);
        }
    }

    private void backupProperties(JDialog jDialog) {
        this.oldDefaultCloseOperation = jDialog.getDefaultCloseOperation();
        jDialog.setDefaultCloseOperation(0);
        for (WindowListener windowListener : this.oldWindowListeners = jDialog.getWindowListeners()) {
            jDialog.removeWindowListener(windowListener);
        }
    }

    private void backupProperties(JInternalFrame jInternalFrame) {
        this.oldDefaultCloseOperation = jInternalFrame.getDefaultCloseOperation();
        jInternalFrame.setDefaultCloseOperation(0);
        for (InternalFrameListener internalFrameListener : this.oldInternalFrameListeners = jInternalFrame.getInternalFrameListeners()) {
            jInternalFrame.removeInternalFrameListener(internalFrameListener);
        }
    }

    private void closeCurrent() {
        if (this.components.size() > 0) {
            Component component = this.components.remove(this.components.size() - 1);
            this.getModalPanel().removeAll();
            this.fireCloseActionListener(this.listeners.get(component));
            this.listeners.remove(component);
            if (this.components.size() > 0) {
                this.showNextComponent();
            } else {
                this.restoreRootPane();
            }
        }
    }

    private void resizeModalPanel() {
        Dimension dimension = this.rootPane.getRootPane().getSize();
        this.getModalPanel().setBounds(0, 0, dimension.width, dimension.height);
        this.getModalPanel().revalidate();
    }

    private void restoreRootPane() {
        block4: {
            block5: {
                block3: {
                    this.rootPane.getRootPane().removeComponentListener(this.resizeListener);
                    this.rootPane.getLayeredPane().remove(this.getModalPanel());
                    ((Component)((Object)this.rootPane)).repaint();
                    if (!(this.rootPane instanceof JFrame)) break block3;
                    JFrame jFrame = (JFrame)this.rootPane;
                    jFrame.setDefaultCloseOperation(this.oldDefaultCloseOperation);
                    for (WindowListener windowListener : this.oldWindowListeners) {
                        jFrame.addWindowListener(windowListener);
                    }
                    break block4;
                }
                if (!(this.rootPane instanceof JDialog)) break block5;
                JDialog jDialog = (JDialog)this.rootPane;
                jDialog.setDefaultCloseOperation(this.oldDefaultCloseOperation);
                for (WindowListener windowListener : this.oldWindowListeners) {
                    jDialog.addWindowListener(windowListener);
                }
                break block4;
            }
            if (!(this.rootPane instanceof JInternalFrame)) break block4;
            JInternalFrame jInternalFrame = (JInternalFrame)this.rootPane;
            jInternalFrame.setDefaultCloseOperation(this.oldDefaultCloseOperation);
            for (InternalFrameListener internalFrameListener : this.oldInternalFrameListeners) {
                jInternalFrame.addInternalFrameListener(internalFrameListener);
            }
        }
    }

    private void close(Component component) {
        if (this.components.size() > 0) {
            if (!this.components.contains(component)) {
                return;
            }
            this.components.remove(component);
            this.depths.remove(component);
            this.getModalPanel().removeAll();
            this.fireCloseActionListener(this.listeners.get(component));
            this.listeners.remove(component);
            if (this.components.size() > 0) {
                this.showNextComponent();
            } else {
                this.restoreRootPane();
            }
        }
    }

    private void showNextComponent() {
        Component component = this.components.get(this.components.size() - 1);
        Integer n = this.depths.get(component);
        this.rootPane.getLayeredPane().remove(this.getModalPanel());
        this.rootPane.getLayeredPane().add((Component)this.getModalPanel(), n);
        this.getModalPanel().add("", component);
        this.getModalPanel().revalidate();
        this.getModalPanel().repaint();
    }

    private void fireCloseActionListener(List<ModalListener> list) {
        if (list != null) {
            for (ModalListener modalListener : list) {
                modalListener.modalClosed(new ModalEvent(this.rootPane));
            }
        }
    }

    private void closeAll() {
        this.getModalPanel().removeAll();
        this.components.clear();
        this.depths.clear();
        this.listeners.clear();
        this.restoreRootPane();
    }

    private void addModal(Component component, ModalListener modalListener, Integer n) {
        if (n == null) {
            n = defaultModalDepth;
        }
        if (!this.components.contains(component)) {
            this.rootPane.getLayeredPane().remove(this.getModalPanel());
            this.rootPane.getLayeredPane().add((Component)this.getModalPanel(), n);
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.clearGlobalFocusOwner();
            this.getModalPanel().removeAll();
            this.getModalPanel().add("", component);
            this.resizeModalPanel();
            this.getModalPanel().repaint();
            this.components.add(component);
            this.depths.put(component, n);
            this.addListener(component, modalListener);
        }
    }

    private void addListener(Component component, ModalListener modalListener) {
        if (this.components.contains(component)) {
            List<ModalListener> list = this.listeners.get(component);
            if (list == null) {
                list = new ArrayList<ModalListener>();
                this.listeners.put(component, list);
            }
            if (modalListener != null) {
                list.add(modalListener);
            }
        }
    }

    private int getSize() {
        return this.components.size();
    }

    private ModalPanel getModalPanel() {
        if (this.modalPanel == null) {
            this.modalPanel = new ModalPanel();
            this.modalPanel.setLayout(new ModalLayout());
        }
        return this.modalPanel;
    }

    private static class ModalLayout
    implements LayoutManager {
        private Component comp;

        private ModalLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.comp = component;
        }

        @Override
        public void layoutContainer(Container container) {
            if (this.comp != null) {
                Dimension dimension = this.comp.getPreferredSize();
                Dimension dimension2 = container.getSize();
                int n = dimension2.width / 2 - dimension.width / 2;
                int n2 = dimension2.height / 2 - dimension.height / 2;
                this.comp.setBounds(n, n2, dimension.width, dimension.height);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if (this.comp != null) {
                return this.comp.getPreferredSize();
            }
            return dimension;
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }
}

