/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.japura.gui.model.PriorityComboBoxModel;

public class PriorityComboBoxRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected static Border emptyBorder = new EmptyBorder(1, 1, 1, 1);
    protected static Border bottomLineBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK);
    protected static Border separatorBorder = BorderFactory.createCompoundBorder(bottomLineBorder, emptyBorder);

    public PriorityComboBoxRenderer() {
        this.setOpaque(true);
        this.setBorder(emptyBorder);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        if (this.getText() == null || this.getText().equals("")) {
            this.setText(" ");
            dimension = super.getPreferredSize();
            this.setText("");
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    protected void applyChangesForPriorityComboBox(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (jList.getModel() instanceof PriorityComboBoxModel) {
            PriorityComboBoxModel priorityComboBoxModel = (PriorityComboBoxModel)jList.getModel();
            if (!priorityComboBoxModel.isPriorityAvailable()) {
                return;
            }
            if (priorityComboBoxModel.getPriorityItemsSize() > 0 && n == priorityComboBoxModel.getPriorityItemsSize() - 1) {
                this.setBorder(separatorBorder);
            } else {
                this.setBorder(emptyBorder);
            }
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.applyChangesForPriorityComboBox(jList, object, n, bl, bl2);
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
        } else {
            this.setText(object == null ? "" : object.toString());
        }
        return this;
    }
}

