/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.japura.gui.CheckList;
import org.japura.gui.model.ListCheckModel;

public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer {
    private Highlight highlight = Highlight.MOUSE_OVER;
    protected Color foreground = UIManager.getColor("List.foreground");
    protected Color background = UIManager.getColor("List.background");
    protected Color selectionForeground = UIManager.getColor("List.selectionForeground");
    protected Color selectionBackground = UIManager.getColor("List.selectionBackground");

    public String getText(Object object) {
        return object.toString();
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight != null ? highlight : Highlight.MOUSE_OVER;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (jList instanceof CheckList) {
            CheckList checkList = (CheckList)jList;
            ListCheckModel listCheckModel = checkList.getModel();
            boolean bl3 = listCheckModel.isChecked(object);
            boolean bl4 = listCheckModel.isLocked(object);
            this.setSelected(bl3);
            if (bl4 || !checkList.isEnabled()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            if (this.getHighlight().equals((Object)Highlight.MOUSE_OVER_AND_CHECKED_ITEMS) && (bl3 || bl)) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else if (this.getHighlight().equals((Object)Highlight.MOUSE_OVER) && bl) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else if (this.getHighlight().equals((Object)Highlight.CHECKED_ITEMS) && bl3) {
                this.setBackground(this.selectionBackground);
                this.setForeground(this.selectionForeground);
            } else {
                this.setBackground(this.background);
                this.setForeground(this.foreground);
            }
        }
        this.setText(this.getText(object));
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public static enum Highlight {
        OFF,
        MOUSE_OVER,
        CHECKED_ITEMS,
        MOUSE_OVER_AND_CHECKED_ITEMS;

    }
}

