/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class NumberDocument<T extends Number>
extends PlainDocument {
    private static final long serialVersionUID = 7570259805144825486L;
    private String separator;
    private String validateRegex;
    private String insertRegex;
    protected T maxValue;
    protected T minValue;

    public NumberDocument(Locale locale, boolean bl) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (bl) {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
            this.separator = Character.toString(decimalFormatSymbols.getDecimalSeparator());
            this.validateRegex = "([-]{1,1})?[0-9]{1,}([" + this.separator + "][0-9]{1,})?";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?([" + this.separator + "])?([0-9]{1,})?";
        } else {
            this.validateRegex = "([-]{1,1})?[0-9]{1,}";
            this.insertRegex = "([-]{1,1})?([0-9]{1,})?";
        }
    }

    protected String getValidateRegex() {
        return this.validateRegex;
    }

    protected NumberFormat getNumberFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    protected Number parse(String string) {
        NumberFormat numberFormat = this.getNumberFormat();
        try {
            return numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    protected String format(Object object) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        return numberFormat.format(object);
    }

    protected String getText() throws BadLocationException {
        return this.getText(0, this.getLength());
    }

    protected abstract boolean isAcceptableValue(Number var1);

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        Number number;
        String string2 = this.getText();
        String string3 = string2.substring(0, n) + string + string2.substring(n, string2.length());
        if (string3.matches(this.insertRegex) && (number = this.parse(string3)) != null && this.isAcceptableValue(number)) {
            super.insertString(n, string, attributeSet);
        }
    }
}

