/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Locale;
import javax.swing.text.BadLocationException;
import org.japura.gui.model.NumberDocument;

public class IntegerDocument
extends NumberDocument<Integer> {
    private static final long serialVersionUID = -6161711707235392895L;

    public IntegerDocument() {
        this((Locale)null);
    }

    public IntegerDocument(Locale locale) {
        super(locale, false);
        this.maxValue = Integer.MAX_VALUE;
        this.minValue = Integer.MIN_VALUE;
    }

    public Integer getValue() {
        try {
            Integer n;
            Number number;
            String string = this.getText();
            if (string.matches(this.getValidateRegex()) && (number = this.parse(string)) != null && (n = Integer.valueOf(number.intValue())) >= (Integer)this.minValue && n <= (Integer)this.maxValue) {
                return n;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return null;
    }

    public void setValue(int n) {
        String string = this.format(n);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public int getMaxValue() {
        return (Integer)this.maxValue;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getMinValue() {
        return (Integer)this.minValue;
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    @Override
    protected boolean isAcceptableValue(Number number) {
        int n = number.intValue();
        return n >= this.getMinValue() && n <= this.getMaxValue();
    }
}

