/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Locale;
import javax.swing.text.BadLocationException;
import org.japura.gui.model.NumberDocument;

public class DoubleDocument
extends NumberDocument<Double> {
    private static final long serialVersionUID = -1334753847712151427L;

    public DoubleDocument() {
        this((Locale)null);
    }

    public DoubleDocument(Locale locale) {
        super(locale, true);
        this.maxValue = Double.MAX_VALUE;
        this.minValue = Double.MIN_VALUE;
    }

    public Double getValue() {
        try {
            Double d;
            Number number;
            String string = this.getText();
            if (string.matches(this.getValidateRegex()) && (number = this.parse(string)) != null && (d = Double.valueOf(number.doubleValue())) >= (Double)this.minValue && d <= (Double)this.maxValue) {
                return d;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return null;
    }

    public void setValue(double d) {
        String string = this.format(d);
        try {
            this.remove(0, this.getLength());
            this.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public double getMaxValue() {
        return (Double)this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMinValue() {
        return (Double)this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    @Override
    protected boolean isAcceptableValue(Number number) {
        double d = number.doubleValue();
        return d >= this.getMinValue() && d <= this.getMaxValue();
    }
}

