/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.japura.gui.event.PriorityComboBoxEvent;
import org.japura.gui.event.PriorityComboBoxListener;
import org.japura.gui.model.PriorityComboBoxModel;

public class DefaultPriorityComboBoxModel
extends AbstractListModel
implements PriorityComboBoxModel {
    private static final long serialVersionUID = 3463014910762087126L;
    private List<Object> items = new ArrayList<Object>();
    private List<Object> priorityItems = new ArrayList<Object>();
    private Object selectedItem;
    private int priorityItemsCapacity = 3;
    private int minimalSizeForPriority;
    private boolean increasePriorityOnSelection;

    public DefaultPriorityComboBoxModel(Object[] objectArray) {
        this();
        this.addAll(objectArray);
    }

    public DefaultPriorityComboBoxModel(List<?> list) {
        this();
        this.addAll(list);
    }

    public DefaultPriorityComboBoxModel() {
        this.setMinimalSizeForPriority(10);
        this.increasePriorityOnSelection = true;
    }

    private void addAll(Object ... objectArray) {
        for (Object object : objectArray) {
            this.items.add(object);
        }
    }

    @Override
    public void addElement(Object object, boolean bl) {
        if (!this.items.contains(object)) {
            this.items.add(object);
            int n = this.items.size() - 1;
            if (bl) {
                this.addToPriority(object);
            }
            this.fireContentsChanged(this, n, n);
            if (this.selectedItem == null) {
                this.selectedItem = object;
            }
        }
    }

    public PriorityComboBoxListener[] getPriorityComboBoxListeners() {
        return (PriorityComboBoxListener[])this.listenerList.getListeners(PriorityComboBoxListener.class);
    }

    @Override
    public void addPriorityComboBoxListener(PriorityComboBoxListener priorityComboBoxListener) {
        this.listenerList.add(PriorityComboBoxListener.class, priorityComboBoxListener);
    }

    @Override
    public void removePriorityComboBoxListener(PriorityComboBoxListener priorityComboBoxListener) {
        this.listenerList.remove(PriorityComboBoxListener.class, priorityComboBoxListener);
    }

    protected void firePriorityComboBoxListeners() {
        PriorityComboBoxListener[] priorityComboBoxListenerArray;
        PriorityComboBoxEvent priorityComboBoxEvent = new PriorityComboBoxEvent(this);
        for (PriorityComboBoxListener priorityComboBoxListener : priorityComboBoxListenerArray = this.getPriorityComboBoxListeners()) {
            priorityComboBoxListener.priorityChanged(priorityComboBoxEvent);
        }
    }

    @Override
    public List<Object> getPriorityItems() {
        return new ArrayList<Object>(this.priorityItems);
    }

    @Override
    public int getPriorityItemsCapacity() {
        return this.priorityItemsCapacity;
    }

    @Override
    public void setPriorityItemsCapacity(int n) {
        this.priorityItemsCapacity = Math.max(1, n);
        while (this.priorityItems.size() > this.getPriorityItemsCapacity()) {
            int n2 = this.priorityItems.size() - 1;
            this.priorityItems.remove(n2);
            this.fireIntervalRemoved(this, n2, n2);
        }
        this.firePriorityComboBoxListeners();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.items.contains(object)) {
            this.selectedItem = object;
            if (this.isIncreasePriorityOnSelection() && object != null) {
                this.addToPriority(object);
            }
        }
    }

    @Override
    public Object getElementAt(int n) {
        if (n < 0 || n >= this.getSize()) {
            return null;
        }
        if (this.isPriorityAvailable()) {
            if (n < this.priorityItems.size()) {
                return this.priorityItems.get(n);
            }
            n -= this.priorityItems.size();
        }
        return this.items.get(n);
    }

    @Override
    public int getSize() {
        if (this.isPriorityAvailable()) {
            return this.items.size() + this.priorityItems.size();
        }
        return this.items.size();
    }

    @Override
    public void addToPriority(Object object) {
        int n;
        if (this.priorityItems.contains(object)) {
            n = this.priorityItems.indexOf(object);
            if (n > 0) {
                this.priorityItems.remove(n);
                this.priorityItems.add(n - 1, object);
            }
        } else {
            if (this.priorityItems.size() == this.getPriorityItemsCapacity()) {
                this.priorityItems.remove(this.priorityItems.size() - 1);
            }
            this.priorityItems.add(object);
        }
        if (this.isPriorityAvailable()) {
            n = this.priorityItems.indexOf(object);
            this.fireContentsChanged(this, n, n);
        }
        this.firePriorityComboBoxListeners();
    }

    @Override
    public void removeFromPriority(Object object) {
        if (this.priorityItems.contains(object)) {
            int n = this.priorityItems.indexOf(object);
            boolean bl = this.isPriorityAvailable();
            this.priorityItems.remove(n);
            if (bl) {
                this.fireContentsChanged(this, n, n);
            }
        }
    }

    public void addElement(Object object) {
        this.addElement(object, false);
    }

    public void insertElementAt(Object object, int n) {
        if (!this.items.contains(object)) {
            if (this.isPriorityAvailable()) {
                n -= this.priorityItems.size();
            }
            if (n >= 0 && n <= this.items.size()) {
                this.items.add(n, object);
            }
        }
    }

    @Override
    public void removeElement(Object object) {
        if (object == null) {
            return;
        }
        this.priorityItems.remove(object);
        int n = this.items.indexOf(object);
        if (this.items.remove(object)) {
            int n2 = n;
            if (this.isPriorityAvailable()) {
                n2 += this.getPriorityItemsSize();
            }
            this.fireIntervalRemoved(this, n2, n2);
            if (this.priorityItems.remove(object)) {
                this.firePriorityComboBoxListeners();
            }
        }
        if (this.selectedItem.equals(object)) {
            this.selectedItem = this.getSize() > 0 ? this.getElementAt(0) : null;
        }
    }

    @Override
    public void removeElementAt(int n) {
        Object object = this.getElementAt(n);
        this.removeElement(object);
    }

    @Override
    public boolean isIncreasePriorityOnSelection() {
        return this.increasePriorityOnSelection;
    }

    @Override
    public void setIncreasePriorityOnSelection(boolean bl) {
        this.increasePriorityOnSelection = bl;
    }

    @Override
    public int getPriorityItemsSize() {
        return this.priorityItems.size();
    }

    @Override
    public void clearPriorities() {
        this.priorityItems.clear();
        this.firePriorityComboBoxListeners();
    }

    @Override
    public int getMinimalSizeForPriority() {
        return this.minimalSizeForPriority;
    }

    @Override
    public boolean isPriorityAvailable() {
        return this.items.size() >= this.getMinimalSizeForPriority();
    }

    @Override
    public void setMinimalSizeForPriority(int n) {
        this.minimalSizeForPriority = Math.max(1, n);
    }

    @Override
    public boolean isPriorityItem(Object object) {
        return this.priorityItems.contains(object);
    }
}

