/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.event.ListLockListener;
import org.japura.gui.event.ListModelListener;
import org.japura.gui.model.ListCheckModel;

public class DefaultListCheckModel
implements ListCheckModel,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    private List<Object> items;
    private List<Object> checkeds = new ArrayList<Object>();
    private List<Object> lockeds = new ArrayList<Object>();

    public DefaultListCheckModel() {
        this.items = new ArrayList<Object>();
    }

    protected void fireAddedListModelListeners(List<Object> list, int n, int n2, boolean bl) {
        ListDataListener[] listDataListenerArray;
        ListModelListener[] listModelListenerArray = (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
        ListEvent listEvent = new ListEvent(this, list, bl);
        for (ListModelListener listModelListener : listModelListenerArray) {
            listModelListener.valueAdded(listEvent);
        }
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, n, n2);
        for (ListDataListener listDataListener : listDataListenerArray = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    protected void fireRemovedListModelListeners(List<Object> list, boolean bl) {
        ListModelListener[] listModelListenerArray = (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
        ListEvent listEvent = new ListEvent(this, list, bl);
        for (ListModelListener listModelListener : listModelListenerArray) {
            listModelListener.valueRemoved(listEvent);
        }
    }

    protected void fireRemovedListModelListeners(int n, int n2, boolean bl) {
        ListDataListener[] listDataListenerArray;
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n2);
        for (ListDataListener listDataListener : listDataListenerArray = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    protected void fireAddLockListModelListeners(List<Object> list, boolean bl) {
        this.fireLockListModelListeners(list, bl, true);
    }

    protected void fireRemoveLockListModelListeners(List<Object> list, boolean bl) {
        this.fireLockListModelListeners(list, bl, false);
    }

    private void fireLockListModelListeners(List<Object> list, boolean bl, boolean bl2) {
        ListLockListener[] listLockListenerArray = (ListLockListener[])this.listenerList.getListeners(ListLockListener.class);
        ListEvent listEvent = new ListEvent(this, list, bl);
        for (ListLockListener listLockListener : listLockListenerArray) {
            if (bl2) {
                listLockListener.addLock(listEvent);
                continue;
            }
            listLockListener.removeLock(listEvent);
        }
    }

    protected void fireAddCheckListModelListeners(List<Object> list, boolean bl) {
        this.fireCheckListModelListeners(list, bl, true);
    }

    protected void fireRemoveCheckListModelListeners(List<Object> list, boolean bl) {
        this.fireCheckListModelListeners(list, bl, false);
    }

    private void fireCheckListModelListeners(List<Object> list, boolean bl, boolean bl2) {
        ListCheckListener[] listCheckListenerArray = (ListCheckListener[])this.listenerList.getListeners(ListCheckListener.class);
        ListEvent listEvent = new ListEvent(this, list, bl);
        for (ListCheckListener listCheckListener : listCheckListenerArray) {
            if (bl2) {
                listCheckListener.addCheck(listEvent);
                continue;
            }
            listCheckListener.removeCheck(listEvent);
        }
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    private void clear(boolean bl) {
        if (this.items.size() == 0) {
            return;
        }
        this.checkeds.clear();
        this.lockeds.clear();
        if (this.items.size() > 0) {
            int n = this.items.size() - 1;
            this.items.clear();
            this.fireRemovedListModelListeners(0, n, bl);
            this.fireRemovedListModelListeners(new ArrayList<Object>(), bl);
        }
    }

    public void clearLockeds() {
        this.clearLockeds(false);
    }

    private void clearLockeds(boolean bl) {
        if (this.lockeds.size() == 0) {
            return;
        }
        this.lockeds.clear();
        this.fireRemoveLockListModelListeners(new ArrayList<Object>(), bl);
    }

    @Override
    public void addListLockListener(ListLockListener listLockListener) {
        this.listenerList.add(ListLockListener.class, listLockListener);
    }

    @Override
    public ListLockListener[] getListLockListeners() {
        return (ListLockListener[])this.listenerList.getListeners(ListLockListener.class);
    }

    @Override
    public void removeListLockListener(ListLockListener listLockListener) {
        this.listenerList.remove(ListLockListener.class, listLockListener);
    }

    @Override
    public void addLock(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!this.contains(object) || this.lockeds.contains(object)) continue;
            this.lockeds.add(object);
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            this.fireAddLockListModelListeners(arrayList, false);
        }
    }

    @Override
    public boolean isLocked(Object object) {
        return this.lockeds.contains(object);
    }

    @Override
    public void removeLock(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!this.lockeds.remove(object)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            this.fireRemoveLockListModelListeners(arrayList, false);
        }
    }

    @Override
    public void setLock(Object ... objectArray) {
        this.clearLockeds(true);
        this.addLock(objectArray);
    }

    @Override
    public List<Object> getLockeds() {
        return new ArrayList<Object>(this.lockeds);
    }

    private void clearCheckeds(boolean bl) {
        if (this.checkeds.size() == 0) {
            return;
        }
        this.checkeds.clear();
        this.fireRemoveCheckListModelListeners(new ArrayList<Object>(), bl);
    }

    @Override
    public void addListCheckListener(ListCheckListener listCheckListener) {
        this.listenerList.add(ListCheckListener.class, listCheckListener);
    }

    @Override
    public ListCheckListener[] getListCheckListeners() {
        return (ListCheckListener[])this.listenerList.getListeners(ListCheckListener.class);
    }

    @Override
    public void removeListCheckListener(ListCheckListener listCheckListener) {
        this.listenerList.remove(ListCheckListener.class, listCheckListener);
    }

    @Override
    public void addCheck(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!this.contains(object) || this.checkeds.contains(object)) continue;
            this.checkeds.add(object);
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            this.fireAddCheckListModelListeners(arrayList, false);
        }
    }

    @Override
    public boolean isChecked(Object object) {
        return this.checkeds.contains(object);
    }

    @Override
    public void removeCheck(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!this.checkeds.remove(object)) continue;
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            this.fireRemoveCheckListModelListeners(arrayList, false);
        }
    }

    @Override
    public void setCheck(Object ... objectArray) {
        this.clearCheckeds(true);
        this.addCheck(objectArray);
    }

    @Override
    public List<Object> getCheckeds() {
        return new ArrayList<Object>(this.checkeds);
    }

    @Override
    public void addElement(int n, Object object) {
        if (n >= 0 && n <= this.items.size() && !this.items.contains(object)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.items.add(n, object);
            arrayList.add(object);
            this.fireAddedListModelListeners(arrayList, n, n, false);
        }
    }

    @Override
    public void setElement(Object ... objectArray) {
        this.clear(true);
        this.addElement(objectArray);
    }

    @Override
    public void addElement(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            this.items.add(object);
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            int n = this.items.size();
            int n2 = n - 1 + arrayList.size();
            this.fireAddedListModelListeners(arrayList, n, n2, false);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.items.contains(object);
    }

    @Override
    public void removeElement(Object ... objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (Object object : objectArray) {
            hashMap.put(object, this.items.indexOf(object));
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (!this.items.remove(object)) continue;
            arrayList.add(hashMap.get(object));
            arrayList2.add(object);
            this.lockeds.remove(object);
            this.checkeds.remove(object);
        }
        if (arrayList2.size() > 0) {
            Collections.sort(arrayList);
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (n == -1) {
                    n2 = n = ((Integer)arrayList.get(i)).intValue();
                } else if ((Integer)arrayList.get(i) > n2 + 1) {
                    this.fireRemovedListModelListeners(n, n2, true);
                    n2 = n = ((Integer)arrayList.get(i)).intValue();
                } else {
                    n2 = (Integer)arrayList.get(i);
                }
                if (i != arrayList.size() - 1) continue;
                this.fireRemovedListModelListeners(n, n2, false);
            }
            this.fireRemovedListModelListeners(arrayList2, false);
        }
    }

    @Override
    public Object getElementAt(int n) {
        return this.items.get(n);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public void addListModelListener(ListModelListener listModelListener) {
        this.listenerList.add(ListModelListener.class, listModelListener);
    }

    @Override
    public ListModelListener[] getListModelListeners() {
        return (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
    }

    @Override
    public void removeListModelListener(ListModelListener listModelListener) {
        this.listenerList.remove(ListModelListener.class, listModelListener);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(ListDataListener.class, listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(ListDataListener.class, listDataListener);
    }

    @Override
    public void removeChecks() {
        ArrayList<Object> arrayList = null;
        if (this.listenerList.getListenerCount(ListCheckListener.class) > 0) {
            arrayList = new ArrayList<Object>(this.checkeds);
        }
        this.checkeds.clear();
        if (arrayList != null) {
            this.fireRemoveCheckListModelListeners(arrayList, false);
        }
    }

    @Override
    public void removeLocks() {
        ArrayList<Object> arrayList = null;
        if (this.listenerList.getListenerCount(ListLockListener.class) > 0) {
            arrayList = new ArrayList<Object>(this.checkeds);
        }
        this.lockeds.clear();
        if (arrayList != null) {
            this.fireRemoveLockListModelListeners(arrayList, false);
        }
    }

    @Override
    public int getLocksCount() {
        return this.lockeds.size();
    }

    @Override
    public int getChecksCount() {
        return this.checkeds.size();
    }

    @Override
    public void checkAll() {
        ArrayList<Object> arrayList = null;
        if (this.listenerList.getListenerCount(ListCheckListener.class) > 0) {
            arrayList = new ArrayList<Object>(this.items);
        }
        this.checkeds.clear();
        this.checkeds.addAll(this.items);
        if (arrayList != null) {
            this.fireAddCheckListModelListeners(arrayList, false);
        }
    }

    @Override
    public void lockAll() {
        ArrayList<Object> arrayList = null;
        if (this.listenerList.getListenerCount(ListLockListener.class) > 0) {
            arrayList = new ArrayList<Object>(this.items);
        }
        this.lockeds.clear();
        this.lockeds.addAll(this.items);
        if (arrayList != null) {
            this.fireAddLockListModelListeners(arrayList, false);
        }
    }
}

