/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.japura.gui.event.DateEvent;
import org.japura.gui.event.DateListener;
import org.japura.util.date.DateMask;
import org.japura.util.date.DateSeparator;
import org.japura.util.date.DateUtil;

public class DateDocument
extends PlainDocument {
    private static final long serialVersionUID = 3692487946320420981L;
    private DateSeparator separator;
    private DateMask mask;
    private Locale locale;
    private String regex;
    private boolean autoCompleteEnabled = true;
    private Date oldDate;
    private boolean oldDateSetted;

    public DateDocument() {
        this((Locale)null, (DateSeparator)null);
    }

    public DateDocument(Locale locale, DateSeparator dateSeparator) {
        this.separator = dateSeparator == null ? DateSeparator.SLASH : dateSeparator;
        this.mask = DateMask.getMask(locale);
        this.regex = this.buildRegex();
        this.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.mask = DateMask.getMask(locale);
    }

    public DateSeparator getSeparator() {
        return this.separator;
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public void setAutoCompleteEnabled(boolean bl) {
        this.autoCompleteEnabled = bl;
    }

    private String buildRegex() {
        String string = "([0-9]{1,4})?";
        String string2 = "([0-9]{1,2})?";
        String string3 = "(\\" + this.getSeparator().getSeparatorString() + ")?";
        String string4 = "";
        if (this.mask == DateMask.MMDDYYYY || this.mask == DateMask.DDMMYYYY) {
            string4 = string2 + string3 + string2 + string3 + string;
        } else if (this.mask == DateMask.YYYYMMDD || this.mask == DateMask.YYYYDDMM) {
            string4 = string + string3 + string2 + string3 + string2;
        }
        return string4;
    }

    public boolean isValid() {
        return this.getDate() != null;
    }

    private GregorianCalendar getGregorianCalendar() {
        Date date = this.getDate();
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(date.getTime());
            return gregorianCalendar;
        }
        return null;
    }

    public Integer getDay() {
        GregorianCalendar gregorianCalendar = this.getGregorianCalendar();
        if (gregorianCalendar != null) {
            return gregorianCalendar.get(5);
        }
        return null;
    }

    public Integer getMonth() {
        GregorianCalendar gregorianCalendar = this.getGregorianCalendar();
        if (gregorianCalendar != null) {
            return gregorianCalendar.get(2) + 1;
        }
        return null;
    }

    public Integer getYear() {
        GregorianCalendar gregorianCalendar = this.getGregorianCalendar();
        if (gregorianCalendar != null) {
            return gregorianCalendar.get(1);
        }
        return null;
    }

    public Date getDate() {
        try {
            String string = this.getText(0, this.getLength());
            Date date = DateUtil.toDate(string, this.locale, this.getSeparator());
            if (date != null) {
                return date;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return null;
    }

    public void setDate(int n, int n2, int n3) {
        try {
            this.replace(0, this.getLength(), DateUtil.toString(this.mask, this.getSeparator(), n, n2, n3), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void clear() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setDate(long l) {
        try {
            this.replace(0, this.getLength(), DateUtil.toString(this.locale, this.getSeparator(), l), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void setToCurrentDate() {
        this.setDate(System.currentTimeMillis());
    }

    private String buildCompletedText(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "\\" + this.separator.getSeparatorString();
        if (this.mask == DateMask.DDMMYYYY || this.mask == DateMask.MMDDYYYY) {
            string3 = "[0-9]{2}";
            string4 = "[0-9]{2}" + string7 + "[0-9]{2}";
            string5 = "[0-9]{1,2}(" + string7 + "([0-9]{1,4})?)?";
            string6 = "[0-9]{1,4}";
        } else if (this.mask == DateMask.YYYYMMDD || this.mask == DateMask.YYYYDDMM) {
            string3 = "[0-9]{4}";
            string5 = "[0-9]{1,2}(" + string7 + "([0-9]{1,2})?)?";
            string4 = "[0-9]{4}" + string7 + "[0-9]{2}";
            string6 = "[0-9]{1,2}";
        }
        if (string.matches(string3) && string2.matches(string5) || string.matches(string4) && string2.matches(string6)) {
            return this.separator.getSeparatorString() + string2;
        }
        return string2;
    }

    public DateMask getMask() {
        return this.mask;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        this.oldDate = this.getDate();
        super.remove(n, n2);
        if (this.getCurrentWriter() == null) {
            this.fireListeners(this.oldDate, this.getDate());
        } else {
            this.oldDateSetted = true;
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = null;
        if (this.getLength() > 0) {
            String string3 = this.getText(0, this.getLength());
            if (this.isAutoCompleteEnabled() && n == this.getLength()) {
                string = this.buildCompletedText(string3, string);
            }
            string2 = string3.substring(0, n) + string + string3.substring(n, this.getLength());
        } else {
            if (this.isAutoCompleteEnabled() && n == this.getLength()) {
                string = this.buildCompletedText("", string);
            }
            string2 = string;
        }
        if (string2.matches(this.regex)) {
            if (!this.oldDateSetted) {
                this.oldDate = this.getDate();
            }
            super.insertString(n, string, attributeSet);
            this.fireListeners(this.oldDate, this.getDate());
        }
    }

    protected void fireListeners(Date date, Date date2) {
        DateListener[] dateListenerArray;
        DateEvent dateEvent = new DateEvent(date2, date);
        for (DateListener dateListener : dateListenerArray = (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            dateListener.dateChanged(dateEvent);
        }
        date = null;
        this.oldDateSetted = false;
    }

    public void addDateListener(DateListener dateListener) {
        this.listenerList.add(DateListener.class, dateListener);
    }

    public void removeDateListener(DateListener dateListener) {
        this.listenerList.remove(DateListener.class, dateListener);
    }
}

