/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.japura.gui.CheckList;
import org.japura.gui.model.ListCheckModel;

public class CheckListTransferable
implements Transferable {
    public static final DataFlavor CHECKEDS_LIST_FLAVOR = new DataFlavor(ArrayList.class, "CHECKEDS_LIST_FLAVOR");
    private ListCheckModel model;
    private Comparator<Object> comparator;
    private String separator;

    public static boolean isAvailableToTransfer(CheckList checkList) {
        ListCheckModel listCheckModel = checkList.getModel();
        if (listCheckModel.getChecksCount() == 0) {
            return false;
        }
        int n = checkList.getSelectedIndex();
        if (n == -1) {
            return false;
        }
        if (n >= listCheckModel.getSize()) {
            return false;
        }
        Object object = listCheckModel.getElementAt(n);
        return listCheckModel.isChecked(object);
    }

    public CheckListTransferable(CheckList checkList, String string, Comparator<Object> comparator) {
        this.model = checkList.getModel();
        this.separator = string;
        this.comparator = comparator;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CHECKEDS_LIST_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(CHECKEDS_LIST_FLAVOR) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    private List<Object> getCheckeds() {
        List<Object> list = this.model.getCheckeds();
        if (this.comparator != null) {
            Collections.sort(list, this.comparator);
        }
        return list;
    }

    public static String toString(ListCheckModel listCheckModel, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Object> list = listCheckModel.getCheckeds();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            stringBuilder.append(object.toString());
            if (string == null || i >= list.size() - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return CheckListTransferable.toString(this.model, this.separator);
        }
        if (dataFlavor.equals(CHECKEDS_LIST_FLAVOR)) {
            return new ArrayList<Object>(this.getCheckeds());
        }
        return null;
    }
}

