/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar.components;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.calendar.components.CalendarSlot;

public class DayOfWeekSlot
extends CalendarSlot
implements MouseListener {
    private static final long serialVersionUID = 7413497097851129819L;
    private DayOfWeek dayOfWeek;

    public DayOfWeekSlot(Calendar calendar, String string, DayOfWeek dayOfWeek) {
        super(calendar, CalendarComponentType.DAY_WEEK_HEADER);
        this.dayOfWeek = dayOfWeek;
        this.setBorder(this.buildBorder());
        this.setText(string);
        this.setFont(this.getCalendar().getPropertiesProvider().getDayOfWeekFont());
        this.addMouseListener(this);
    }

    private Border buildBorder() {
        PropertiesProvider propertiesProvider = this.getCalendar().getPropertiesProvider();
        Insets insets = propertiesProvider.getDayOfWeekMargin();
        int n = insets.top;
        int n2 = insets.left;
        int n3 = insets.bottom;
        int n4 = insets.right;
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, propertiesProvider.getTopDayOfWeekSeparatorColor());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, 0, 1, 0, propertiesProvider.getBottomDayOfWeekSeparatorColor());
        Border border = BorderFactory.createEmptyBorder(n, n2, n3, n4);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder2, matteBorder);
        return BorderFactory.createCompoundBorder(compoundBorder, border);
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Color getForeground() {
        if (this.dayOfWeek == null) {
            return super.getForeground();
        }
        return this.getCalendar().getPropertiesProvider().getForeground(this);
    }

    @Override
    public Color getBackground() {
        if (this.dayOfWeek == null) {
            return super.getBackground();
        }
        return this.getCalendar().getPropertiesProvider().getBackground(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        Calendar calendar;
        PopupMenuBuilder<CalendarComponent> popupMenuBuilder;
        if (SwingUtilities.isRightMouseButton(mouseEvent) && (popupMenuBuilder = (calendar = this.getCalendar()).getPopupMenuBuilder()) != null && (jPopupMenu = popupMenuBuilder.buildPopupMenu(this)) != null) {
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

