/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar.components;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.components.CalendarSlot;

public class DayOfMonthSlot
extends CalendarSlot
implements MouseListener {
    private static final long serialVersionUID = 2647751815341515373L;
    private int day;
    private int month;
    private int year;
    private boolean currentMonth;
    private boolean selected;

    public DayOfMonthSlot(Calendar calendar) {
        super(calendar, CalendarComponentType.DAY_MONTH);
        this.setBorder(this.buildBorder());
        this.addMouseListener(this);
        this.setFont(this.getCalendar().getPropertiesProvider().getDayOfMonthFont());
    }

    private Border buildBorder() {
        Insets insets = this.getCalendar().getPropertiesProvider().getDayOfMonthMargin();
        int n = insets.top;
        int n2 = insets.left;
        int n3 = insets.bottom;
        int n4 = insets.right;
        return BorderFactory.createEmptyBorder(n, n2, n3, n4);
    }

    public void setDate(int n, int n2, int n3) {
        this.day = n;
        this.month = n2;
        this.year = n3;
        this.setText(n + "");
    }

    @Override
    public Color getBackground() {
        Calendar calendar = this.getCalendar();
        if (calendar == null) {
            return super.getBackground();
        }
        return calendar.getPropertiesProvider().getBackground(this);
    }

    @Override
    public Color getForeground() {
        Calendar calendar = this.getCalendar();
        if (calendar == null) {
            return super.getForeground();
        }
        return calendar.getPropertiesProvider().getForeground(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Calendar calendar = this.getCalendar();
        if (!calendar.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            JPopupMenu jPopupMenu;
            PopupMenuBuilder<CalendarComponent> popupMenuBuilder = calendar.getPopupMenuBuilder();
            if (popupMenuBuilder != null && (jPopupMenu = popupMenuBuilder.buildPopupMenu(this)) != null) {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        if (!this.getCalendar().isDialogMode() && this.selected) {
            return;
        }
        long l = this.getDate().getTime();
        if (this.currentMonth && this.getCalendar().isDialogMode()) {
            this.getCalendar().disposeDialog(l);
        } else {
            this.getCalendar().setDate(l);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public DayOfWeek getDayOfWeek() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, this.year);
        gregorianCalendar.set(2, this.month);
        gregorianCalendar.set(5, this.day);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        int n = gregorianCalendar.get(7);
        return DayOfWeek.getDayOfWeek(n);
    }

    public Date getDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, this.year);
        gregorianCalendar.set(2, this.month);
        gregorianCalendar.set(5, this.day);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isCurrentMonth() {
        return this.currentMonth;
    }

    public int getDay() {
        return this.day;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setCurrentMonth(boolean bl) {
        this.currentMonth = bl;
    }
}

