/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.CalendarProperties;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.PropertiesProvider;

public class DefaultPropertiesProvider
implements PropertiesProvider {
    private CalendarProperties properties = new CalendarProperties();

    public CalendarProperties getProperties() {
        return this.properties;
    }

    @Override
    public Color getMouseOverForeground(CalendarComponent calendarComponent) {
        CalendarComponentType calendarComponentType = calendarComponent.getType();
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getMouseOverButtonColor();
        }
        return Color.LIGHT_GRAY;
    }

    @Override
    public Color getDisabledForeground(CalendarComponent calendarComponent) {
        CalendarComponentType calendarComponentType = calendarComponent.getType();
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getDisabledButtonColor();
        }
        return Color.LIGHT_GRAY;
    }

    @Override
    public Color getForeground(CalendarComponent calendarComponent) {
        CalendarComponentType calendarComponentType = calendarComponent.getType();
        Calendar calendar = calendarComponent.getCalendar();
        if (calendarComponentType.equals((Object)CalendarComponentType.DAY_MONTH)) {
            if (calendar.isSelected(calendarComponent)) {
                return this.getProperties().getSelectedDayOfMonthForeground();
            }
            if (calendar.isCurrentMonth(calendarComponent)) {
                return this.getProperties().getDayOfMonthForeground();
            }
            return this.getProperties().getDayOfNonCurrentMonthForeground();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.DAY_WEEK_HEADER)) {
            DayOfWeek dayOfWeek = calendar.getDayOfWeek(calendarComponent);
            return this.getProperties().getDayOfWeekForeground(dayOfWeek);
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_YEAR_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.PREVIOUS_MONTH_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_YEAR_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.NEXT_MONTH_BUTTON)) {
            return this.getProperties().getButtonColor();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.MONTH_LABEL)) {
            return this.getProperties().getMonthForeground();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.YEAR_LABEL)) {
            return this.getProperties().getYearForeground();
        }
        return Color.BLACK;
    }

    @Override
    public Color getBackground(CalendarComponent calendarComponent) {
        CalendarComponentType calendarComponentType = calendarComponent.getType();
        Calendar calendar = calendarComponent.getCalendar();
        if (calendarComponentType.equals((Object)CalendarComponentType.DAY_MONTH)) {
            if (calendar.isSelected(calendarComponent)) {
                return this.getProperties().getSelectedDayOfMonthBackground();
            }
            if (calendar.isCurrentMonth(calendarComponent)) {
                return this.getProperties().getDayOfMonthBackground();
            }
            return this.getProperties().getDayOfNonCurrentMonthBackground();
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.DAY_WEEK_HEADER)) {
            DayOfWeek dayOfWeek = calendar.getDayOfWeek(calendarComponent);
            return this.getProperties().getDayOfWeekBackground(dayOfWeek);
        }
        if (calendarComponentType.equals((Object)CalendarComponentType.TOP_BAR)) {
            return this.getProperties().getTopBarBackground();
        }
        return Color.WHITE;
    }

    @Override
    public DayOfWeek getStartDayOfWeek() {
        return this.getProperties().getStartDayOfWeek();
    }

    @Override
    public Insets getDayOfMonthMargin() {
        return this.getProperties().getDayOfMonthMargin();
    }

    @Override
    public Font getDayOfMonthFont() {
        return this.getProperties().getDayOfMonthFont();
    }

    @Override
    public Insets getDayOfWeekMargin() {
        return this.getProperties().getDayOfWeekMargin();
    }

    @Override
    public Font getDayOfWeekFont() {
        return this.getProperties().getDayOfWeekFont();
    }

    @Override
    public Color getTopDayOfWeekSeparatorColor() {
        return this.getProperties().getTopDayOfWeekSeparatorColor();
    }

    @Override
    public Color getBottomDayOfWeekSeparatorColor() {
        return this.getProperties().getBottomDayOfWeekSeparatorColor();
    }
}

